/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.generator.DistributionContentItem;
import org.jboss.as.patching.generator.DistributionItemImpl;
import org.jboss.as.patching.generator.DistributionStructure;

class DistributionStructureImpl
implements DistributionStructure {
    private static final String PATH_DELIMITER = "/";
    private final DistributionContentItem ROOT;
    private final DistributionContentItem MODULES;
    private final DistributionContentItem BUNDLES;
    private final Set<DistributionContentItem> moduleSearchPath = new TreeSet<DistributionContentItem>();
    private final Set<DistributionContentItem> bundleSearchPath = new TreeSet<DistributionContentItem>();
    private final List<DistributionContentItem.Filter> ignored = new ArrayList<DistributionContentItem.Filter>();

    protected DistributionStructureImpl(DistributionContentItem root) {
        this.ROOT = root;
        this.MODULES = DistributionStructureImpl.createMiscItem(root, "modules");
        this.BUNDLES = DistributionStructureImpl.createMiscItem(root, "bundles");
        this.moduleSearchPath.add(this.MODULES);
        this.bundleSearchPath.add(this.BUNDLES);
        this.registerIgnoredPath("bin/product.conf");
        this.registerIgnoredPath("modules/layers.conf");
        this.registerIgnoredPath("bundles/layers.conf");
        this.registerIgnoredPath("appclient/configuration**");
        this.registerIgnoredPath("appclient/data**");
        this.registerIgnoredPath("appclient/log**");
        this.registerIgnoredPath("appclient/tmp**");
        this.registerIgnoredPath("domain/configuration**");
        this.registerIgnoredPath("domain/data**");
        this.registerIgnoredPath("domain/log**");
        this.registerIgnoredPath("domain/servers**");
        this.registerIgnoredPath("domain/tmp**");
        this.registerIgnoredPath("standalone/configuration**");
        this.registerIgnoredPath("standalone/data**");
        this.registerIgnoredPath("standalone/log**");
        this.registerIgnoredPath("standalone/tmp**");
    }

    @Override
    public void registerStandardModuleSearchPath(String name, String standardPath) {
        this.moduleSearchPath.add(DistributionStructureImpl.createMiscItem(this.ROOT, standardPath));
    }

    @Override
    public void excludeDefaultModuleRoot() {
        this.moduleSearchPath.remove(this.MODULES);
    }

    @Override
    public void registerStandardBundleSearchPath(String name, String standardPath) {
        this.bundleSearchPath.add(DistributionStructureImpl.createMiscItem(this.ROOT, standardPath));
    }

    @Override
    public void excludeDefaultBundleRoot() {
        this.bundleSearchPath.remove(this.BUNDLES);
    }

    @Override
    public void registerIgnoredPath(String path) {
        DistributionContentItem.GlobPathFilter filter = new DistributionContentItem.GlobPathFilter(path);
        this.ignored.add(filter);
    }

    @Override
    public boolean isModuleLookupPath(DistributionContentItem item) {
        return this.moduleSearchPath.contains(item);
    }

    @Override
    public boolean isBundleLookupPath(DistributionContentItem item) {
        return this.bundleSearchPath.contains(item);
    }

    @Override
    public boolean isIgnored(DistributionContentItem item) {
        for (DistributionContentItem.Filter filter : this.ignored) {
            if (!filter.accept(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCompatibleWith(DistributionStructure other) {
        return this.getClass().equals(other.getClass());
    }

    static DistributionContentItem createMiscItem(DistributionContentItem parent, String path) {
        DistributionContentItem result = parent;
        String[] s = path.split(PATH_DELIMITER);
        int length = s.length;
        for (int i = 0; i < length; ++i) {
            boolean dir = i < length - 1;
            result = new DistributionItemImpl(result, s[i], IoUtils.NO_CONTENT, IoUtils.NO_CONTENT, !dir);
        }
        return result;
    }
}

