/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jboss.as.patching.HashUtils;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.PatchLogger;
import org.jboss.as.patching.metadata.BundleItem;
import org.jboss.as.patching.metadata.ContentType;
import org.jboss.as.patching.metadata.ModificationType;
import org.jboss.as.patching.metadata.ModuleItem;
import org.jboss.as.patching.runner.AbstractPatchingTask;
import org.jboss.as.patching.runner.PatchContentLoader;
import org.jboss.as.patching.runner.PatchingTaskContext;
import org.jboss.as.patching.runner.PatchingTaskDescription;

abstract class AbstractModuleTask
extends AbstractPatchingTask<ModuleItem> {
    static final String MODULE_XML = "module.xml";

    AbstractModuleTask(PatchingTaskDescription description) {
        super(description, ModuleItem.class);
    }

    @Override
    byte[] backup(PatchingTaskContext context) throws IOException {
        File[] repoRoots = context.getTargetModulePath();
        String moduleName = ((ModuleItem)this.contentItem).getName();
        String slot = ((ModuleItem)this.contentItem).getSlot();
        for (File path : repoRoots) {
            File modulePath = PatchContentLoader.getModulePath(path, moduleName, slot);
            File moduleXml = new File(modulePath, MODULE_XML);
            if (!moduleXml.exists()) continue;
            PatchLogger.ROOT_LOGGER.debugf("found in path (%s)", moduleXml.getAbsolutePath());
            context.invalidateRoot(modulePath);
            return HashUtils.hashFile(modulePath);
        }
        return this.notFound((ModuleItem)this.contentItem);
    }

    protected byte[] notFound(ModuleItem contentItem) throws IOException {
        if (this.description.getModificationType() == ModificationType.ADD) {
            return IoUtils.NO_CONTENT;
        }
        throw new FileNotFoundException(contentItem.toString() + " " + (Object)((Object)this.description.getModificationType()));
    }

    static ModuleItem createContentItem(ModuleItem original, byte[] contentHash) {
        ContentType type = original.getContentType();
        if (type == ContentType.BUNDLE) {
            return new BundleItem(original.getName(), original.getSlot(), contentHash);
        }
        return new ModuleItem(original.getName(), original.getSlot(), contentHash);
    }
}

