/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.installation;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.patching.DirectoryStructure;
import org.jboss.as.patching.PatchMessages;
import org.jboss.as.patching.installation.AddOn;
import org.jboss.as.patching.installation.Identity;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.installation.InstalledIdentityImpl;
import org.jboss.as.patching.installation.InstalledImage;
import org.jboss.as.patching.installation.Layer;
import org.jboss.as.patching.installation.LayerDirectoryStructure;
import org.jboss.as.patching.installation.LayerInfo;
import org.jboss.as.patching.installation.LayersConfig;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.version.ProductConfig;

class LayersFactory {
    LayersFactory() {
    }

    static InstalledIdentity load(final InstalledImage image, ProductConfig productConfig, List<File> moduleRoots, List<File> bundleRoots) throws IOException {
        String name;
        final String productVersion = productConfig.resolveVersion();
        final String productName = productConfig.resolveName();
        AbstractLazyIdentity identity = new AbstractLazyIdentity(){

            @Override
            public String getName() {
                return productName;
            }

            @Override
            public String getVersion() {
                return productVersion;
            }

            @Override
            public InstalledImage getInstalledImage() {
                return image;
            }
        };
        InstalledConfiguration conf = LayersFactory.createInstalledConfig(image);
        ProcessedLayers processedLayers = LayersFactory.process(conf, moduleRoots, bundleRoots);
        InstalledConfiguration config = processedLayers.getConf();
        InstalledIdentityImpl installedIdentity = new InstalledIdentityImpl(identity, image);
        for (LayerPathConfig layer : processedLayers.getLayers().values()) {
            name = layer.name;
            installedIdentity.putLayer(name, LayersFactory.createPatchableTarget(name, layer, config.getLayerMetadataDir(name), image));
        }
        for (LayerPathConfig addOn : processedLayers.getAddOns().values()) {
            name = addOn.name;
            installedIdentity.putAddOn(name, LayersFactory.createPatchableTarget(name, addOn, config.getAddOnMetadataDir(name), image));
        }
        return installedIdentity;
    }

    static ProcessedLayers process(InstalledConfiguration conf, List<File> moduleRoots, List<File> bundleRoots) throws IOException {
        ProcessedLayers layers = new ProcessedLayers(conf);
        LayerPathSetter moduleSetter = new LayerPathSetter(){

            @Override
            public boolean setPath(LayerPathConfig pending, File root) {
                if (pending.modulePath == null) {
                    pending.modulePath = root;
                    return true;
                }
                return false;
            }
        };
        for (File moduleRoot : moduleRoots) {
            LayersFactory.processRoot(moduleRoot, layers, moduleSetter);
        }
        LayerPathSetter bundleSetter = new LayerPathSetter(){

            @Override
            public boolean setPath(LayerPathConfig pending, File root) {
                if (pending.bundlePath == null) {
                    pending.bundlePath = root;
                    return true;
                }
                return false;
            }
        };
        for (File bundleRoot : bundleRoots) {
            LayersFactory.processRoot(bundleRoot, layers, bundleSetter);
        }
        return layers;
    }

    static void processRoot(File root, ProcessedLayers layers, LayerPathSetter setter) throws IOException {
        File addOnsDir;
        File[] addOnsList;
        LayersConfig layersConfig = LayersConfig.getLayersConfig(root);
        File layersDir = new File(root, layersConfig.getLayersPath());
        if (!layersDir.exists()) {
            if (layersConfig.isConfigured()) {
                throw PatchMessages.MESSAGES.installationNoLayersConfigFound(layersDir.getAbsolutePath());
            }
        } else {
            for (String layer : layersConfig.getLayers()) {
                File layerDir = new File(layersDir, layer);
                if (!layerDir.exists()) {
                    if (layersConfig.isConfigured()) {
                        throw PatchMessages.MESSAGES.installationMissingLayer(layer, layersDir.getAbsolutePath());
                    }
                    return;
                }
                layers.addLayer(layer, layerDir, setter);
            }
        }
        if ((addOnsList = (addOnsDir = new File(root, layersConfig.getAddOnsPath())).listFiles()) != null) {
            for (File addOn : addOnsList) {
                layers.addAddOn(addOn.getName(), addOn, setter);
            }
        }
    }

    static AbstractLazyPatchableTarget createPatchableTarget(final String name, final LayerPathConfig layer, final File metadata, final InstalledImage image) throws IOException {
        return new AbstractLazyPatchableTarget(){

            @Override
            public InstalledImage getInstalledImage() {
                return image;
            }

            @Override
            public File getModuleRoot() {
                return layer.modulePath;
            }

            @Override
            public File getBundleRepositoryRoot() {
                return layer.bundlePath;
            }

            @Override
            public File getPatchesMetadata() {
                return metadata;
            }

            @Override
            public String getName() {
                return name;
            }
        };
    }

    static InstalledConfiguration createInstalledConfig(InstalledImage image) {
        InstalledConfiguration conf = new InstalledConfiguration(image);
        return conf;
    }

    static abstract class AbstractLazyIdentity
    extends LayerDirectoryStructure.IdentityDirectoryStructure
    implements Identity {
        AbstractLazyIdentity() {
        }

        @Override
        public DirectoryStructure getDirectoryStructure() {
            return this;
        }

        @Override
        public PatchableTarget.TargetInfo loadTargetInfo() throws IOException {
            return LayerInfo.loadTargetInfoFromDisk(this.getDirectoryStructure());
        }
    }

    static abstract class AbstractLazyPatchableTarget
    extends LayerDirectoryStructure
    implements Layer,
    AddOn {
        AbstractLazyPatchableTarget() {
        }

        @Override
        File getPatchesMetadata() {
            return this.getPatchesMetadata(this.getName());
        }

        @Override
        public DirectoryStructure getDirectoryStructure() {
            return this;
        }

        @Override
        public PatchableTarget.TargetInfo loadTargetInfo() throws IOException {
            return LayerInfo.loadTargetInfoFromDisk(this.getDirectoryStructure());
        }
    }

    static class InstalledConfiguration {
        final File metadata;
        final InstalledImage installedImage;
        final Set<String> installedLayers = new HashSet<String>();
        final Set<String> installedAddOns = new HashSet<String>();

        InstalledConfiguration(InstalledImage installedImage) {
            this.metadata = installedImage.getInstallationMetadata();
            this.installedImage = installedImage;
        }

        File getLayersMetadataDir() {
            return new File(this.metadata, "layers");
        }

        File getLayerMetadataDir(String name) {
            return new File(this.getLayersMetadataDir(), name);
        }

        File getAddOnsMetadataDir() {
            return new File(this.metadata, "add-ons");
        }

        File getAddOnMetadataDir(String name) {
            return new File(this.getAddOnsMetadataDir(), name);
        }

        Set<String> getInstalledLayers() {
            return this.installedLayers;
        }

        Set<String> getInstalledAddOns() {
            return this.installedAddOns;
        }
    }

    static class ProcessedLayers {
        private final InstalledConfiguration conf;
        private final Map<String, LayerPathConfig> layers = new LinkedHashMap<String, LayerPathConfig>();
        private final Map<String, LayerPathConfig> addOns = new LinkedHashMap<String, LayerPathConfig>();

        ProcessedLayers(InstalledConfiguration conf) {
            this.conf = conf;
        }

        InstalledConfiguration getConf() {
            return this.conf;
        }

        Map<String, LayerPathConfig> getLayers() {
            return this.layers;
        }

        Map<String, LayerPathConfig> getAddOns() {
            return this.addOns;
        }

        void addLayer(String name, File root, LayerPathSetter setter) {
            LayerPathConfig pending = this.layers.get(name);
            if (pending == null) {
                pending = new LayerPathConfig(name);
                this.layers.put(name, pending);
            }
            if (!setter.setPath(pending, root)) {
                throw PatchMessages.MESSAGES.installationDuplicateLayer("layer", name);
            }
        }

        void addAddOn(String name, File root, LayerPathSetter setter) {
            LayerPathConfig pending = this.addOns.get(name);
            if (pending == null) {
                pending = new LayerPathConfig(name);
                this.addOns.put(name, pending);
            }
            if (!setter.setPath(pending, root)) {
                throw PatchMessages.MESSAGES.installationDuplicateLayer("add-on", name);
            }
        }
    }

    static interface LayerPathSetter {
        public boolean setPath(LayerPathConfig var1, File var2);
    }

    static class LayerPathConfig {
        File modulePath;
        File bundlePath;
        final String name;

        LayerPathConfig(String name) {
            this.name = name;
        }
    }
}

