/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.installation;

import java.io.File;
import org.jboss.as.patching.DirectoryStructure;
import org.jboss.as.patching.PatchMessages;

abstract class LayerDirectoryStructure
extends DirectoryStructure {
    LayerDirectoryStructure() {
    }

    abstract File getPatchesMetadata();

    protected File getPatchesMetadata(String name) {
        File root = this.getModuleRoot();
        if (root == null) {
            root = this.getBundleRepositoryRoot();
        }
        if (root == null) {
            throw PatchMessages.MESSAGES.installationInvalidLayerConfiguration(name);
        }
        return root;
    }

    @Override
    public File getInstallationInfo() {
        return new File(this.getPatchesMetadata(), "layer.conf");
    }

    @Override
    public File getBundlesPatchDirectory(String patchId) {
        if (this.getBundleRepositoryRoot() == null) {
            return null;
        }
        File patches = new File(this.getBundleRepositoryRoot(), ".overlays");
        return new File(patches, patchId);
    }

    @Override
    public File getModulePatchDirectory(String patchId) {
        if (this.getModuleRoot() == null) {
            return null;
        }
        File patches = new File(this.getModuleRoot(), ".overlays");
        return new File(patches, patchId);
    }

    static abstract class IdentityDirectoryStructure
    extends LayerDirectoryStructure {
        IdentityDirectoryStructure() {
        }

        @Override
        public final File getBundleRepositoryRoot() {
            return null;
        }

        @Override
        public final File getModuleRoot() {
            return null;
        }

        @Override
        public File getInstallationInfo() {
            return new File(this.getPatchesMetadata(), "identity.conf");
        }

        @Override
        protected File getPatchesMetadata() {
            return this.getInstalledImage().getInstallationMetadata();
        }
    }
}

