/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.reactive.messaging.config;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import org.wildfly.microprofile.reactive.messaging.config.TracingType;
import org.wildfly.microprofile.reactive.messaging.config._private.MicroProfileReactiveMessagingConfigLogger;

class TracingTypeInterceptor
implements ConfigSourceInterceptor {
    private static final String SMALLRYE_AMQP = "smallrye-amqp";
    private static final String SMALLRYE_KAFKA = "smallrye-kafka";
    private static final String TRACING_ENABLED = ".tracing-enabled";
    private static final String CONNECTOR = ".connector";
    private static final String MP_MESSAGING_PREFIX = "mp.messaging.";
    private static final String CONNECTOR_PREFIX = "mp.messaging.connector.";
    private static final String INCOMING_PREFIX = "mp.messaging.incoming.";
    private static final String OUTGOING_PREFIX = "mp.messaging.outgoing.";
    private final TracingType amqpTracingType;
    private final TracingType kafkaTracingType;

    TracingTypeInterceptor(TracingType amqpTracingType, TracingType kafkaTracingType) {
        this.amqpTracingType = amqpTracingType;
        this.kafkaTracingType = kafkaTracingType;
    }

    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        if (name.startsWith(MP_MESSAGING_PREFIX) && name.endsWith(TRACING_ENABLED)) {
            TracingEnabledContext tracingContext = new TracingEnabledContext(context, name);
            return tracingContext.handleTracingProperty();
        }
        return context.proceed(name);
    }

    private class TracingEnabledContext {
        final ConfigSourceInterceptorContext interceptorContext;
        final String name;
        Connector connector;
        String channel;
        private TracingType tracingType;

        TracingEnabledContext(ConfigSourceInterceptorContext context, String name) {
            this.interceptorContext = context;
            this.name = name;
        }

        private ConfigValue handleTracingProperty() {
            this.determineConnectorAndTracingType();
            ConfigValue value = this.interceptorContext.proceed(this.name);
            if (this.tracingType == null) {
                return value;
            }
            switch (this.tracingType) {
                case NEVER: {
                    this.logTracingTypeOverridesProperty(this.tracingType, value);
                    return this.configValue(this.name, Boolean.FALSE);
                }
                case ALWAYS: {
                    this.logTracingTypeOverridesProperty(this.tracingType, value);
                    return this.configValue(this.name, Boolean.TRUE);
                }
                case OFF: {
                    return this.defaultIfNotSetAndNotChannel(this.name, value, Boolean.FALSE);
                }
                case ON: {
                    return this.defaultIfNotSetAndNotChannel(this.name, value, Boolean.TRUE);
                }
            }
            return null;
        }

        private void logTracingTypeOverridesProperty(TracingType type, ConfigValue value) {
            if (value != null && value.getValue() != null) {
                String fromTracingType;
                String string = fromTracingType = type == TracingType.NEVER ? "false" : "true";
                if (!value.getValue().equals(fromTracingType)) {
                    String attributeName = this.getConnectorAttributeName();
                    MicroProfileReactiveMessagingConfigLogger.LOGGER.tracingTypeOverridesProperty(this.name, value.getValue(), attributeName, type, fromTracingType);
                }
            }
        }

        private String getConnectorAttributeName() {
            switch (this.connector) {
                case AMQP: {
                    return "amqp-connector";
                }
                case KAFKA: {
                    return "kafka-connector";
                }
            }
            return null;
        }

        private ConfigValue defaultIfNotSetAndNotChannel(String name, ConfigValue foundValue, Boolean defaultValue) {
            ConfigValue.ConfigValueBuilder builder;
            if (foundValue != null && foundValue.getValue() != null) {
                return foundValue;
            }
            ConfigValue.ConfigValueBuilder configValueBuilder = builder = foundValue == null ? new ConfigValue.ConfigValueBuilder().withName(name) : foundValue.from();
            if (this.channel == null) {
                builder.withValue(defaultValue.toString());
            }
            return builder.build();
        }

        private ConfigValue configValue(String name, Boolean value) {
            return new ConfigValue.ConfigValueBuilder().withName(name).withValue(value == null ? null : value.toString()).build();
        }

        private void determineConnectorAndTracingType() {
            if (this.name.startsWith(TracingTypeInterceptor.CONNECTOR_PREFIX)) {
                this.connector = Connector.fromName(this.stripPrefixAndTracingEnabledSuffix(this.name, TracingTypeInterceptor.CONNECTOR_PREFIX));
            } else {
                String channelConnectorProperty;
                ConfigValue value;
                String prefix = null;
                if (this.name.startsWith(TracingTypeInterceptor.INCOMING_PREFIX)) {
                    prefix = TracingTypeInterceptor.INCOMING_PREFIX;
                    this.channel = this.stripPrefixAndTracingEnabledSuffix(this.name, TracingTypeInterceptor.INCOMING_PREFIX);
                } else if (this.name.startsWith(TracingTypeInterceptor.OUTGOING_PREFIX)) {
                    prefix = TracingTypeInterceptor.OUTGOING_PREFIX;
                    this.channel = this.stripPrefixAndTracingEnabledSuffix(this.name, TracingTypeInterceptor.OUTGOING_PREFIX);
                }
                if (prefix != null && (value = this.interceptorContext.restart(channelConnectorProperty = prefix + this.channel + TracingTypeInterceptor.CONNECTOR)) != null) {
                    String connector = value.getValue();
                    this.connector = Connector.fromName(connector);
                }
            }
            if (this.connector != null) {
                switch (this.connector) {
                    case AMQP: {
                        this.tracingType = TracingTypeInterceptor.this.amqpTracingType;
                        break;
                    }
                    case KAFKA: {
                        this.tracingType = TracingTypeInterceptor.this.kafkaTracingType;
                    }
                }
            }
        }

        private String stripPrefixAndTracingEnabledSuffix(String name, String prefix) {
            String temp = name.substring(prefix.length());
            int index = temp.indexOf(TracingTypeInterceptor.TRACING_ENABLED);
            return temp.substring(0, index);
        }
    }

    private static enum Connector {
        AMQP,
        KAFKA;


        static Connector fromName(String name) {
            if (name.equals(TracingTypeInterceptor.SMALLRYE_AMQP)) {
                return AMQP;
            }
            if (name.equals(TracingTypeInterceptor.SMALLRYE_KAFKA)) {
                return KAFKA;
            }
            return null;
        }
    }
}

