/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.openapi.deployment;

import io.smallrye.openapi.api.SmallRyeOpenAPI;
import io.undertow.server.HttpHandler;
import java.util.List;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.wildfly.extension.microprofile.openapi.deployment.OpenAPIEndpointConfiguration;
import org.wildfly.extension.microprofile.openapi.deployment.OpenAPIHttpHandler;
import org.wildfly.extension.microprofile.openapi.deployment.OpenAPIModelConfiguration;
import org.wildfly.extension.microprofile.openapi.logging.MicroProfileOpenAPILogger;
import org.wildfly.extension.undertow.Host;
import org.wildfly.service.Installer;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.service.DeploymentServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class OpenAPIHttpHandlerServiceInstaller
implements DeploymentServiceInstaller {
    private final OpenAPIEndpointConfiguration configuration;

    public OpenAPIHttpHandlerServiceInstaller(OpenAPIEndpointConfiguration configuration) {
        this.configuration = configuration;
    }

    public void install(DeploymentPhaseContext context) {
        String serverName = this.configuration.getServerName();
        String hostName = this.configuration.getHostName();
        final String path = this.configuration.getPath();
        final ServiceDependency host = ServiceDependency.on((BinaryServiceDescriptor)Host.SERVICE_DESCRIPTOR, (String)serverName, (String)hostName);
        final ServiceDependency model = ServiceDependency.on(OpenAPIModelConfiguration.SERVICE_DESCRIPTOR, (String)serverName, (String)hostName, (String)path);
        Runnable start = new Runnable(){

            @Override
            public void run() {
                ((Host)host.get()).registerHandler(path, (HttpHandler)new OpenAPIHttpHandler((SmallRyeOpenAPI)model.get()));
                MicroProfileOpenAPILogger.LOGGER.endpointRegistered(path, ((Host)host.get()).getName());
            }
        };
        Runnable stop = new Runnable(){

            @Override
            public void run() {
                ((Host)host.get()).unregisterHandler(path);
                MicroProfileOpenAPILogger.LOGGER.endpointUnregistered(path, ((Host)host.get()).getName());
            }
        };
        ((ServiceInstaller)((ServiceInstaller.Builder)((ServiceInstaller.Builder)ServiceInstaller.builder((Runnable)start, (Runnable)stop).requires(List.of(host, model))).startWhen(Installer.StartWhen.INSTALLED)).build()).install(context);
    }
}

