/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.injectors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.persistence.EntityManagerFactory;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.service.PersistenceUnitServiceImpl;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class PersistenceUnitInjectionSource
extends InjectionSource {
    private final PersistenceUnitJndiInjectable injectable;
    private final ServiceName puServiceName;

    public PersistenceUnitInjectionSource(ServiceName puServiceName, ServiceRegistry serviceRegistry, String injectionTypeName, PersistenceUnitMetadata pu) {
        this.injectable = new PersistenceUnitJndiInjectable(puServiceName, serviceRegistry, injectionTypeName, pu);
        this.puServiceName = puServiceName;
    }

    public void getResourceValue(InjectionSource.ResolutionContext resolutionContext, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        serviceBuilder.requires(this.puServiceName);
        injector.inject((Object)this.injectable);
    }

    public boolean equals(Object other) {
        if (other instanceof PersistenceUnitInjectionSource) {
            PersistenceUnitInjectionSource source = (PersistenceUnitInjectionSource)((Object)other);
            return source.puServiceName.equals(this.puServiceName);
        }
        return false;
    }

    public int hashCode() {
        return this.puServiceName.hashCode();
    }

    private static final class PersistenceUnitJndiInjectable
    implements ManagedReferenceFactory {
        final ServiceName puServiceName;
        final ServiceRegistry serviceRegistry;
        final String injectionTypeName;
        final PersistenceUnitMetadata pu;
        private static final String ENTITY_MANAGER_FACTORY_CLASS = "javax.persistence.EntityManagerFactory";

        public PersistenceUnitJndiInjectable(ServiceName puServiceName, ServiceRegistry serviceRegistry, String injectionTypeName, PersistenceUnitMetadata pu) {
            this.puServiceName = puServiceName;
            this.serviceRegistry = serviceRegistry;
            this.injectionTypeName = injectionTypeName;
            this.pu = pu;
        }

        public ManagedReference getReference() {
            PersistenceUnitServiceImpl service = (PersistenceUnitServiceImpl)this.serviceRegistry.getRequiredService(this.puServiceName).getValue();
            EntityManagerFactory emf = service.getEntityManagerFactory();
            if (!ENTITY_MANAGER_FACTORY_CLASS.equals(this.injectionTypeName)) {
                Method getSessionFactory;
                try {
                    Class<?> extensionClass = this.pu.getClassLoader().loadClass(this.injectionTypeName);
                }
                catch (ClassNotFoundException e) {
                    throw JpaLogger.ROOT_LOGGER.cannotLoadFromJpa(e, this.injectionTypeName);
                }
                try {
                    getSessionFactory = emf.getClass().getMethod("getSessionFactory", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw JpaLogger.ROOT_LOGGER.hibernateOnlyEntityManagerFactory();
                }
                Object targetValueToInject = null;
                try {
                    targetValueToInject = getSessionFactory.invoke((Object)emf, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw JpaLogger.ROOT_LOGGER.cannotGetSessionFactory(e);
                }
                catch (InvocationTargetException e) {
                    throw JpaLogger.ROOT_LOGGER.cannotGetSessionFactory(e);
                }
                return new ValueManagedReference(targetValueToInject);
            }
            return new ValueManagedReference((Object)emf);
        }
    }
}

