/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.util.Headers;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.as.domain.http.server.Common;
import org.jboss.as.domain.http.server.HttpServerLogger;
import org.jboss.dmr.ModelNode;
import org.xnio.IoUtils;
import org.xnio.streams.ChannelOutputStream;

class DomainApiUploadHandler
implements HttpHandler {
    private final ModelController modelController;
    private final FormParserFactory formParserFactory;

    public DomainApiUploadHandler(ModelController modelController) {
        this.modelController = modelController;
        this.formParserFactory = FormParserFactory.builder().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        FormDataParser parser = this.formParserFactory.createParser(exchange);
        FormData data = parser.parseBlocking();
        for (String fieldName : data) {
            FormData.FormValue value = data.getFirst(fieldName);
            if (!value.isFile()) continue;
            ModelNode response = null;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(value.getFile()));
            try {
                ModelNode dmr = new ModelNode();
                dmr.get("operation").set("upload-deployment-stream");
                dmr.get("address").setEmptyList();
                dmr.get("input-stream-index").set(0);
                OperationBuilder operation = new OperationBuilder(dmr);
                operation.addInputStream((InputStream)in);
                dmr.get(new String[]{"operation-headers", "access-mechanism"}).set(AccessMechanism.HTTP.toString());
                response = this.modelController.execute(dmr, OperationMessageHandler.logging, ModelController.OperationTransactionControl.COMMIT, (OperationAttachments)operation.build());
                if (!response.get("outcome").asString().equals("success")) {
                    Common.sendError(exchange, false, response);
                    return;
                }
            }
            catch (Throwable t) {
                HttpServerLogger.ROOT_LOGGER.uploadError(t);
                Common.sendError(exchange, false, t.getLocalizedMessage());
                return;
            }
            finally {
                IoUtils.safeClose((Closeable)in);
            }
            DomainApiUploadHandler.writeResponse(exchange, response, "text/html");
            return;
        }
        Common.sendError(exchange, false, "No file found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeResponse(HttpServerExchange exchange, ModelNode response, String contentType) {
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, contentType + ";" + Common.UTF_8);
        exchange.setResponseCode(200);
        PrintWriter print = new PrintWriter((OutputStream)new ChannelOutputStream(exchange.getResponseChannel()));
        try {
            response.writeJSONString(print, true);
        }
        finally {
            print.flush();
            IoUtils.safeClose((Closeable)print);
        }
    }
}

