/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.security.idm.X509CertificateCredential;
import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.controller.security.SubjectUserInfo;
import org.jboss.as.domain.http.server.security.SubjectAccount;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.AuthorizingCallbackHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.sasl.callback.DigestHashCallback;
import org.jboss.sasl.callback.VerifyPasswordCallback;

public class RealmIdentityManager
implements IdentityManager {
    private static final ThreadLocal<AuthMechanism> currentMechanism = new ThreadLocal();
    private final SecurityRealm securityRealm;

    static void setAuthenticationMechanism(AuthMechanism mechanism) {
        currentMechanism.set(mechanism);
    }

    public RealmIdentityManager(SecurityRealm securityRealm) {
        this.securityRealm = securityRealm;
    }

    public Account verify(Account account) {
        return account;
    }

    public Account getAccount(String id) {
        SubjectUserInfo supplemental;
        RealmIdentityManager.assertMechanism(AuthMechanism.DIGEST);
        AuthorizingCallbackHandler ach = this.securityRealm.getAuthorizingCallbackHandler(AuthMechanism.DIGEST);
        Callback[] callbacks = new Callback[3];
        callbacks[0] = new RealmCallback("Realm", this.securityRealm.getName());
        callbacks[1] = new NameCallback("Username", id);
        boolean plainText = this.plainTextDigest();
        callbacks[2] = plainText ? new PasswordCallback("Password", false) : new DigestHashCallback("Digest");
        try {
            ach.handle(callbacks);
        }
        catch (Exception e) {
            return null;
        }
        SimplePrincipal user = new SimplePrincipal(id);
        Set<SimplePrincipal> userCol = Collections.singleton(user);
        try {
            supplemental = ach.createSubjectUserInfo(userCol);
        }
        catch (IOException e) {
            return null;
        }
        if (plainText) {
            return new PlainDigestAccount(supplemental.getSubject(), user, ((PasswordCallback)callbacks[2]).getPassword());
        }
        return new HashedDigestAccount(supplemental.getSubject(), user, ((DigestHashCallback)callbacks[2]).getHash());
    }

    private boolean plainTextDigest() {
        Map mechConfig = this.securityRealm.getMechanismConfig(AuthMechanism.DIGEST);
        boolean plainTextDigest = true;
        if (mechConfig.containsKey("org.jboss.as.domain.management.digest.plain_text")) {
            plainTextDigest = Boolean.parseBoolean((String)mechConfig.get("org.jboss.as.domain.management.digest.plain_text"));
        }
        return plainTextDigest;
    }

    public Account verify(String id, Credential credential) {
        SubjectUserInfo supplemental;
        RealmIdentityManager.assertMechanism(AuthMechanism.PLAIN);
        if (!(credential instanceof PasswordCredential)) {
            return null;
        }
        AuthorizingCallbackHandler ach = this.securityRealm.getAuthorizingCallbackHandler(AuthMechanism.PLAIN);
        Callback[] callbacks = new Callback[]{new RealmCallback("Realm", this.securityRealm.getName()), new NameCallback("Username", id), new VerifyPasswordCallback(new String(((PasswordCredential)credential).getPassword()))};
        try {
            ach.handle(callbacks);
        }
        catch (Exception e) {
            return null;
        }
        if (!((VerifyPasswordCallback)callbacks[2]).isVerified()) {
            return null;
        }
        SimplePrincipal user = new SimplePrincipal(id);
        Set<SimplePrincipal> userCol = Collections.singleton(user);
        try {
            supplemental = ach.createSubjectUserInfo(userCol);
        }
        catch (IOException e) {
            return null;
        }
        return new RealmIdentityAccount(supplemental.getSubject(), user);
    }

    public Account verify(Credential credential) {
        SubjectUserInfo supplemental;
        RealmIdentityManager.assertMechanism(AuthMechanism.CLIENT_CERT);
        if (!(credential instanceof X509CertificateCredential)) {
            return null;
        }
        X509CertificateCredential certCred = (X509CertificateCredential)credential;
        AuthorizingCallbackHandler ach = this.securityRealm.getAuthorizingCallbackHandler(AuthMechanism.CLIENT_CERT);
        Principal user = certCred.getCertificate().getSubjectDN();
        Set<Principal> userCol = Collections.singleton(user);
        try {
            supplemental = ach.createSubjectUserInfo(userCol);
        }
        catch (IOException e) {
            return null;
        }
        return new RealmIdentityAccount(supplemental.getSubject(), user);
    }

    private static void assertMechanism(AuthMechanism mechanism) {
        if (mechanism != currentMechanism.get()) {
            throw new IllegalStateException("Unexpected authentication mechanism executing.");
        }
    }

    private class HashedDigestAccount
    extends RealmIdentityAccount {
        private final byte[] hash;

        private HashedDigestAccount(Subject subject, Principal principal, byte[] hash) {
            super(subject, principal);
            this.hash = hash;
        }

        private byte[] getHash() {
            return this.hash;
        }

        @Override
        public Object getAttribute(String attributeName) {
            if (attributeName.startsWith("DIGEST_HA1_HASH_")) {
                return this.hash;
            }
            return null;
        }
    }

    private class PlainDigestAccount
    extends RealmIdentityAccount {
        private final char[] password;

        private PlainDigestAccount(Subject subject, Principal principal, char[] password) {
            super(subject, principal);
            this.password = password;
        }

        private char[] getPassword() {
            return this.password;
        }

        @Override
        public Object getAttribute(String attributeName) {
            if (attributeName.equals("PLAINTEXT_PASSWORD")) {
                return this.password;
            }
            return null;
        }
    }

    private class RealmIdentityAccount
    implements SubjectAccount {
        private final Subject subject;
        private final Principal principal;

        private RealmIdentityAccount(Subject subject, Principal principal) {
            this.subject = subject;
            this.principal = principal;
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public Set<String> getRoles() {
            return Collections.emptySet();
        }

        public Object getAttribute(String attributeName) {
            return null;
        }

        @Override
        public Subject getSubject() {
            return this.subject;
        }
    }

    private class SimplePrincipal
    implements Principal {
        private final String name;

        private SimplePrincipal(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

