/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartException;

public final class ContainerStateMonitor
extends AbstractServiceListener<Object> {
    private final ServiceRegistry serviceRegistry;
    private final StabilityMonitor monitor = new StabilityMonitor();
    final Set<ServiceController<?>> failed = new HashSet();
    final Set<ServiceController<?>> problems = new HashSet();
    private Set<ServiceName> previousMissingDepSet = new HashSet<ServiceName>();

    ContainerStateMonitor(ServiceRegistry registry) {
        this.serviceRegistry = registry;
    }

    void acquire() {
    }

    void release() {
        ContainerStateChangeReport changeReport = this.createContainerStateChangeReport(true);
        if (changeReport != null) {
            String msg = this.createChangeReportLogMessage(changeReport);
            ControllerLogger.ROOT_LOGGER.info(msg);
        }
    }

    public void listenerAdded(ServiceController<?> controller) {
        this.monitor.addController(controller);
        controller.removeListener((ServiceListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitUninterruptibly() {
        boolean interruped = false;
        try {
            while (true) {
                try {
                    this.monitor.awaitStability(this.failed, this.problems);
                }
                catch (InterruptedException e) {
                    interruped = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interruped) {
                Thread.currentThread().interrupt();
            }
        }
    }

    void await() throws InterruptedException {
        this.monitor.awaitStability(this.failed, this.problems);
    }

    ContainerStateChangeReport awaitContainerStateChangeReport() throws InterruptedException {
        this.monitor.awaitStability(this.failed, this.problems);
        return this.createContainerStateChangeReport(false);
    }

    private synchronized ContainerStateChangeReport createContainerStateChangeReport(boolean resetHistory) {
        HashMap<ServiceName, HashSet<ServiceName>> missingDeps = new HashMap<ServiceName, HashSet<ServiceName>>();
        for (ServiceController<?> controller : this.problems) {
            for (ServiceName missing : controller.getImmediateUnavailableDependencies()) {
                HashSet<ServiceName> dependents = (HashSet<ServiceName>)missingDeps.get(missing);
                if (dependents == null) {
                    dependents = new HashSet<ServiceName>();
                    missingDeps.put(missing, dependents);
                }
                dependents.add(controller.getName());
            }
        }
        Set<ServiceName> previousMissing = this.previousMissingDepSet;
        TreeMap<ServiceName, Boolean> noLongerMissingServices = new TreeMap<ServiceName, Boolean>();
        for (ServiceName name : previousMissing) {
            if (missingDeps.containsKey(name)) continue;
            ServiceController controller = this.serviceRegistry.getService(name);
            noLongerMissingServices.put(name, controller != null);
        }
        TreeMap<ServiceName, MissingDependencyInfo> missingServices = new TreeMap<ServiceName, MissingDependencyInfo>();
        for (Map.Entry entry : missingDeps.entrySet()) {
            ServiceName name = (ServiceName)entry.getKey();
            if (previousMissing.contains(name)) continue;
            ServiceController controller = this.serviceRegistry.getService(name);
            boolean unavailable = controller != null;
            missingServices.put(name, new MissingDependencyInfo(name, unavailable, (Set)entry.getValue()));
        }
        HashSet currentFailedControllers = new HashSet(this.failed);
        if (resetHistory) {
            this.previousMissingDepSet = new HashSet(missingDeps.keySet());
            this.failed.clear();
            this.problems.clear();
        }
        boolean needReport = !missingServices.isEmpty() || !currentFailedControllers.isEmpty() || !noLongerMissingServices.isEmpty();
        return needReport ? new ContainerStateChangeReport(missingServices, currentFailedControllers, noLongerMissingServices) : null;
    }

    private synchronized String createChangeReportLogMessage(ContainerStateChangeReport changeReport) {
        StringBuilder msg = new StringBuilder();
        msg.append(ControllerMessages.MESSAGES.serviceStatusReportHeader());
        if (!changeReport.getMissingServices().isEmpty()) {
            msg.append(ControllerMessages.MESSAGES.serviceStatusReportDependencies());
            for (Map.Entry<ServiceName, MissingDependencyInfo> entry : changeReport.getMissingServices().entrySet()) {
                if (!entry.getValue().isUnavailable()) {
                    msg.append(ControllerMessages.MESSAGES.serviceStatusReportMissing(entry.getKey(), ContainerStateMonitor.createDependentsString(entry.getValue().getDependents())));
                    continue;
                }
                msg.append(ControllerMessages.MESSAGES.serviceStatusReportUnavailable(entry.getKey(), ContainerStateMonitor.createDependentsString(entry.getValue().getDependents())));
            }
        }
        if (!changeReport.getNoLongerMissingServices().isEmpty()) {
            msg.append(ControllerMessages.MESSAGES.serviceStatusReportCorrected());
            for (Map.Entry<ServiceName, Object> entry : changeReport.getNoLongerMissingServices().entrySet()) {
                if (((Boolean)entry.getValue()).booleanValue()) {
                    msg.append(ControllerMessages.MESSAGES.serviceStatusReportAvailable(entry.getKey()));
                    continue;
                }
                msg.append(ControllerMessages.MESSAGES.serviceStatusReportNoLongerRequired(entry.getKey()));
            }
        }
        if (!changeReport.getFailedControllers().isEmpty()) {
            msg.append(ControllerMessages.MESSAGES.serviceStatusReportFailed());
            for (ServiceController serviceController : changeReport.getFailedControllers()) {
                msg.append("      ").append(serviceController.getName());
                StartException startException = serviceController.getStartException();
                if (startException != null) {
                    msg.append(": ").append(startException.toString());
                }
                msg.append('\n');
            }
        }
        return msg.toString();
    }

    private static String createDependentsString(Set<ServiceName> serviceNames) {
        if (serviceNames.size() <= 4) {
            return serviceNames.toString();
        }
        StringBuilder ret = new StringBuilder("[");
        Iterator<ServiceName> it = serviceNames.iterator();
        for (int count = 0; count < 4; ++count) {
            ServiceName val = it.next();
            ret.append(val);
            ret.append(", ");
        }
        ret.append(ControllerMessages.MESSAGES.andNMore(serviceNames.size() - 3));
        ret.append(" ]");
        return ret.toString();
    }

    public static class MissingDependencyInfo {
        private final ServiceName serviceName;
        private final boolean unavailable;
        private final Set<ServiceName> dependents;

        public MissingDependencyInfo(ServiceName serviceName, boolean unavailable, Set<ServiceName> dependents) {
            this.serviceName = serviceName;
            this.unavailable = unavailable;
            this.dependents = dependents;
        }

        public ServiceName getServiceName() {
            return this.serviceName;
        }

        public boolean isUnavailable() {
            return this.unavailable;
        }

        public Set<ServiceName> getDependents() {
            return Collections.unmodifiableSet(this.dependents);
        }
    }

    public static class ContainerStateChangeReport {
        private final Map<ServiceName, MissingDependencyInfo> missingServices;
        private final Set<ServiceController<?>> failedControllers;
        private final Map<ServiceName, Boolean> noLongerMissingServices;

        private ContainerStateChangeReport(Map<ServiceName, MissingDependencyInfo> missingServices, Set<ServiceController<?>> failedControllers, Map<ServiceName, Boolean> noLongerMissingServices) {
            this.missingServices = missingServices;
            this.failedControllers = failedControllers;
            this.noLongerMissingServices = noLongerMissingServices;
        }

        public final Set<ServiceController<?>> getFailedControllers() {
            return this.failedControllers;
        }

        public Map<ServiceName, MissingDependencyInfo> getMissingServices() {
            return this.missingServices;
        }

        public Map<ServiceName, Boolean> getNoLongerMissingServices() {
            return this.noLongerMissingServices;
        }
    }
}

