/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform.description;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformersLogger;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.TransformationRule;
import org.jboss.dmr.ModelNode;

class RejectedAttributesLogContext {
    private final TransformationRule.AbstractChainedContext context;
    private final PathAddress address;
    private final ModelNode op;
    Map<String, RejectAttributeChecker> failedCheckers;
    Map<String, Map<String, ModelNode>> failedAttributes;

    RejectedAttributesLogContext(TransformationRule.AbstractChainedContext context, PathAddress address, ModelNode op) {
        this.context = context;
        this.address = address;
        this.op = op;
    }

    void checkAttribute(RejectAttributeChecker checker, String attributeName, ModelNode attributeValue) {
        if (this.op == null) {
            if (checker.rejectResourceAttribute(this.address, attributeName, attributeValue, this.context.getContext())) {
                this.reject(checker, attributeName, attributeValue);
            }
        } else if (checker.rejectOperationParameter(this.address, attributeName, attributeValue, this.op, this.context.getContext())) {
            this.reject(checker, attributeName, attributeValue);
        }
    }

    private void reject(RejectAttributeChecker checker, String attributeName, ModelNode attributeValue) {
        Map<String, ModelNode> attributes;
        assert (checker.getRejectionLogMessageId() != null) : "Null log id";
        String id = checker.getRejectionLogMessageId();
        if (this.failedCheckers == null) {
            this.failedCheckers = new HashMap<String, RejectAttributeChecker>();
        }
        if (this.failedCheckers.get(id) == null) {
            this.failedCheckers.put(id, checker);
        }
        if (this.failedAttributes == null) {
            this.failedAttributes = new LinkedHashMap<String, Map<String, ModelNode>>();
        }
        if ((attributes = this.failedAttributes.get(checker.getRejectionLogMessageId())) == null) {
            attributes = new HashMap<String, ModelNode>();
            this.failedAttributes.put(checker.getRejectionLogMessageId(), attributes);
        }
        attributes.put(attributeName, attributeValue);
    }

    boolean hasRejections() {
        return this.failedAttributes != null;
    }

    String errorOrWarnOnResourceTransformation() throws OperationFailedException {
        if (this.op != null) {
            throw new IllegalStateException();
        }
        if (this.failedAttributes == null) {
            return "";
        }
        TransformationTarget tgt = this.context.getContext().getTarget();
        String legacyHostName = tgt.getHostName();
        ModelVersion coreVersion = tgt.getVersion();
        String subsystemName = RejectedAttributesLogContext.findSubsystemName(this.address);
        ModelVersion usedVersion = subsystemName == null ? coreVersion : tgt.getSubsystemVersion(subsystemName);
        TransformersLogger logger2 = this.context.getContext().getLogger();
        boolean error = tgt.isIgnoredResourceListAvailableAtRegistration();
        ArrayList<String> messages = error ? new ArrayList<String>() : null;
        for (Map.Entry<String, Map<String, ModelNode>> entry : this.failedAttributes.entrySet()) {
            RejectAttributeChecker checker = this.failedCheckers.get(entry.getKey());
            String message = checker.getRejectionLogMessage(entry.getValue());
            if (error) {
                messages.add(message);
                continue;
            }
            return logger2.getAttributeWarning(this.address, this.op, message, entry.getValue().keySet());
        }
        if (error) {
            if (subsystemName != null) {
                throw ControllerMessages.MESSAGES.rejectAttributesSubsystemModelResourceTransformer(this.address, legacyHostName, subsystemName, usedVersion, messages);
            }
            throw ControllerMessages.MESSAGES.rejectAttributesCoreModelResourceTransformer(this.address, legacyHostName, usedVersion, messages);
        }
        return null;
    }

    @Deprecated
    String getOperationRejectDescription() {
        if (this.op == null) {
            throw new IllegalStateException();
        }
        if (this.failedAttributes == null) {
            return "";
        }
        TransformersLogger logger2 = this.context.getContext().getLogger();
        Iterator<Map.Entry<String, Map<String, ModelNode>>> i$ = this.failedAttributes.entrySet().iterator();
        if (i$.hasNext()) {
            Map.Entry<String, Map<String, ModelNode>> entry = i$.next();
            RejectAttributeChecker checker = this.failedCheckers.get(entry.getKey());
            String message = checker.getRejectionLogMessage(entry.getValue());
            return logger2.getAttributeWarning(this.address, this.op, message, entry.getValue().keySet());
        }
        return null;
    }

    private static String findSubsystemName(PathAddress pathAddress) {
        for (PathElement element : pathAddress) {
            if (!element.getKey().equals("subsystem")) continue;
            return element.getValue();
        }
        return null;
    }
}

