/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ReadOperationNamesHandler
implements OperationStepHandler {
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-operation-names", ControllerResolver.getResolver("global")).setReadOnly().setRuntimeOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build();
    static OperationStepHandler INSTANCE = new ReadOperationNamesHandler();

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        Map<String, OperationEntry> operations = registry.getOperationDescriptions(PathAddress.EMPTY_ADDRESS, true);
        ModelNode result = new ModelNode();
        if (operations.size() > 0) {
            for (Map.Entry<String, OperationEntry> entry : operations.entrySet()) {
                if (entry.getValue().getType() != OperationEntry.EntryType.PUBLIC || context.getProcessType() == ProcessType.DOMAIN_SERVER && !entry.getValue().getFlags().contains((Object)OperationEntry.Flag.RUNTIME_ONLY)) continue;
                result.add(entry.getKey());
            }
        } else {
            result.setEmptyList();
        }
        context.getResult().set(result);
        context.stepCompleted();
    }
}

