/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.interfaces.InetAddressUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class ProcessEnvironment {
    public static final String JBOSS_DOMAIN_UUID = "jboss.domain.uuid";
    public static final AttributeDefinition NAME = new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, true).setAllowExpression(true).build();

    public OperationStepHandler getProcessNameReadHandler() {
        return new ProcessNameReadAttributeHandler();
    }

    public OperationStepHandler getProcessNameWriteHandler() {
        return new ProcessNameWriteAttributeHandler();
    }

    protected abstract String getProcessName();

    protected abstract void setProcessName(String var1);

    protected abstract boolean isRuntimeSystemPropertyUpdateAllowed(String var1, String var2, boolean var3) throws OperationFailedException;

    protected abstract void systemPropertyUpdated(String var1, String var2);

    protected static String resolveGUID(String unresolvedName) {
        String result;
        if (JBOSS_DOMAIN_UUID.equals(unresolvedName)) {
            try {
                InetAddress localhost = InetAddressUtil.getLocalHost();
                result = UUID.nameUUIDFromBytes(localhost.getAddress()).toString();
            }
            catch (UnknownHostException e) {
                throw ControllerMessages.MESSAGES.cannotResolveProcessUUID(e);
            }
        } else {
            result = unresolvedName;
        }
        return result;
    }

    private class ProcessNameReadAttributeHandler
    implements OperationStepHandler {
        private ProcessNameReadAttributeHandler() {
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
            if (model.hasDefined(NAME.getName())) {
                context.getResult().set(model.get(NAME.getName()));
            } else {
                context.getResult().set(ProcessEnvironment.this.getProcessName());
            }
            context.stepCompleted();
        }
    }

    private class ProcessNameWriteAttributeHandler
    implements OperationStepHandler {
        private ProcessNameWriteAttributeHandler() {
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode model = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
            ModelNode newValue = operation.hasDefined("value") ? operation.get("value") : new ModelNode();
            ModelNode mockOp = new ModelNode();
            mockOp.get(NAME.getName()).set(newValue);
            NAME.validateAndSet(mockOp, model);
            final boolean booting = context.isBooting();
            String resolved = null;
            if (booting) {
                ModelNode resolvedNode = NAME.resolveModelAttribute(context, model);
                resolved = resolvedNode.isDefined() ? resolvedNode.asString() : null;
                resolved = resolved == null ? null : ProcessEnvironment.resolveGUID(resolved);
            } else {
                context.reloadRequired();
            }
            final String processName = resolved;
            context.completeStep(new OperationContext.ResultHandler(){

                @Override
                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    if (resultAction == OperationContext.ResultAction.KEEP) {
                        if (booting) {
                            ProcessEnvironment.this.setProcessName(processName);
                        }
                    } else if (!booting) {
                        context.revertReloadRequired();
                    }
                }
            });
        }
    }
}

