/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.rbac;

import java.util.EnumSet;
import java.util.Set;
import org.jboss.as.controller.access.Action;

public enum StandardRole {
    MONITOR(Action.ActionEffect.READ_CONFIG, Action.ActionEffect.READ_RUNTIME),
    OPERATOR(Action.ActionEffect.READ_CONFIG, Action.ActionEffect.READ_RUNTIME, Action.ActionEffect.WRITE_RUNTIME),
    MAINTAINER,
    DEPLOYER,
    ADMINISTRATOR,
    AUDITOR,
    SUPERUSER;

    private final Set<Action.ActionEffect> allowedActions;

    private StandardRole() {
        this(Action.ActionEffect.values());
    }

    private StandardRole(Action.ActionEffect ... allowedExcludingAccess) {
        this(EnumSet.of(Action.ActionEffect.ADDRESS, allowedExcludingAccess));
    }

    private StandardRole(Set<Action.ActionEffect> allowedActions) {
        this.allowedActions = allowedActions;
    }

    public boolean isActionEffectAllowed(Action.ActionEffect actionEffect) {
        return this.allowedActions.contains((Object)actionEffect);
    }
}

