/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.constraint;

import java.util.regex.Pattern;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.constraint.AbstractConstraint;
import org.jboss.as.controller.access.constraint.AllowAllowNotConstraint;
import org.jboss.as.controller.access.constraint.Constraint;
import org.jboss.as.controller.access.constraint.ConstraintFactory;
import org.jboss.as.controller.access.constraint.VaultExpressionSensitivityConfig;
import org.jboss.as.controller.access.rbac.StandardRole;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class SensitiveVaultExpressionConstraint
extends AllowAllowNotConstraint {
    public static final ConstraintFactory FACTORY = new Factory();
    private static final SensitiveVaultExpressionConstraint SENSITIVE = new SensitiveVaultExpressionConstraint(true);
    private static final SensitiveVaultExpressionConstraint NOT_SENSITIVE = new SensitiveVaultExpressionConstraint(false);
    private static final SensitiveVaultExpressionConstraint ALLOWS = new SensitiveVaultExpressionConstraint(true, true);
    private static final SensitiveVaultExpressionConstraint DISALLOWS = new SensitiveVaultExpressionConstraint(false, true);

    private SensitiveVaultExpressionConstraint(boolean sensitive) {
        super(sensitive);
    }

    private SensitiveVaultExpressionConstraint(boolean allowsSensitive, boolean allowsNonSensitive) {
        super(allowsSensitive, allowsNonSensitive);
    }

    @Override
    protected int internalCompare(AbstractConstraint other) {
        return 0;
    }

    private static class Factory
    implements ConstraintFactory {
        private static final Pattern VAULT_PATTERN = Pattern.compile("VAULT::.*::.*::.*");

        private Factory() {
        }

        @Override
        public Constraint getStandardUserConstraint(StandardRole role, Action.ActionEffect actionEffect) {
            if (role == StandardRole.ADMINISTRATOR || role == StandardRole.SUPERUSER || role == StandardRole.AUDITOR) {
                return ALLOWS;
            }
            return DISALLOWS;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetAttribute target) {
            return VaultExpressionSensitivityConfig.INSTANCE.isSensitive(actionEffect) && this.isSensitiveValue(target.getCurrentValue()) ? SENSITIVE : NOT_SENSITIVE;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetResource target) {
            return VaultExpressionSensitivityConfig.INSTANCE.isSensitive(actionEffect) && this.isSensitiveAction(action, actionEffect) ? SENSITIVE : NOT_SENSITIVE;
        }

        private boolean isSensitiveAction(Action action, Action.ActionEffect actionEffect) {
            if (actionEffect == Action.ActionEffect.WRITE_RUNTIME || actionEffect == Action.ActionEffect.WRITE_CONFIG) {
                ModelNode operation = action.getOperation();
                for (Property property : operation.asPropertyList()) {
                    if (!this.isSensitiveValue(property.getValue())) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isSensitiveValue(ModelNode value) {
            String valueString;
            if ((value.getType() == ModelType.EXPRESSION || value.getType() == ModelType.STRING) && ExpressionResolver.EXPRESSION_PATTERN.matcher(valueString = value.asString()).matches()) {
                valueString = valueString.substring(valueString.indexOf("${") + 2, valueString.indexOf("}"));
                return VAULT_PATTERN.matcher(valueString).matches();
            }
            return false;
        }
    }
}

