/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.MinMaxValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class LongRangeValidator
extends ModelTypeValidator
implements MinMaxValidator {
    protected final long min;
    protected final long max;

    public LongRangeValidator(long min) {
        this(min, Long.MAX_VALUE, false, false);
    }

    public LongRangeValidator(long min, boolean nullable) {
        this(min, Integer.MAX_VALUE, nullable, false);
    }

    public LongRangeValidator(long min, long max, boolean nullable, boolean allowExpressions) {
        super(ModelType.LONG, nullable, allowExpressions, false);
        this.min = min;
        this.max = max;
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined() && value.getType() != ModelType.EXPRESSION) {
            long val = value.asLong();
            if (val < this.min) {
                throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.invalidMinValue(val, parameterName, this.min)));
            }
            if (val > this.max) {
                throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.invalidMaxValue(val, parameterName, this.max)));
            }
        }
    }

    @Override
    public Long getMin() {
        return this.min;
    }

    @Override
    public Long getMax() {
        return this.max;
    }
}

