/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

public class ServiceRemoveStepHandler
extends AbstractRemoveStepHandler {
    private final ServiceName baseServiceName;
    private final AbstractAddStepHandler addOperation;

    public ServiceRemoveStepHandler(ServiceName baseServiceName, AbstractAddStepHandler addOperation) {
        this.baseServiceName = baseServiceName;
        this.addOperation = addOperation;
    }

    protected ServiceRemoveStepHandler(AbstractAddStepHandler addOperation) {
        this(null, addOperation);
    }

    @Override
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        if (context.isResourceServiceRestartAllowed()) {
            PathAddress address = PathAddress.pathAddress(operation.require("address"));
            String name = address.getLastElement().getValue();
            context.removeService(this.serviceName(name));
        } else {
            context.reloadRequired();
        }
    }

    protected ServiceName serviceName(String name) {
        return this.baseServiceName.append(new String[]{name});
    }

    @Override
    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isResourceServiceRestartAllowed()) {
            this.addOperation.performRuntime(context, operation, model, new ServiceVerificationHandler(), new ArrayList());
        } else {
            context.revertReloadRequired();
        }
    }
}

