/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionListeners;
import io.undertow.server.session.SessionManagerStatistics;
import io.undertow.util.AttachmentKey;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Predicate;
import org.wildfly.clustering.function.UnaryOperator;
import org.wildfly.clustering.server.expiration.ExpirationMetaData;
import org.wildfly.clustering.session.IdentifierMarshaller;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionMetaData;
import org.wildfly.clustering.web.undertow.UndertowIdentifierSerializerProvider;
import org.wildfly.clustering.web.undertow.logging.UndertowClusteringLogger;
import org.wildfly.clustering.web.undertow.session.DetachedDistributableSession;
import org.wildfly.clustering.web.undertow.session.DistributableSession;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManagerConfiguration;
import org.wildfly.clustering.web.undertow.session.OrphanSession;
import org.wildfly.clustering.web.undertow.session.RecordableSessionManagerStatistics;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;

public class DistributableSessionManager
implements UndertowSessionManager {
    private static final Logger LOGGER = Logger.getLogger(DistributableSessionManager.class);
    private static final IdentifierMarshaller IDENTIFIER_MARSHALLER = new UndertowIdentifierSerializerProvider().getMarshaller();
    private static final Predicate<String> REQUESTED_IDENTIFIER = Objects::nonNull;
    private static final Predicate<String> VALID_IDENTIFIER = REQUESTED_IDENTIFIER.and(arg_0 -> ((IdentifierMarshaller)IDENTIFIER_MARSHALLER).validate(arg_0));
    private static final Predicate<org.wildfly.clustering.session.Session<Map<String, Object>>> EXISTING_SESSION = Objects::nonNull;
    private static final Predicate<org.wildfly.clustering.session.Session<Map<String, Object>>> VALID_SESSION = ImmutableSession::isValid;
    private static final Function<org.wildfly.clustering.session.Session<Map<String, Object>>, SessionMetaData> SESSION_META_DATA = org.wildfly.clustering.session.Session::getMetaData;
    private static final Predicate<org.wildfly.clustering.session.Session<Map<String, Object>>> ACTIVE_SESSION = Predicate.not(ExpirationMetaData::isExpired).compose(SESSION_META_DATA);
    private static final UnaryOperator<org.wildfly.clustering.session.Session<Map<String, Object>>> VALIDATE_SESSION = UnaryOperator.identity().orDefault((java.util.function.Predicate)EXISTING_SESSION.and((java.util.function.Predicate)VALID_SESSION.and(ACTIVE_SESSION)), (Supplier)org.wildfly.clustering.function.Supplier.of(null));
    private static final UnaryOperator<org.wildfly.clustering.session.Session<Map<String, Object>>> REQUIRE_SESSION = UnaryOperator.identity().orDefault(EXISTING_SESSION, () -> {
        throw new IllegalStateException();
    });
    private final AttachmentKey<Session> key = AttachmentKey.create(Session.class);
    private final String deploymentName;
    private final SessionListeners listeners;
    private final SessionManager<Map<String, Object>> manager;
    private final RecordableSessionManagerStatistics statistics;
    private final StampedLock lifecycleLock = new StampedLock();
    private final AtomicLong lifecycleStamp = new AtomicLong(0L);
    private final org.wildfly.clustering.function.Supplier<Map.Entry<SuspendedBatch, Consumer<HttpServerExchange>>> batchEntryFactory = this::createBatchEntry;
    private final Function<String, org.wildfly.clustering.session.Session<Map<String, Object>>> createSession;
    private final Function<String, org.wildfly.clustering.session.Session<Map<String, Object>>> findSession;
    private final Function<String, org.wildfly.clustering.session.Session<Map<String, Object>>> getDetachedSession;
    private volatile int defaultSessionTimeout = 1800;

    public DistributableSessionManager(DistributableSessionManagerConfiguration config) {
        this.deploymentName = config.getDeploymentName();
        this.manager = config.getSessionManager();
        this.listeners = config.getSessionListeners();
        this.statistics = config.getStatistics();
        Function createSession = arg_0 -> this.manager.createSession(arg_0);
        this.createSession = createSession.withDefault(VALID_IDENTIFIER, (Supplier)this.manager.getIdentifierFactory()).andThen(REQUIRE_SESSION);
        Function findSession = arg_0 -> this.manager.findSession(arg_0);
        this.findSession = findSession.orDefault(VALID_IDENTIFIER, (Supplier)org.wildfly.clustering.function.Supplier.of(null)).andThen(VALIDATE_SESSION);
        Function getDetachedSession = arg_0 -> this.manager.getDetachedSession(arg_0);
        this.getDetachedSession = getDetachedSession.orDefault(VALID_IDENTIFIER, (Supplier)org.wildfly.clustering.function.Supplier.of(null)).andThen(VALIDATE_SESSION);
    }

    @Override
    public SessionListeners getSessionListeners() {
        return this.listeners;
    }

    @Override
    public SessionManager<Map<String, Object>> getSessionManager() {
        return this.manager;
    }

    @Override
    public void start() {
        long stamp = this.lifecycleStamp.getAndSet(0L);
        if (StampedLock.isWriteLockStamp(stamp)) {
            this.lifecycleLock.unlockWrite(stamp);
        }
        this.manager.start();
        if (this.statistics != null) {
            this.statistics.reset();
        }
    }

    @Override
    public void stop() {
        try {
            this.lifecycleStamp.set(this.lifecycleLock.tryWriteLock(60L, TimeUnit.SECONDS));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.manager.stop();
    }

    private Consumer<HttpServerExchange> getSessionCloseTask() {
        final StampedLock lock = this.lifecycleLock;
        long stamp = lock.tryReadLock();
        if (!StampedLock.isReadLockStamp(stamp)) {
            throw UndertowClusteringLogger.ROOT_LOGGER.sessionManagerStopped();
        }
        final AttachmentKey<Session> key = this.key;
        final AtomicLong stampRef = new AtomicLong(stamp);
        return new Consumer<HttpServerExchange>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(HttpServerExchange exchange) {
                try {
                    long stamp = stampRef.getAndSet(0L);
                    if (StampedLock.isReadLockStamp(stamp)) {
                        lock.unlockRead(stamp);
                    }
                }
                finally {
                    if (exchange != null) {
                        exchange.removeAttachment(key);
                    }
                }
            }
        };
    }

    public Session createSession(HttpServerExchange exchange, SessionConfig config) {
        if (exchange.isResponseStarted()) {
            OrphanSession session = new OrphanSession(this, (String)this.manager.getIdentifierFactory().get());
            session.setMaxInactiveInterval(this.defaultSessionTimeout);
            return session;
        }
        Session session = this.getSession(exchange, config, this.batchEntryFactory, this.createSession);
        try {
            this.listeners.sessionCreated(session, exchange);
        }
        catch (Error | RuntimeException e) {
            LOGGER.warn((Object)e.getLocalizedMessage(), e);
        }
        return session;
    }

    public Session getSession(HttpServerExchange exchange, SessionConfig config) {
        Session session;
        if (exchange != null && (session = (Session)exchange.getAttachment(this.key)) != null) {
            return session;
        }
        return this.getSession(exchange, config, this.batchEntryFactory, this.findSession);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Session getSession(HttpServerExchange exchange, SessionConfig config, org.wildfly.clustering.function.Supplier<Map.Entry<SuspendedBatch, Consumer<HttpServerExchange>>> batchEntryFactory, Function<String, org.wildfly.clustering.session.Session<Map<String, Object>>> sessionFactory) {
        if (config == null) {
            throw UndertowMessages.MESSAGES.couldNotFindSessionCookieConfig();
        }
        Map.Entry entry = (Map.Entry)batchEntryFactory.get();
        SuspendedBatch suspendedBatch = (SuspendedBatch)entry.getKey();
        Consumer closeTask = (Consumer)entry.getValue();
        try (Context context = suspendedBatch.resumeWithContext();){
            SessionMetaData metaData;
            org.wildfly.clustering.session.Session session322 = (org.wildfly.clustering.session.Session)sessionFactory.apply((Object)config.findSessionId(exchange));
            if (session322 == null) {
                Session session = DistributableSessionManager.close((Supplier<Batch>)context, (Consumer<HttpServerExchange>)closeTask);
                return session;
            }
            config.setSessionId(exchange, session322.getId());
            if (this.statistics != null && (metaData = session322.getMetaData()).isNew()) {
                this.statistics.record(metaData);
            }
            DistributableSession result = new DistributableSession(this, (org.wildfly.clustering.session.Session<Map<String, Object>>)session322, config, suspendedBatch, (java.util.function.Consumer<HttpServerExchange>)closeTask, this.statistics);
            if (exchange != null) {
                exchange.putAttachment(this.key, (Object)result);
            }
            DistributableSession distributableSession = result;
            return distributableSession;
        }
        catch (Error | RuntimeException e) {
            try (Context context2 = suspendedBatch.resumeWithContext();){
                DistributableSessionManager.rollback((Supplier<Batch>)context2, (Consumer<HttpServerExchange>)closeTask);
                throw e;
            }
        }
    }

    private static void rollback(Supplier<Batch> batchProvider, Consumer<HttpServerExchange> closeTask) {
        DistributableSessionManager.close(batchProvider, (Consumer<Batch>)((Consumer)Batch::discard), closeTask);
    }

    private static Session close(Supplier<Batch> batchProvider, Consumer<HttpServerExchange> closeTask) {
        DistributableSessionManager.close(batchProvider, (Consumer<Batch>)Consumer.empty(), closeTask);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(Supplier<Batch> batchProvider, Consumer<Batch> batchTask, Consumer<HttpServerExchange> closeTask) {
        try (Batch batch = batchProvider.get();){
            batchTask.accept((Object)batch);
        }
        catch (Error | RuntimeException e) {
            LOGGER.error((Object)e.getLocalizedMessage(), e);
        }
        finally {
            closeTask.accept(null);
        }
    }

    private Map.Entry<SuspendedBatch, Consumer<HttpServerExchange>> createBatchEntry() {
        Consumer<HttpServerExchange> closeTask = this.getSessionCloseTask();
        try {
            return Map.entry(((Batch)this.manager.getBatchFactory().get()).suspend(), closeTask);
        }
        catch (Error | RuntimeException e) {
            closeTask.accept(null);
            throw e;
        }
    }

    public void registerSessionListener(SessionListener listener) {
        this.listeners.addSessionListener(listener);
    }

    public void removeSessionListener(SessionListener listener) {
        this.listeners.removeSessionListener(listener);
    }

    public void setDefaultSessionTimeout(int timeout) {
        this.defaultSessionTimeout = timeout;
    }

    public Set<String> getTransientSessions() {
        return Collections.emptySet();
    }

    public Set<String> getActiveSessions() {
        return this.manager.getStatistics().getActiveSessions();
    }

    public Set<String> getAllSessions() {
        return this.manager.getStatistics().getSessions();
    }

    public Session getSession(String sessionId) {
        try (Batch batch = (Batch)this.manager.getBatchFactory().get();){
            org.wildfly.clustering.session.Session session = (org.wildfly.clustering.session.Session)this.getDetachedSession.apply((Object)sessionId);
            DetachedDistributableSession detachedDistributableSession = session != null ? new DetachedDistributableSession(this, (org.wildfly.clustering.session.Session<Map<String, Object>>)session, this.statistics) : null;
            return detachedDistributableSession;
        }
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public SessionManagerStatistics getStatistics() {
        return this.statistics;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DistributableSessionManager)) {
            return false;
        }
        DistributableSessionManager manager = (DistributableSessionManager)object;
        return this.deploymentName.equals(manager.getDeploymentName());
    }

    public int hashCode() {
        return this.deploymentName.hashCode();
    }

    public String toString() {
        return this.deploymentName;
    }
}

