/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionMetaData;
import org.wildfly.clustering.web.undertow.logging.UndertowClusteringLogger;
import org.wildfly.clustering.web.undertow.session.AbstractSession;
import org.wildfly.clustering.web.undertow.session.RecordableSessionManagerStatistics;
import org.wildfly.clustering.web.undertow.session.SimpleSessionConfig;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;

public class DistributableSession
extends AbstractSession {
    private final UndertowSessionManager manager;
    private final SuspendedBatch suspendedBatch;
    private final AtomicReference<Consumer<HttpServerExchange>> closeTask;
    private final Instant startTime;
    private final RecordableSessionManagerStatistics statistics;
    private final AtomicReference<Map.Entry<Session<Map<String, Object>>, SessionConfig>> reference;

    public DistributableSession(UndertowSessionManager manager, Session<Map<String, Object>> session, SessionConfig config, SuspendedBatch suspendedBatch, Consumer<HttpServerExchange> closeTask, RecordableSessionManagerStatistics statistics) {
        this(manager, new AtomicReference<Map.Entry<Session<Map<String, Object>>, SessionConfig>>(Map.entry(session, config)), suspendedBatch, closeTask, statistics);
    }

    private DistributableSession(UndertowSessionManager manager, AtomicReference<Map.Entry<Session<Map<String, Object>>, SessionConfig>> reference, SuspendedBatch suspendedBatch, Consumer<HttpServerExchange> closeTask, RecordableSessionManagerStatistics statistics) {
        super(manager, () -> (Session)((Map.Entry)reference.get()).getKey());
        this.manager = manager;
        this.reference = reference;
        this.suspendedBatch = suspendedBatch;
        this.closeTask = new AtomicReference<Consumer<HttpServerExchange>>(closeTask);
        Session<Map<String, Object>> session = reference.get().getKey();
        this.startTime = session.getMetaData().isNew() ? session.getMetaData().getCreationTime() : Instant.now();
        this.statistics = statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDone(HttpServerExchange exchange) {
        Consumer closeTask = this.closeTask.getAndSet(null);
        if (closeTask != null) {
            Session<Map<String, Object>> currentSession = this.get();
            try (Batch batch = this.suspendedBatch.resume();
                 Session<Map<String, Object>> session = currentSession;){
                if (session.isValid()) {
                    session.getMetaData().setLastAccess(this.startTime, Instant.now());
                }
            }
            catch (Throwable e) {
                UndertowClusteringLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
            }
            finally {
                this.reference.set(Map.entry(currentSession, new SimpleSessionConfig(currentSession.getId())));
                closeTask.accept(exchange);
            }
        }
    }

    @Override
    public long getCreationTime() {
        try {
            return super.getCreationTime();
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid(null);
            throw e;
        }
    }

    @Override
    public long getLastAccessedTime() {
        try {
            return super.getLastAccessedTime();
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid(null);
            throw e;
        }
    }

    @Override
    public int getMaxInactiveInterval() {
        try {
            return super.getMaxInactiveInterval();
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid(null);
            throw e;
        }
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        try {
            super.setMaxInactiveInterval(interval);
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid(null);
            throw e;
        }
    }

    @Override
    public Set<String> getAttributeNames() {
        try {
            return super.getAttributeNames();
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid(null);
            throw e;
        }
    }

    @Override
    public Object getAttribute(String name) {
        try {
            return super.getAttribute(name);
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid(null);
            throw e;
        }
    }

    @Override
    public Object setAttribute(String name, Object value) {
        try {
            return super.setAttribute(name, value);
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid(null);
            throw e;
        }
    }

    @Override
    public Object removeAttribute(String name) {
        try {
            return super.removeAttribute(name);
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid(null);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(HttpServerExchange exchange) {
        Consumer closeTask;
        Map.Entry<Session<Map<String, Object>>, SessionConfig> entry = this.reference.get();
        Session<Map<String, Object>> session = entry.getKey();
        if (session.isValid()) {
            this.manager.getSessionListeners().sessionDestroyed((io.undertow.server.session.Session)this, exchange, SessionListener.SessionDestroyedReason.INVALIDATED);
            for (Map.Entry attributesEntry : session.getAttributes().entrySet()) {
                this.manager.getSessionListeners().attributeRemoved((io.undertow.server.session.Session)this, (String)attributesEntry.getKey(), attributesEntry.getValue());
            }
            if (this.statistics != null) {
                this.statistics.getInactiveSessionRecorder().record((ImmutableSessionMetaData)session.getMetaData());
            }
        }
        if ((closeTask = (Consumer)this.closeTask.getAndSet(null)) != null) {
            try (Batch batch = this.suspendedBatch.resume();){
                try (Session<Map<String, Object>> validSession = session;){
                    session.invalidate();
                }
                finally {
                    if (exchange != null) {
                        String id = session.getId();
                        entry.getValue().clearSession(exchange, id);
                    }
                }
            }
            finally {
                closeTask.accept(exchange);
            }
        }
    }

    public String changeSessionId(HttpServerExchange exchange, SessionConfig config) {
        Session<Map<String, Object>> currentSession = this.get();
        SessionManager<Map<String, Object>> manager = this.manager.getSessionManager();
        String id = (String)manager.getIdentifierFactory().get();
        try (Context context = this.suspendedBatch.resumeWithContext();){
            Session newSession = manager.createSession(id);
            try {
                newSession.getAttributes().putAll(currentSession.getAttributes());
                SessionMetaData oldMetaData = currentSession.getMetaData();
                SessionMetaData newMetaData = newSession.getMetaData();
                newMetaData.setTimeout(oldMetaData.getTimeout());
                Instant lastAccessStartTime = oldMetaData.getLastAccessStartTime();
                Instant lastAccessEndTime = oldMetaData.getLastAccessEndTime();
                if (lastAccessStartTime != null && lastAccessEndTime != null) {
                    newMetaData.setLastAccess(currentSession.getMetaData().getLastAccessStartTime(), currentSession.getMetaData().getLastAccessEndTime());
                }
                ((Map)newSession.getContext()).putAll((Map)currentSession.getContext());
                currentSession.invalidate();
                config.setSessionId(exchange, id);
                this.reference.set(Map.entry(newSession, config));
            }
            catch (IllegalStateException e) {
                this.closeIfInvalid(exchange);
                newSession.invalidate();
                throw e;
            }
        }
        if (!currentSession.isValid()) {
            this.manager.getSessionListeners().sessionIdChanged((io.undertow.server.session.Session)this, currentSession.getId());
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeIfInvalid(HttpServerExchange exchange) {
        Consumer closeTask;
        Session<Map<String, Object>> session = this.get();
        if (!session.isValid() && (closeTask = (Consumer)this.closeTask.getAndSet(null)) != null) {
            try {
                session.close();
            }
            finally {
                closeTask.accept(exchange);
            }
        }
    }
}

