/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.modules.Module;
import org.wildfly.clustering.server.immutable.Immutability;
import org.wildfly.clustering.web.container.SessionManagementProvider;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementProvider;
import org.wildfly.clustering.web.service.session.LegacyDistributableSessionManagementProviderFactory;
import org.wildfly.clustering.web.undertow.logging.UndertowClusteringLogger;
import org.wildfly.clustering.web.undertow.session.UndertowDistributableSessionManagementProvider;
import org.wildfly.extension.undertow.session.SessionManagementProviderFactory;

public class UndertowSessionManagementProviderFactory
implements SessionManagementProviderFactory {
    private final LegacyDistributableSessionManagementProviderFactory legacyFactory = ServiceLoader.load(LegacyDistributableSessionManagementProviderFactory.class, LegacyDistributableSessionManagementProviderFactory.class.getClassLoader()).findFirst().orElseThrow();

    public SessionManagementProvider createSessionManagementProvider(DeploymentPhaseContext context, ReplicationConfig config) {
        DeploymentUnit unit = context.getDeploymentUnit();
        DistributableSessionManagementProvider provider = (DistributableSessionManagementProvider)unit.getAttachment(DistributableSessionManagementProvider.ATTACHMENT_KEY);
        if (config != null || provider == null) {
            if (provider != null) {
                UndertowClusteringLogger.ROOT_LOGGER.legacySessionManagementProviderOverride(unit.getName());
            } else {
                UndertowClusteringLogger.ROOT_LOGGER.legacySessionManagementProviderInUse(unit.getName());
            }
            provider = this.legacyFactory.createSessionManagerProvider(unit, config);
        }
        Module module = (Module)unit.getAttachment(Attachments.MODULE);
        List immutableClassNames = unit.getAttachmentList(DistributableSessionManagementProvider.IMMUTABILITY_ATTACHMENT_KEY);
        ArrayList<Class> immutableClasses = new ArrayList<Class>(immutableClassNames.size());
        try {
            for (String immutableClassName : immutableClassNames) {
                immutableClasses.add(module.getClassLoader().loadClass(immutableClassName));
            }
            return new UndertowDistributableSessionManagementProvider(provider, Immutability.classes(immutableClasses));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

