/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.session;

import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.wildfly.clustering.web.session.ImmutableHttpSessionAdapter;
import org.wildfly.clustering.web.session.Session;

public class HttpSessionAdapter
extends ImmutableHttpSessionAdapter {
    private final Session<?> session;

    public HttpSessionAdapter(Session<?> session) {
        super(session);
        this.session = session;
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        this.session.getMetaData().setMaxInactiveInterval(interval, TimeUnit.SECONDS);
    }

    @Override
    public void setAttribute(String name, Object value) {
        Object oldValue = this.session.getAttributes().setAttribute(name, value);
        if (value != oldValue) {
            HttpSessionBindingListener listener;
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, oldValue != null ? oldValue : value);
            for (HttpSessionAttributeListener listener2 : this.session.getContext().getSessionAttributeListeners()) {
                if (oldValue == null) {
                    listener2.attributeAdded(event);
                    continue;
                }
                if (value == null) {
                    listener2.attributeRemoved(event);
                    continue;
                }
                listener2.attributeReplaced(event);
            }
            if (oldValue instanceof HttpSessionBindingListener) {
                listener = (HttpSessionBindingListener)oldValue;
                listener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
            if (value instanceof HttpSessionBindingListener) {
                listener = (HttpSessionBindingListener)value;
                listener.valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
        }
    }

    @Override
    public void removeAttribute(String name) {
        Object value = this.session.getAttributes().removeAttribute(name);
        if (value != null) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, value);
            for (HttpSessionAttributeListener listener : this.session.getContext().getSessionAttributeListeners()) {
                listener.attributeRemoved(event);
            }
            if (value instanceof HttpSessionBindingListener) {
                HttpSessionBindingListener listener = (HttpSessionBindingListener)value;
                listener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
        }
    }

    @Override
    public void invalidate() {
        this.session.invalidate();
    }
}

