/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Base64;
import org.wildfly.clustering.marshalling.spi.Serializer;

public enum IdentifierSerializer implements Serializer<String>
{
    UTF8{

        public void write(DataOutput output, String id) throws IOException {
            output.writeUTF(id);
        }

        public String read(DataInput input) throws IOException {
            return input.readUTF();
        }

        @Override
        public boolean validate(String id) {
            return true;
        }
    }
    ,
    BASE64{

        public void write(DataOutput output, String id) throws IOException {
            byte[] bytes = Base64.getUrlDecoder().decode(id);
            output.writeByte(bytes.length);
            output.write(bytes);
        }

        public String read(DataInput input) throws IOException {
            byte[] decoded = new byte[input.readUnsignedByte()];
            input.readFully(decoded);
            return Base64.getUrlEncoder().encodeToString(decoded);
        }
    }
    ,
    HEX{

        public void write(DataOutput output, String id) throws IOException {
            if (id.length() % 2 != 0) {
                throw new IllegalArgumentException(id);
            }
            byte[] bytes = new byte[id.length() / 2];
            for (int i = 0; i < bytes.length; ++i) {
                int index = i * 2;
                int high = Character.digit(id.charAt(index), 16) << 4;
                int low = Character.digit(id.charAt(index + 1), 16);
                bytes[i] = (byte)(high + low);
            }
            output.writeByte(bytes.length);
            output.write(bytes);
        }

        public String read(DataInput input) throws IOException {
            byte[] decoded = new byte[input.readUnsignedByte()];
            input.readFully(decoded);
            StringBuilder builder = new StringBuilder(decoded.length * 2);
            for (byte b : decoded) {
                builder.append(Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16)));
                builder.append(Character.toUpperCase(Character.forDigit(b & 0xF, 16)));
            }
            return builder.toString();
        }
    };

    private static final DataOutput NULL_SINK;

    public boolean validate(String id) {
        try {
            this.write(NULL_SINK, id);
            return true;
        }
        catch (IOException | IllegalArgumentException e) {
            return false;
        }
    }

    static {
        NULL_SINK = new DataOutput(){

            @Override
            public void write(int b) throws IOException {
            }

            @Override
            public void write(byte[] b) throws IOException {
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
            }

            @Override
            public void writeBoolean(boolean v) throws IOException {
            }

            @Override
            public void writeByte(int v) throws IOException {
            }

            @Override
            public void writeShort(int v) throws IOException {
            }

            @Override
            public void writeChar(int v) throws IOException {
            }

            @Override
            public void writeInt(int v) throws IOException {
            }

            @Override
            public void writeLong(long v) throws IOException {
            }

            @Override
            public void writeFloat(float v) throws IOException {
            }

            @Override
            public void writeDouble(double v) throws IOException {
            }

            @Override
            public void writeBytes(String s) throws IOException {
            }

            @Override
            public void writeChars(String s) throws IOException {
            }

            @Override
            public void writeUTF(String s) throws IOException {
            }
        };
    }
}

