/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso.coarse;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Set;
import org.jboss.as.clustering.infinispan.io.AbstractSimpleExternalizer;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSSOCacheEntry;
import org.wildfly.clustering.web.sso.AuthenticationType;
import org.wildfly.clustering.web.sso.WebApplication;

public class CoarseSSOCacheEntryExternalizer
extends AbstractSimpleExternalizer<CoarseSSOCacheEntry<?>> {
    private static final long serialVersionUID = 4667240286133879206L;

    public CoarseSSOCacheEntryExternalizer() {
        this(CoarseSSOCacheEntry.class);
    }

    private CoarseSSOCacheEntryExternalizer(Class targetClass) {
        super(targetClass);
    }

    public void writeObject(ObjectOutput output, CoarseSSOCacheEntry<?> entry) throws IOException {
        output.writeByte(entry.getAuthenticationType().ordinal());
        output.writeUTF(entry.getUser());
        output.writeUTF(entry.getPassword());
        Set<Map.Entry<WebApplication, String>> sessions = entry.getSessions().entrySet();
        output.writeInt(sessions.size());
        for (Map.Entry<WebApplication, String> session : sessions) {
            WebApplication application = session.getKey();
            output.writeUTF(application.getContext());
            output.writeUTF(application.getHost());
            output.writeUTF(session.getValue());
        }
    }

    public CoarseSSOCacheEntry<?> readObject(ObjectInput input) throws IOException {
        CoarseSSOCacheEntry entry = new CoarseSSOCacheEntry();
        entry.setAuthenticationType(AuthenticationType.values()[input.readByte()]);
        entry.setUser(input.readUTF());
        entry.setPassword(input.readUTF());
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            entry.getSessions().put(new WebApplication(input.readUTF(), input.readUTF()), input.readUTF());
        }
        return entry;
    }
}

