/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso;

import org.infinispan.Cache;
import org.wildfly.clustering.web.Batch;
import org.wildfly.clustering.web.Batcher;
import org.wildfly.clustering.web.infinispan.sso.SSOFactory;
import org.wildfly.clustering.web.sso.SSO;
import org.wildfly.clustering.web.sso.SSOManager;

public class InfinispanSSOManager<V, L>
implements SSOManager<L>,
Batcher {
    private final SSOFactory<V, L> factory;
    final Cache<String, V> cache;

    public InfinispanSSOManager(SSOFactory<V, L> factory, Cache<String, V> cache) {
        this.factory = factory;
        this.cache = cache;
    }

    public SSO<L> createSSO(String ssoId) {
        return this.factory.createSSO(ssoId, this.factory.createValue(ssoId));
    }

    public SSO<L> findSSO(String ssoId) {
        Object value = this.factory.findValue(ssoId);
        return value != null ? this.factory.createSSO(ssoId, value) : null;
    }

    public Batch startBatch() {
        final boolean started = this.cache.startBatch();
        return new Batch(){

            public void close() {
                this.end(true);
            }

            public void discard() {
                this.end(false);
            }

            private void end(boolean success) {
                if (started) {
                    InfinispanSSOManager.this.cache.endBatch(success);
                }
            }
        };
    }

    public Batcher getBatcher() {
        return this;
    }
}

