/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.infinispan.subsystem.AbstractCacheConfigurationService;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.msc.value.Value;

public class SessionCacheConfigurationService
extends AbstractCacheConfigurationService {
    private final Value<Configuration> configuration;
    private final Value<EmbeddedCacheManager> container;
    private final JBossWebMetaData metaData;

    public SessionCacheConfigurationService(String name, Value<EmbeddedCacheManager> container, Value<Configuration> configuration, JBossWebMetaData metaData) {
        super(name);
        Integer maxActiveSessions;
        ReplicationGranularity granularity;
        this.configuration = configuration;
        this.container = container;
        this.metaData = metaData;
        ReplicationConfig config = this.metaData.getReplicationConfig();
        if (config == null) {
            config = new ReplicationConfig();
            this.metaData.setReplicationConfig(config);
        }
        if ((granularity = config.getReplicationGranularity()) == null) {
            config.setReplicationGranularity(ReplicationGranularity.SESSION);
        }
        if ((maxActiveSessions = this.metaData.getMaxActiveSessions()) == null) {
            this.metaData.setMaxActiveSessions(Integer.valueOf(-1));
        }
    }

    protected ConfigurationBuilder getConfigurationBuilder() {
        Configuration config = (Configuration)this.configuration.getValue();
        ConfigurationBuilder builder = new ConfigurationBuilder().read(config);
        builder.storeAsBinary().disable().storeKeysAsBinary(false).storeValuesAsBinary(false);
        builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        return builder;
    }

    protected EmbeddedCacheManager getCacheContainer() {
        return (EmbeddedCacheManager)this.container.getValue();
    }
}

