/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan;

import java.util.Collections;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;

public interface Evictor<K> {
    public void evict(K var1);

    public static class EvictOperation<K, V>
    implements CacheInvoker.Operation<K, V, Void> {
        private final K key;

        public EvictOperation(K key) {
            this.key = key;
        }

        public Void invoke(Cache<K, V> cache) {
            cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_LOCKING}).evict(this.key);
            return null;
        }
    }

    public static class LockingEvictOperation<K, V>
    implements CacheInvoker.Operation<K, V, Boolean> {
        private final K key;

        public LockingEvictOperation(K key) {
            this.key = key;
        }

        public Boolean invoke(Cache<K, V> cache) {
            boolean locked = cache.getAdvancedCache().lock(Collections.singleton(this.key));
            if (locked) {
                cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_LOCKING}).evict(this.key);
            }
            return locked;
        }
    }
}

