/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.time.Duration;
import java.time.Instant;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.marshalling.spi.DefaultExternalizer;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaData;
import org.wildfly.clustering.web.cache.session.SessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.SessionCreationMetaData;
import org.wildfly.clustering.web.cache.session.SimpleSessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.SimpleSessionCreationMetaData;
import org.wildfly.clustering.web.infinispan.session.Scheduler;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class ScheduleSchedulerCommand
implements Command<Void, Scheduler> {
    private static final long serialVersionUID = -2606847692331278614L;
    private transient ImmutableSessionMetaData metaData;
    private final String sessionId;

    public ScheduleSchedulerCommand(String sessionId, ImmutableSessionMetaData metaData) {
        this.sessionId = sessionId;
        this.metaData = metaData;
    }

    public Void execute(Scheduler scheduler) {
        scheduler.schedule(this.sessionId, this.metaData);
        return null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Instant creationTime = this.metaData.getCreationTime();
        Duration maxInactiveInterval = this.metaData.getMaxInactiveInterval();
        Duration lastAccessedDuration = Duration.between(creationTime, this.metaData.getLastAccessedTime());
        out.defaultWriteObject();
        DefaultExternalizer.INSTANT.writeObject((ObjectOutput)out, (Object)creationTime);
        DefaultExternalizer.DURATION.writeObject((ObjectOutput)out, (Object)maxInactiveInterval);
        DefaultExternalizer.DURATION.writeObject((ObjectOutput)out, (Object)lastAccessedDuration);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Instant creationTime = (Instant)DefaultExternalizer.INSTANT.cast(Instant.class).readObject((ObjectInput)in);
        Duration maxInactiveInterval = (Duration)DefaultExternalizer.DURATION.cast(Duration.class).readObject((ObjectInput)in);
        Duration lastAccessedDuration = (Duration)DefaultExternalizer.DURATION.cast(Duration.class).readObject((ObjectInput)in);
        SimpleSessionCreationMetaData creationMetaData = new SimpleSessionCreationMetaData(creationTime);
        creationMetaData.setMaxInactiveInterval(maxInactiveInterval);
        SimpleSessionAccessMetaData accessMetaData = new SimpleSessionAccessMetaData();
        accessMetaData.setLastAccessedDuration(lastAccessedDuration);
        this.metaData = new CompositeSessionMetaData((SessionCreationMetaData)creationMetaData, (SessionAccessMetaData)accessMetaData);
    }
}

