/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.Scheduler;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class SessionExpirationScheduler
implements Scheduler {
    final Map<String, Future<?>> expirationFutures = new ConcurrentHashMap();
    final Batcher<TransactionBatch> batcher;
    final Remover<String> remover;
    private final ScheduledExecutorService executor;

    public SessionExpirationScheduler(Batcher<TransactionBatch> batcher, Remover<String> remover) {
        this(batcher, remover, SessionExpirationScheduler.createScheduledExecutor(SessionExpirationScheduler.createThreadFactory()));
    }

    private static ThreadFactory createThreadFactory() {
        return AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

            @Override
            public ThreadFactory run() {
                return new JBossThreadFactory(new ThreadGroup(SessionExpirationScheduler.class.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null);
            }
        });
    }

    private static ScheduledExecutorService createScheduledExecutor(ThreadFactory factory) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, factory);
        executor.setRemoveOnCancelPolicy(true);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return executor;
    }

    public SessionExpirationScheduler(Batcher<TransactionBatch> batcher, Remover<String> remover, ScheduledExecutorService executor) {
        this.batcher = batcher;
        this.remover = remover;
        this.executor = executor;
    }

    @Override
    public void cancel(String sessionId) {
        Future<?> future = this.expirationFutures.remove(sessionId);
        if (future != null) {
            future.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(String sessionId, ImmutableSessionMetaData metaData) {
        Duration maxInactiveInterval = metaData.getMaxInactiveInterval();
        if (!maxInactiveInterval.isZero()) {
            Instant lastAccessed = metaData.getLastAccessedTime();
            Duration delay = Duration.between(Instant.now(), lastAccessed.plus(maxInactiveInterval));
            ExpirationTask task = new ExpirationTask(sessionId);
            long seconds = !delay.isNegative() ? delay.getSeconds() + 1L : 0L;
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s will expire in %d sec", sessionId, seconds);
            ExpirationTask expirationTask = task;
            synchronized (expirationTask) {
                this.expirationFutures.put(sessionId, this.executor.schedule(task, seconds, TimeUnit.SECONDS));
            }
        }
    }

    @Override
    public void cancel(Locality locality) {
        for (String sessionId : this.expirationFutures.keySet()) {
            if (Thread.currentThread().isInterrupted()) break;
            if (locality.isLocal((Object)sessionId)) continue;
            this.cancel(sessionId);
        }
    }

    @Override
    public void close() {
        this.executor.shutdown();
        for (Future<?> future : this.expirationFutures.values()) {
            future.cancel(true);
        }
        for (Future<?> future : this.expirationFutures.values()) {
            if (future.isDone()) continue;
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {}
        }
        this.expirationFutures.clear();
    }

    private class ExpirationTask
    implements Runnable {
        private final String id;

        ExpirationTask(String id) {
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InfinispanWebLogger.ROOT_LOGGER.tracef("Expiring session %s", this.id);
            try (Batch batch = SessionExpirationScheduler.this.batcher.createBatch();){
                try {
                    SessionExpirationScheduler.this.remover.remove((Object)this.id);
                }
                catch (Throwable e) {
                    InfinispanWebLogger.ROOT_LOGGER.failedToExpireSession(e, this.id);
                    batch.discard();
                }
            }
            finally {
                ExpirationTask expirationTask = this;
                synchronized (expirationTask) {
                    SessionExpirationScheduler.this.expirationFutures.remove(this.id);
                }
            }
        }
    }
}

