/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ServiceLoader;
import org.infinispan.configuration.cache.CacheMode;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.service.CacheBuilder;
import org.wildfly.clustering.infinispan.spi.service.TemplateConfigurationBuilder;
import org.wildfly.clustering.spi.CacheAliasBuilderProvider;
import org.wildfly.clustering.spi.CacheBuilderProvider;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.spi.ServiceNameRegistry;

public class RouteCacheGroupBuilderProvider
implements CacheBuilderProvider,
CacheAliasBuilderProvider {
    static final String CACHE_NAME = "routing";
    private final Class<? extends CacheBuilderProvider> providerClass;

    RouteCacheGroupBuilderProvider(Class<? extends CacheBuilderProvider> providerClass) {
        this.providerClass = providerClass;
    }

    public Collection<CapabilityServiceBuilder<?>> getBuilders(ServiceNameRegistry<ClusteringCacheRequirement> registry, String containerName, String aliasCacheName) {
        LinkedList builders = new LinkedList();
        if (aliasCacheName == null) {
            builders.add((CapabilityServiceBuilder<?>)new TemplateConfigurationBuilder(ServiceName.parse((String)InfinispanCacheRequirement.CONFIGURATION.resolve(containerName, CACHE_NAME)), containerName, CACHE_NAME, aliasCacheName, builder -> {
                CacheMode mode = builder.clustering().cacheMode();
                builder.clustering().cacheMode(mode.isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL);
                builder.clustering().l1().disable();
                builder.persistence().clearStores();
            }));
            builders.add((CapabilityServiceBuilder<?>)new CacheBuilder(ServiceName.parse((String)InfinispanCacheRequirement.CACHE.resolve(containerName, CACHE_NAME)), containerName, CACHE_NAME));
            ServiceNameRegistry routingRegistry = requirement -> ServiceName.parse((String)requirement.resolve(containerName, CACHE_NAME));
            for (CacheBuilderProvider cacheBuilderProvider : ServiceLoader.load(this.providerClass, this.providerClass.getClassLoader())) {
                builders.addAll(cacheBuilderProvider.getBuilders(routingRegistry, containerName, CACHE_NAME));
            }
        }
        return builders;
    }

    public Collection<CapabilityServiceBuilder<?>> getBuilders(ServiceNameRegistry<ClusteringCacheRequirement> registry, String containerName, String aliasCacheName, String targetCacheName) {
        return this.getBuilders(registry, containerName, aliasCacheName);
    }
}

