/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.fine;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.MutableCacheEntry;
import org.wildfly.clustering.ee.infinispan.Mutator;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.marshalling.jboss.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.jboss.MarshalledValue;
import org.wildfly.clustering.marshalling.jboss.Marshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.InfinispanImmutableSession;
import org.wildfly.clustering.web.infinispan.session.InfinispanSession;
import org.wildfly.clustering.web.infinispan.session.MutableSessionAccessMetaData;
import org.wildfly.clustering.web.infinispan.session.MutableSessionCreationMetaData;
import org.wildfly.clustering.web.infinispan.session.SessionAccessMetaData;
import org.wildfly.clustering.web.infinispan.session.SessionAccessMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaData;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataEntry;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionAccessMetaData;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionCreationMetaData;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionMetaData;
import org.wildfly.clustering.web.infinispan.session.fine.FineImmutableSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionEntry;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionContext;

public class FineSessionFactory<L>
implements SessionFactory<FineSessionEntry<L>, L> {
    private final Cache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<L>> creationMetaDataCache;
    private final Cache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<L>> findCreationMetaDataCache;
    private final Cache<SessionAccessMetaDataKey, SessionAccessMetaData> accessMetaDataCache;
    private final Cache<SessionAttributeKey, MarshalledValue<Object, MarshallingContext>> attributeCache;
    private final SessionContext context;
    private final Marshaller<Object, MarshalledValue<Object, MarshallingContext>, MarshallingContext> marshaller;
    private final LocalContextFactory<L> localContextFactory;
    private final Predicate<Map.Entry<SessionAttributeKey, MarshalledValue<Object, MarshallingContext>>> invalidAttribute;

    public FineSessionFactory(Cache<? extends Key<String>, ?> cache, SessionContext context, Marshaller<Object, MarshalledValue<Object, MarshallingContext>, MarshallingContext> marshaller, LocalContextFactory<L> localContextFactory, boolean lockOnRead) {
        this.creationMetaDataCache = cache;
        this.findCreationMetaDataCache = lockOnRead ? this.creationMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}) : this.creationMetaDataCache;
        this.accessMetaDataCache = cache;
        this.attributeCache = cache;
        this.context = context;
        this.marshaller = marshaller;
        this.localContextFactory = localContextFactory;
        this.invalidAttribute = entry -> {
            try {
                this.marshaller.read(entry.getValue());
                return false;
            }
            catch (InvalidSerializedFormException e) {
                InfinispanWebLogger.ROOT_LOGGER.failedToActivateSessionAttribute(e, (String)((SessionAttributeKey)((Object)((Object)entry.getKey()))).getValue(), ((SessionAttributeKey)((Object)((Object)entry.getKey()))).getAttribute());
                return true;
            }
        };
    }

    @Override
    public Session<L> createSession(String id, FineSessionEntry<L> entry) {
        MutableCacheEntry<SessionCreationMetaData> creationMetaDataEntry = entry.getMutableSessionCreationMetaDataEntry();
        MutableCacheEntry<SessionAccessMetaData> accessMetaDataEntry = entry.getMutableSessionAccessMetaDataEntry();
        MutableSessionCreationMetaData creationMetaData = new MutableSessionCreationMetaData((SessionCreationMetaData)creationMetaDataEntry.getValue(), creationMetaDataEntry.getMutator());
        MutableSessionAccessMetaData accessMetaData = new MutableSessionAccessMetaData((SessionAccessMetaData)accessMetaDataEntry.getValue(), accessMetaDataEntry.getMutator());
        SimpleSessionMetaData metaData = new SimpleSessionMetaData(creationMetaData, accessMetaData);
        FineSessionAttributes<MarshalledValue<Object, MarshallingContext>> attributes = new FineSessionAttributes<MarshalledValue<Object, MarshallingContext>>(id, this.attributeCache, this.marshaller);
        return new InfinispanSession<L>(id, metaData, attributes, entry.getLocalContext(), this.localContextFactory, this.context, this);
    }

    @Override
    public ImmutableSession createImmutableSession(String id, FineSessionEntry<L> entry) {
        SessionCreationMetaData creationMetaData = (SessionCreationMetaData)entry.getMutableSessionCreationMetaDataEntry().getValue();
        SessionAccessMetaData accessMetaData = (SessionAccessMetaData)entry.getMutableSessionAccessMetaDataEntry().getValue();
        SimpleSessionMetaData metaData = new SimpleSessionMetaData(creationMetaData, accessMetaData);
        FineImmutableSessionAttributes<MarshalledValue<Object, MarshallingContext>> attributes = new FineImmutableSessionAttributes<MarshalledValue<Object, MarshallingContext>>(id, this.attributeCache, this.marshaller);
        return new InfinispanImmutableSession(id, metaData, attributes, this.context);
    }

    public FineSessionEntry<L> createValue(String id, Void context) {
        SessionCreationMetaDataKey creationMetaDataKey = new SessionCreationMetaDataKey(id);
        SessionCreationMetaDataEntry creationMetaDataEntry = new SessionCreationMetaDataEntry(new SimpleSessionCreationMetaData());
        SessionCreationMetaDataEntry existingCreationMetaDataEntry = (SessionCreationMetaDataEntry)this.creationMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent((Object)creationMetaDataKey, creationMetaDataEntry);
        Mutator creationMetaDataMutator = Mutator.PASSIVE;
        if (existingCreationMetaDataEntry != null) {
            creationMetaDataEntry = existingCreationMetaDataEntry;
            creationMetaDataMutator = new CacheEntryMutator(this.creationMetaDataCache, (Object)creationMetaDataKey, (Object)creationMetaDataEntry);
        }
        SessionAccessMetaDataKey accessMetaDataKey = new SessionAccessMetaDataKey(id);
        SessionAccessMetaData accessMetaData = new SimpleSessionAccessMetaData();
        Mutator accessMetaDataMutator = Mutator.PASSIVE;
        if (existingCreationMetaDataEntry == null) {
            this.accessMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)accessMetaDataKey, (Object)accessMetaData);
        } else {
            SessionAccessMetaData existingAccessMetaData = (SessionAccessMetaData)this.accessMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent((Object)accessMetaDataKey, (Object)accessMetaData);
            if (existingAccessMetaData != null) {
                accessMetaData = existingAccessMetaData;
                accessMetaDataMutator = new CacheEntryMutator(this.accessMetaDataCache, (Object)accessMetaDataKey, (Object)accessMetaData);
            }
        }
        if (existingCreationMetaDataEntry != null && this.attributeCache.getAdvancedCache().getGroup(id).entrySet().stream().filter(entry -> entry.getKey() instanceof SessionAttributeKey).anyMatch(this.invalidAttribute)) {
            this.remove(id);
            return this.createValue(id, context);
        }
        return new FineSessionEntry((MutableCacheEntry<SessionCreationMetaData>)new MutableCacheEntry((Object)creationMetaDataEntry.getMetaData(), creationMetaDataMutator), (MutableCacheEntry<SessionAccessMetaData>)new MutableCacheEntry((Object)accessMetaData, accessMetaDataMutator), creationMetaDataEntry.getLocalContext());
    }

    public FineSessionEntry<L> findValue(String id) {
        SessionCreationMetaDataKey creationMetaDataKey = new SessionCreationMetaDataKey(id);
        SessionCreationMetaDataEntry creationMetaDataEntry = (SessionCreationMetaDataEntry)this.findCreationMetaDataCache.get((Object)creationMetaDataKey);
        if (creationMetaDataEntry != null) {
            CacheEntryMutator creationMetaDataMutator = new CacheEntryMutator(this.creationMetaDataCache, (Object)creationMetaDataKey, (Object)creationMetaDataEntry);
            SessionAccessMetaDataKey accessMetaDataKey = new SessionAccessMetaDataKey(id);
            SessionAccessMetaData accessMetaData = (SessionAccessMetaData)this.accessMetaDataCache.get((Object)accessMetaDataKey);
            if (accessMetaData != null) {
                CacheEntryMutator accessMetaDataMutator = new CacheEntryMutator(this.accessMetaDataCache, (Object)accessMetaDataKey, (Object)accessMetaData);
                if (this.attributeCache.getAdvancedCache().getGroup(id).entrySet().stream().filter(entry -> entry.getKey() instanceof SessionAttributeKey).anyMatch(this.invalidAttribute)) {
                    this.remove(id);
                    return null;
                }
                return new FineSessionEntry((MutableCacheEntry<SessionCreationMetaData>)new MutableCacheEntry((Object)creationMetaDataEntry.getMetaData(), (Mutator)creationMetaDataMutator), (MutableCacheEntry<SessionAccessMetaData>)new MutableCacheEntry((Object)accessMetaData, (Mutator)accessMetaDataMutator), creationMetaDataEntry.getLocalContext());
            }
            this.attributeCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).removeGroup(id);
        }
        return null;
    }

    public void remove(String id) {
        this.creationMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)new SessionCreationMetaDataKey(id));
        this.accessMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)new SessionAccessMetaDataKey(id));
        this.attributeCache.getAdvancedCache().removeGroup(id);
    }

    public void evict(String id) {
        try {
            this.creationMetaDataCache.evict((Object)new SessionCreationMetaDataKey(id));
            this.accessMetaDataCache.evict((Object)new SessionAccessMetaDataKey(id));
            Consumer<SessionAttributeKey> evictor = key -> {
                try {
                    this.attributeCache.evict((Object)key);
                }
                catch (Throwable e) {
                    InfinispanWebLogger.ROOT_LOGGER.failedToPassivateSessionAttribute(e, id, key.getAttribute());
                }
            };
            this.attributeCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD}).getGroup(id).keySet().stream().filter(key -> key instanceof SessionAttributeKey).forEach(evictor);
        }
        catch (Throwable e) {
            InfinispanWebLogger.ROOT_LOGGER.failedToPassivateSession(e, id);
        }
    }
}

