/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.concurrent.TimeUnit;

public class Time
implements Comparable<Time> {
    private final long value;
    private final TimeUnit unit;

    public Time(long value, TimeUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    public long getValue() {
        return this.value;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public long convert(TimeUnit unit) {
        return unit.convert(this.value, this.unit);
    }

    @Override
    public int compareTo(Time time) {
        TimeUnit compareUnit = TimeUnit.values()[Math.min(this.unit.ordinal(), time.unit.ordinal())];
        return Long.compare(this.convert(compareUnit), time.convert(compareUnit));
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Time)) {
            return false;
        }
        Time time = (Time)object;
        TimeUnit compareUnit = TimeUnit.MILLISECONDS;
        return compareUnit.convert(this.value, this.unit) == compareUnit.convert(time.value, time.unit);
    }

    public int hashCode() {
        return Long.valueOf(TimeUnit.MILLISECONDS.convert(this.value, this.unit)).hashCode();
    }

    public String toString() {
        return String.format("%d %s", new Object[]{this.value, this.unit});
    }
}

