/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamDataInput;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamDataOutput;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.ScalarMarshaller;
import org.wildfly.clustering.marshalling.spi.Serializer;
import org.wildfly.clustering.web.IdentifierSerializerProvider;
import org.wildfly.security.manager.WildFlySecurityManager;

public enum SessionIdentifierMarshaller implements ScalarMarshaller<String>
{
    INSTANCE;

    private final Serializer<String> serializer = SessionIdentifierMarshaller.loadSerializer();

    private static Serializer<String> loadSerializer() {
        Iterator<IdentifierSerializerProvider> providers = SessionIdentifierMarshaller.load(IdentifierSerializerProvider.class).iterator();
        if (!providers.hasNext()) {
            throw new ServiceConfigurationError(IdentifierSerializerProvider.class.getName());
        }
        return providers.next().getSerializer();
    }

    private static <T> Iterable<T> load(final Class<T> providerClass) {
        PrivilegedAction action = new PrivilegedAction<Iterable<T>>(){

            @Override
            public Iterable<T> run() {
                return ServiceLoader.load(providerClass, providerClass.getClassLoader());
            }
        };
        return (Iterable)WildFlySecurityManager.doUnchecked((PrivilegedAction)action);
    }

    public String readFrom(ProtoStreamReader reader) throws IOException {
        return (String)this.serializer.read((DataInput)new ProtoStreamDataInput(reader));
    }

    public void writeTo(ProtoStreamWriter writer, String id) throws IOException {
        this.serializer.write((DataOutput)new ProtoStreamDataOutput(writer), (Object)id);
    }

    public Class<? extends String> getJavaClass() {
        return String.class;
    }

    public int getWireType() {
        return 2;
    }
}

