/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.Externalizer;

public class SingletonCollectionExternalizer<T extends Collection<Object>>
implements Externalizer<T> {
    private final Function<Object, T> factory;

    public SingletonCollectionExternalizer(Function<Object, T> factory) {
        this.factory = factory;
    }

    public void writeObject(ObjectOutput output, T collection) throws IOException {
        output.writeObject(collection.iterator().next());
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return (T)((Collection)this.factory.apply(input.readObject()));
    }

    public Class<T> getTargetClass() {
        return ((Collection)this.factory.apply(null)).getClass();
    }
}

