/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;
import org.wildfly.clustering.marshalling.spi.IntSerializer;

public class EnumExternalizer<E extends Enum<E>>
implements Externalizer<E> {
    private final IntSerializer ordinalExternalizer;
    private final Class<E> enumClass;
    private final E[] values;

    public EnumExternalizer(Class<E> enumClass) {
        this.ordinalExternalizer = IndexSerializer.select(((Enum[])enumClass.getEnumConstants()).length);
        this.enumClass = enumClass;
        this.values = (Enum[])enumClass.getEnumConstants();
    }

    public void writeObject(ObjectOutput output, E value) throws IOException {
        this.ordinalExternalizer.writeInt(output, ((Enum)value).ordinal());
    }

    public E readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return this.values[this.ordinalExternalizer.readInt(input)];
    }

    public Class<E> getTargetClass() {
        return this.enumClass;
    }
}

