/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.modules;

import java.io.IOException;
import java.io.InvalidClassException;
import org.infinispan.protostream.descriptors.WireType;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class ModuleClassLoaderMarshaller
implements ClassLoaderMarshaller {
    private static final int MODULE_INDEX = 0;
    private static final int FIELDS = 1;
    private final ModuleLoader loader;
    private final Module defaultModule;

    public ModuleClassLoaderMarshaller(Module defaultModule) {
        this.loader = defaultModule.getModuleLoader();
        this.defaultModule = defaultModule;
    }

    public ModuleClassLoaderMarshaller(ModuleLoader loader) {
        this.loader = loader;
        try {
            this.defaultModule = Module.getSystemModuleLoader().loadModule("java.base");
        }
        catch (ModuleLoadException e) {
            throw new IllegalStateException(e);
        }
    }

    public ClassLoader createInitialValue() {
        return this.defaultModule.getClassLoader();
    }

    public int getFields() {
        return 1;
    }

    public ClassLoader readFrom(ProtoStreamReader reader, int index, WireType type, ClassLoader loader) throws IOException {
        switch (index) {
            case 0: {
                String moduleName = (String)reader.readAny(String.class);
                try {
                    Module module = this.loader.loadModule(moduleName);
                    return module.getClassLoader();
                }
                catch (ModuleLoadException e) {
                    InvalidClassException exception = new InvalidClassException(e.getMessage());
                    exception.initCause(e);
                    throw exception;
                }
            }
        }
        reader.skipField(type);
        return loader;
    }

    public void writeTo(ProtoStreamWriter writer, ClassLoader loader) throws IOException {
        Module module = Module.forClassLoader((ClassLoader)loader, (boolean)false);
        if (module != null && !this.defaultModule.equals(module)) {
            writer.writeAny(0, (Object)module.getName());
        }
    }
}

