/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import org.jboss.as.clustering.jgroups.ClassLoaderThreadFactory;
import org.jboss.as.clustering.jgroups.JChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolConfigurationResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolConfiguration;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolResourceDefinitionRegistrar;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jgroups.protocols.TP;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.ThreadPool;
import org.wildfly.clustering.jgroups.spi.ChannelFactoryConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.AttributeDefinitionProvider;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceAttributeDefinition;
import org.wildfly.subsystem.service.ServiceDependency;

public class AbstractTransportResourceDefinitionRegistrar<T extends TP>
extends ProtocolConfigurationResourceDefinitionRegistrar<T, TransportConfiguration<T>> {
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)TransportConfiguration.SERVICE_DESCRIPTOR).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.PARENT).build();

    AbstractTransportResourceDefinitionRegistrar(Configurator configurator) {
        super(configurator);
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)super.apply(builder).provideAttributes(EnumSet.allOf(SocketBindingAttribute.class))).provideAttributes(EnumSet.allOf(TopologyAttribute.class))).requireChildResources(EnumSet.allOf(ThreadPoolResourceDefinitionRegistrar.class));
    }

    public ServiceDependency<TransportConfiguration<T>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final ServiceDependency factory = (ServiceDependency)this.resolver.resolve(context, model);
        final ServiceDependency threadPool = ServiceDependency.on((UnaryServiceDescriptor)ThreadPoolResourceDefinitionRegistrar.DEFAULT, (String)context.getCurrentAddress().getParent().getLastElement().getValue());
        final ServiceDependency<SocketBinding> serverSocketBinding = SocketBindingAttribute.SERVER.resolve(context, model);
        final ServiceDependency<SocketBinding> diagnosticsSocketBinding = SocketBindingAttribute.DIAGNOSTICS.resolve(context, model);
        final String machine = TopologyAttribute.MACHINE.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        final String rack = TopologyAttribute.RACK.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        final String site = TopologyAttribute.SITE.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        final TransportConfiguration.Topology topology = site != null || rack != null || machine != null ? new TransportConfiguration.Topology(){

            public String getMachine() {
                return machine;
            }

            public String getRack() {
                return rack;
            }

            public String getSite() {
                return site;
            }
        } : null;
        return new ServiceDependency<TransportConfiguration<T>>(){

            public void accept(RequirementServiceBuilder<?> builder) {
                factory.accept(builder);
                threadPool.accept(builder);
                serverSocketBinding.accept(builder);
                diagnosticsSocketBinding.accept(builder);
            }

            public TransportConfiguration<T> get() {
                return new TransportProtocolConfigurationDecorator<T>((ProtocolConfiguration)factory.get()){

                    @Override
                    public T createProtocol(ChannelFactoryConfiguration configuration) {
                        TP protocol = (TP)super.createProtocol(configuration);
                        SocketBinding binding = this.getSocketBinding();
                        InetSocketAddress socketAddress = binding.getSocketAddress();
                        protocol.setBindAddress(socketAddress.getAddress());
                        protocol.setBindPort(socketAddress.getPort());
                        List clientMappings = binding.getClientMappings();
                        if (!clientMappings.isEmpty()) {
                            ClientMapping mapping = (ClientMapping)clientMappings.get(0);
                            try {
                                protocol.setExternalAddr(InetAddress.getByName(mapping.getDestinationAddress()));
                                protocol.setExternalPort(mapping.getDestinationPort());
                            }
                            catch (UnknownHostException e) {
                                throw new IllegalArgumentException(e);
                            }
                        }
                        ThreadPoolConfiguration threadPoolConfiguration = (ThreadPoolConfiguration)threadPool.get();
                        ThreadPool threadPool = protocol.getThreadPool();
                        threadPool.setMinThreads(threadPoolConfiguration.getMinThreads());
                        threadPool.setMaxThreads(threadPoolConfiguration.getMaxThreads());
                        threadPool.setKeepAliveTime(threadPoolConfiguration.getKeepAlive().toMillis());
                        threadPool.setRejectionPolicy("discard");
                        protocol.setThreadFactory((ThreadFactory)new ClassLoaderThreadFactory((ThreadFactory)new DefaultThreadFactory("jgroups", false, true).useVirtualThreads(protocol.useVirtualThreads()), JChannelFactory.class.getClassLoader()));
                        SocketBinding diagnosticsBinding = (SocketBinding)diagnosticsSocketBinding.get();
                        if (diagnosticsBinding != null) {
                            DiagnosticsHandler handler = new DiagnosticsHandler(protocol.getLog(), protocol.getSocketFactory(), protocol.getThreadFactory());
                            InetSocketAddress address = diagnosticsBinding.getSocketAddress();
                            handler.setBindAddress(address.getAddress());
                            if (diagnosticsBinding.getMulticastAddress() != null) {
                                handler.setMcastAddress(diagnosticsBinding.getMulticastAddress());
                                handler.setPort(diagnosticsBinding.getMulticastPort());
                            } else {
                                handler.setPort(diagnosticsBinding.getPort());
                            }
                            try {
                                protocol.setDiagnosticsHandler(handler);
                            }
                            catch (Exception e) {
                                throw new IllegalStateException(e);
                            }
                        }
                        return protocol;
                    }

                    public TransportConfiguration.Topology getTopology() {
                        return topology;
                    }

                    public SocketBinding getSocketBinding() {
                        return (SocketBinding)serverSocketBinding.get();
                    }
                };
            }
        };
    }

    static enum SocketBindingAttribute implements AttributeDefinitionProvider,
    ResourceModelResolver<ServiceDependency<SocketBinding>>
    {
        SERVER("socket-binding", true),
        DIAGNOSTICS("diagnostics-socket-binding", false);

        private final CapabilityReferenceAttributeDefinition<SocketBinding> attribute;

        private SocketBindingAttribute(String name, boolean required) {
            this.attribute = ((CapabilityReferenceAttributeDefinition.Builder)((CapabilityReferenceAttributeDefinition.Builder)new CapabilityReferenceAttributeDefinition.Builder(name, CapabilityReference.builder(CAPABILITY, (UnaryServiceDescriptor)SocketBinding.SERVICE_DESCRIPTOR).build()).setRequired(required)).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF})).build();
        }

        public ServiceDependency<SocketBinding> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
            return this.attribute.resolve(context, model);
        }

        public AttributeDefinition get() {
            return this.attribute;
        }
    }

    static enum TopologyAttribute implements AttributeDefinitionProvider,
    ResourceModelResolver<String>
    {
        SITE("site"),
        RACK("rack"),
        MACHINE("machine");

        private final AttributeDefinition definition;

        private TopologyAttribute(String name) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, ModelType.STRING).setAllowExpression(true)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition get() {
            return this.definition;
        }

        public String resolve(OperationContext context, ModelNode model) throws OperationFailedException {
            return this.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        }
    }

    static abstract class TransportConfigurationDecorator<T extends TP>
    extends TransportProtocolConfigurationDecorator<T> {
        private final TransportConfiguration<T> configuration;

        TransportConfigurationDecorator(TransportConfiguration<T> configuration) {
            super(configuration);
            this.configuration = configuration;
        }

        public TransportConfiguration.Topology getTopology() {
            return this.configuration.getTopology();
        }

        public SocketBinding getSocketBinding() {
            return this.configuration.getSocketBinding();
        }
    }

    static abstract class TransportProtocolConfigurationDecorator<T extends TP>
    extends ProtocolConfigurationResourceDefinitionRegistrar.ProtocolConfigurationDecorator<T>
    implements TransportConfiguration<T> {
        TransportProtocolConfigurationDecorator(ProtocolConfiguration<T> configuration) {
            super(configuration);
        }
    }

    static interface Configurator
    extends ProtocolConfigurationResourceDefinitionRegistrar.Configurator {
        @Override
        default public RuntimeCapability<Void> getCapability() {
            return CAPABILITY;
        }

        @Override
        default public ResourceDescriptionResolver getResourceDescriptionResolver() {
            PathElement path = this.getResourceRegistration().getPathElement();
            return path.isWildcard() ? JGroupsSubsystemResourceDefinitionRegistrar.RESOLVER.createChildResolver(path, StackResourceDefinitionRegistrar.Component.PROTOCOL.getPathElement()) : JGroupsSubsystemResourceDefinitionRegistrar.RESOLVER.createChildResolver(path, StackResourceDefinitionRegistrar.Component.TRANSPORT.getPathElement(), StackResourceDefinitionRegistrar.Component.PROTOCOL.getPathElement());
        }
    }
}

