/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Collection;
import java.util.EnumSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolChildResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolConfigurationResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinitionRegistrar;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;

public class AbstractProtocolResourceDefinitionRegistrar<P extends Protocol>
extends ProtocolConfigurationResourceDefinitionRegistrar<P, ProtocolConfiguration<P>> {
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((BinaryServiceDescriptor)ProtocolConfiguration.SERVICE_DESCRIPTOR).setAllowMultipleRegistrations(true).build();
    static final UnaryOperator<OperationStepHandler> LEGACY_OPERATION_TRANSFORMER = new UnaryOperator<OperationStepHandler>(){

        @Override
        public OperationStepHandler apply(final OperationStepHandler handler) {
            return new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    PathAddress parentAddress;
                    Resource parent;
                    PathElement nativeProtocolPath;
                    PathAddress address = context.getCurrentAddress();
                    PathElement protocolPath = address.getLastElement();
                    if (!protocolPath.equals(nativeProtocolPath = StackResourceDefinitionRegistrar.Component.PROTOCOL.pathElement("org.jgroups.protocols." + protocolPath.getValue())) && (parent = context.readResourceFromRoot(parentAddress = address.getParent(), false)).hasChild(nativeProtocolPath)) {
                        PathAddress nativeAddress = parentAddress.append(new PathElement[]{nativeProtocolPath});
                        operation.get("address").set(nativeAddress.toModelNode());
                        String operationName = operation.get("operation").asString();
                        context.addStep(operation, context.getRootResourceRegistration().getOperationHandler(nativeAddress, operationName), OperationContext.Stage.MODEL, true);
                        return;
                    }
                    handler.execute(context, operation);
                }
            };
        }
    };

    AbstractProtocolResourceDefinitionRegistrar(Configurator registration) {
        super(registration);
    }

    public ServiceDependency<ProtocolConfiguration<P>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        return (ServiceDependency)this.resolver.resolve(context, model);
    }

    static interface Configurator
    extends ProtocolConfigurationResourceDefinitionRegistrar.Configurator {
        @Override
        default public RuntimeCapability<Void> getCapability() {
            return CAPABILITY;
        }

        @Override
        default public ResourceDescriptionResolver getResourceDescriptionResolver() {
            PathElement path = this.getResourceRegistration().getPathElement();
            return path.isWildcard() ? JGroupsSubsystemResourceDefinitionRegistrar.RESOLVER.createChildResolver(path) : JGroupsSubsystemResourceDefinitionRegistrar.RESOLVER.createChildResolver(path, StackResourceDefinitionRegistrar.Component.PROTOCOL.getPathElement());
        }

        @Override
        default public UnaryOperator<ResourceDefinition.Builder> getResourceDefinitionConfigurator() {
            return ResourceDefinition.Configurator::asOrderedChild;
        }
    }

    static class LegacyAddOperationTransformation
    implements UnaryOperator<OperationStepHandler> {
        private final Predicate<ModelNode> legacy;

        <E extends Enum<E>> LegacyAddOperationTransformation(Class<E> attributeClass) {
            this(EnumSet.allOf(attributeClass), (E rec$) -> (AttributeDefinition)((Supplier)rec$).get());
        }

        LegacyAddOperationTransformation(Collection<AttributeDefinition> attributes) {
            this(attributes, Function.identity());
        }

        private <E> LegacyAddOperationTransformation(Collection<E> elements, Function<E, AttributeDefinition> mapper) {
            this.legacy = operation -> {
                for (Object element : elements) {
                    AttributeDefinition attribute = (AttributeDefinition)mapper.apply(element);
                    if (!operation.hasDefined(attribute.getName())) continue;
                    return false;
                }
                return true;
            };
        }

        LegacyAddOperationTransformation(String ... legacyProperties) {
            this.legacy = operation -> {
                if (!operation.hasDefined(ProtocolChildResourceDefinitionRegistrar.PROPERTIES.getName())) {
                    return false;
                }
                for (String legacyProperty : legacyProperties) {
                    if (!operation.get(ProtocolChildResourceDefinitionRegistrar.PROPERTIES.getName()).hasDefined(legacyProperty)) continue;
                    return true;
                }
                return false;
            };
        }

        @Override
        public OperationStepHandler apply(OperationStepHandler handler) {
            return (context, operation) -> {
                if (this.legacy.test(operation)) {
                    PathElement path = context.getCurrentAddress().getLastElement();
                    OperationStepHandler genericHandler = context.getResourceRegistration().getParent().getOperationHandler(PathAddress.pathAddress((PathElement[])new PathElement[]{StackResourceDefinitionRegistrar.Component.PROTOCOL.getPathElement()}), "add");
                    operation.get("address").set(context.getCurrentAddress().getParent().append(new PathElement[]{StackResourceDefinitionRegistrar.Component.PROTOCOL.pathElement("org.jgroups.protocols." + path.getValue())}).toModelNode());
                    context.addStep(operation, genericHandler, OperationContext.Stage.MODEL, true);
                } else {
                    handler.execute(context, operation);
                }
            };
        }
    }
}

