/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.management.MBeanServer;
import org.jboss.as.clustering.controller.MBeanServerResolver;
import org.jboss.as.clustering.controller.descriptions.SimpleResourceDescriptionResolver;
import org.jboss.as.clustering.jgroups.ForkChannelFactory;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsBindingFactory;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolChildResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolMetricsHandler;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinitionRegistrar;
import org.jboss.as.clustering.naming.BinderServiceInstaller;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.jgroups.JChannel;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.FORK;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.wildfly.clustering.jgroups.spi.ChannelConfiguration;
import org.wildfly.clustering.jgroups.spi.ForkChannelFactoryConfiguration;
import org.wildfly.clustering.jgroups.spi.JGroupsServiceDescriptor;
import org.wildfly.common.function.Functions;
import org.wildfly.service.Installer;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ChildResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;
import org.wildfly.subsystem.service.capture.ServiceValueExecutorRegistry;

public abstract class AbstractChannelResourceDefinitionRegistrar<C extends ChannelConfiguration>
implements ChildResourceDefinitionRegistrar,
ResourceServiceConfigurator,
ResourceOperationRuntimeHandler,
UnaryOperator<ResourceDescriptor.Builder> {
    private static final RuntimeCapability<Void> CHANNEL = RuntimeCapability.Builder.of((UnaryServiceDescriptor)JGroupsServiceDescriptor.CHANNEL).setAllowMultipleRegistrations(true).build();
    private static final RuntimeCapability<Void> CHANNEL_FACTORY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)org.wildfly.clustering.jgroups.spi.ForkChannelFactory.SERVICE_DESCRIPTOR).setAllowMultipleRegistrations(true).build();
    private final Configurator<C> configurator;
    private final ServiceValueExecutorRegistry<JChannel> channelRegistry;

    AbstractChannelResourceDefinitionRegistrar(Configurator<C> configurator, ServiceValueExecutorRegistry<JChannel> channelRegistry) {
        this.configurator = configurator;
        this.channelRegistry = channelRegistry;
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        final UnaryOperator<OperationStepHandler> addOperationTransformer = this.configurator.getAddOperationTransformation();
        return (ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)builder.addCapabilities(List.of(this.configurator.getCapability(), CHANNEL, CHANNEL_FACTORY))).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)ResourceServiceConfigurator.combine((ResourceServiceConfigurator[])new ResourceServiceConfigurator[]{this.configurator, this})))).withOperationTransformation("add", (UnaryOperator)new UnaryOperator<OperationStepHandler>(){

            @Override
            public OperationStepHandler apply(final OperationStepHandler handler) {
                return new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        ((OperationStepHandler)addOperationTransformer.apply(handler)).execute(context, operation);
                        if (context.isDefaultRequiresRuntime()) {
                            final Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
                            context.addStep(new OperationStepHandler(){

                                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                                    AbstractChannelResourceDefinitionRegistrar.this.addRuntime(context, resource);
                                }
                            }, OperationContext.Stage.MODEL);
                        }
                    }
                };
            }
        })).withOperationTransformation("remove", (UnaryOperator)new UnaryOperator<OperationStepHandler>(){

            @Override
            public OperationStepHandler apply(final OperationStepHandler handler) {
                return new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
                        handler.execute(context, operation);
                        if (context.isDefaultRequiresRuntime()) {
                            AbstractChannelResourceDefinitionRegistrar.this.removeRuntime(context, resource);
                        }
                    }
                };
            }
        });
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ParentResourceDescriptionResolver resolver = JGroupsSubsystemResourceDefinitionRegistrar.RESOLVER.createChildResolver(this.configurator.getResourceRegistration().getPathElement());
        ResourceDescriptor descriptor = this.apply(ResourceDescriptor.builder((ResourceDescriptionResolver)resolver)).build();
        ManagementResourceRegistration registration = parent.registerSubModel(ResourceDefinition.builder((ResourceRegistration)this.configurator.getResourceRegistration(), (ResourceDescriptionResolver)resolver).build());
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String name = context.getCurrentAddressValue();
        ArrayList<Object> installers = new ArrayList<Object>(4);
        installers.add((ResourceServiceInstaller)CapabilityServiceInstaller.builder(this.configurator.getCapability(), (ServiceDependency)((ServiceDependency)this.configurator.getChannelConfigurationResolver().resolve(context, model))).build());
        final ServiceDependency channelConfiguration = ServiceDependency.on((UnaryServiceDescriptor)ChannelConfiguration.SERVICE_DESCRIPTOR, (String)name);
        ServiceDependency server = new MBeanServerResolver(CHANNEL).resolve(context, model);
        Supplier<JChannel> factory = new Supplier<JChannel>(){

            @Override
            public JChannel get() {
                ChannelConfiguration configuration = (ChannelConfiguration)channelConfiguration.get();
                try {
                    JChannel channel = configuration.getChannelFactory().createChannel(name);
                    if (JGroupsLogger.ROOT_LOGGER.isTraceEnabled()) {
                        JGroupsLogger.ROOT_LOGGER.tracef("JGroups channel %s created with configuration:%n %s", name, channel.getProtocolStack().printProtocolSpec(true));
                    }
                    return channel.stats(configuration.isStatisticsEnabled());
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        };
        final ServiceValueExecutorRegistry<JChannel> registry = this.channelRegistry;
        final ServiceDependency registryKey = ServiceDependency.on((UnaryServiceDescriptor)JGroupsServiceDescriptor.CHANNEL, (String)name);
        Consumer<JChannel> connect = new Consumer<JChannel>(){

            @Override
            public void accept(JChannel disconnectedChannel) {
                TP transport = disconnectedChannel.getProtocolStack().getTransport();
                ChannelConfiguration configuration = (ChannelConfiguration)channelConfiguration.get();
                JGroupsLogger.ROOT_LOGGER.connecting(name, disconnectedChannel.getName(), configuration.getClusterName(), new InetSocketAddress(transport.getBindAddress(), transport.getBindPort()));
                try {
                    registry.add((Object)registryKey).accept(disconnectedChannel.connect(configuration.getClusterName()));
                }
                catch (Exception e) {
                    disconnectedChannel.close();
                    throw new IllegalStateException(e);
                }
                JGroupsLogger.ROOT_LOGGER.connected(name, disconnectedChannel.getName(), configuration.getClusterName(), disconnectedChannel.getView());
            }
        };
        Consumer<JChannel> disconnect = new Consumer<JChannel>(){

            @Override
            public void accept(JChannel connectedChannel) {
                registry.remove((Object)registryKey);
                ChannelConfiguration configuration = (ChannelConfiguration)channelConfiguration.get();
                JGroupsLogger.ROOT_LOGGER.disconnecting(name, connectedChannel.getName(), configuration.getClusterName(), connectedChannel.getView());
                connectedChannel.disconnect();
                JGroupsLogger.ROOT_LOGGER.disconnected(name, connectedChannel.getName(), configuration.getClusterName());
            }
        };
        installers.add((ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(CHANNEL, (Supplier)factory).blocking()).requires(List.of(channelConfiguration, server))).onStart(new MBeanRegistrationTask((Supplier<MBeanServer>)server, JmxConfigurator::registerChannel, name).andThen(connect))).onStop(disconnect.andThen(new MBeanRegistrationTask((Supplier<MBeanServer>)server, JmxConfigurator::unregisterChannel, name)).andThen(Functions.closingConsumer()))).build());
        installers.add(new BinderServiceInstaller(JGroupsBindingFactory.CHANNEL.apply(name), context.getCapabilityServiceName(JGroupsServiceDescriptor.CHANNEL, name)));
        installers.add(new BinderServiceInstaller(JGroupsBindingFactory.CHANNEL_FACTORY.apply(name), context.getCapabilityServiceName(org.wildfly.clustering.jgroups.spi.ForkChannelFactory.SERVICE_DESCRIPTOR, name)));
        return ResourceServiceInstaller.combine(installers);
    }

    public void addRuntime(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        PathAddress stackAddress = (PathAddress)this.configurator.getStackAddressResolver().resolve(context, resource);
        Resource stackResource = address.equals(stackAddress) ? resource : context.readResourceFromRoot(stackAddress);
        List<PathElement> protocolTypes = List.of(StackResourceDefinitionRegistrar.Component.TRANSPORT.getPathElement(), StackResourceDefinitionRegistrar.Component.PROTOCOL.getPathElement(), StackResourceDefinitionRegistrar.Component.RELAY.getPathElement());
        if (protocolTypes.stream().anyMatch(protocolType -> stackResource.hasChildren(protocolType.getKey()))) {
            ManagementResourceRegistration registration = context.getResourceRegistrationForUpdate();
            if (resource != stackResource) {
                OverrideDescriptionProvider provider = new OverrideDescriptionProvider(){

                    public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
                        return Collections.emptyMap();
                    }

                    public Map<String, ModelNode> getChildTypeOverrideDescriptions(Locale locale) {
                        String description = JGroupsSubsystemResourceDefinitionRegistrar.RESOLVER.getChildTypeDescription(StackResourceDefinitionRegistrar.Component.PROTOCOL.getPathElement().getKey(), locale, JGroupsSubsystemResourceDefinitionRegistrar.RESOLVER.getResourceBundle(locale));
                        ModelNode result = new ModelNode();
                        result.get("description").set(description);
                        return Collections.singletonMap(StackResourceDefinitionRegistrar.Component.PROTOCOL.getPathElement().getKey(), result);
                    }
                };
                registration = registration.registerOverrideModel(context.getCurrentAddressValue(), provider);
            }
            for (PathElement path : protocolTypes) {
                for (Resource.ResourceEntry protocolResource : stackResource.getChildren(path.getKey())) {
                    String protocolName = protocolResource.getName();
                    Class<Protocol> protocolClass = AbstractChannelResourceDefinitionRegistrar.findProtocolClass(context, protocolName, protocolResource.getModel());
                    this.register(registration, protocolName, protocolClass);
                    resource.registerChild(StackResourceDefinitionRegistrar.Component.PROTOCOL.pathElement(protocolName), (Resource)PlaceholderResource.INSTANCE);
                }
            }
        }
    }

    public void removeRuntime(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress stackAddress = (PathAddress)this.configurator.getStackAddressResolver().resolve(context, model);
        ManagementResourceRegistration registration = context.getResourceRegistrationForUpdate();
        if (address.equals(stackAddress)) {
            for (PathElement protocolPath : registration.getChildAddresses(stackAddress)) {
                ManagementResourceRegistration protocolRegistration = registration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{protocolPath}));
                for (Map.Entry entry : protocolRegistration.getAttributes(PathAddress.EMPTY_ADDRESS).entrySet()) {
                    if (((AttributeAccess)entry.getValue()).getStorageType() != AttributeAccess.Storage.RUNTIME) continue;
                    protocolRegistration.unregisterAttribute((String)entry.getKey());
                }
            }
        } else {
            context.getResourceRegistrationForUpdate().unregisterOverrideModel(context.getCurrentAddressValue());
        }
    }

    private ManagementResourceRegistration register(ManagementResourceRegistration parent, String protocolName, Class<? extends Protocol> protocolClass) {
        final Map<String, ProtocolMetricsHandler.Attribute> attributes = ProtocolMetricsHandler.findProtocolAttributes(protocolClass);
        PathElement path = StackResourceDefinitionRegistrar.Component.PROTOCOL.pathElement(protocolName);
        ManagementResourceRegistration registration = parent.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{path}));
        if (registration == null) {
            SimpleResourceDescriptionResolver resolver = new SimpleResourceDescriptionResolver(protocolName, protocolClass.getSimpleName());
            for (Map.Entry<String, ProtocolMetricsHandler.Attribute> entry : attributes.entrySet()) {
                resolver.addDescription(entry.getKey(), entry.getValue().getDescription());
            }
            ResourceDefinition definition = ((ResourceDefinition.Builder)ResourceDefinition.builder((ResourceRegistration)ResourceRegistration.of((PathElement)path), (ResourceDescriptionResolver)resolver).asRuntime()).build();
            registration = parent.registerSubModel(definition);
        } else if (registration.getPathAddress().getLastElement().isWildcard()) {
            OverrideDescriptionProvider provider = new OverrideDescriptionProvider(){

                public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
                    HashMap<String, ModelNode> result = new HashMap<String, ModelNode>();
                    for (ProtocolMetricsHandler.Attribute attribute : attributes.values()) {
                        ModelNode value = new ModelNode();
                        value.get("description").set(attribute.getDescription());
                        result.put(attribute.getName(), value);
                    }
                    return result;
                }

                public Map<String, ModelNode> getChildTypeOverrideDescriptions(Locale locale) {
                    return Map.of();
                }
            };
            registration = registration.registerOverrideModel(protocolName, provider);
        }
        ProtocolMetricsHandler handler = new ProtocolMetricsHandler((FunctionExecutorRegistry<JChannel>)this.channelRegistry);
        for (Map.Entry<String, ProtocolMetricsHandler.Attribute> entry : attributes.entrySet()) {
            String name = entry.getKey();
            ProtocolMetricsHandler.Attribute attribute = entry.getValue();
            ProtocolMetricsHandler.FieldType type = ProtocolMetricsHandler.FieldType.valueOf(attribute.getType());
            registration.registerReadOnlyAttribute((AttributeDefinition)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type.getModelType(), true).setStorageRuntime()).build(), (OperationStepHandler)handler);
        }
        return registration;
    }

    static Class<? extends Protocol> findProtocolClass(OperationContext context, String protocolName, ModelNode protocolModel) throws OperationFailedException {
        ModuleClassLoader classLoader;
        String moduleName = ProtocolChildResourceDefinitionRegistrar.MODULE.resolveModelAttribute(context, protocolModel).asString();
        boolean isDefaultModule = moduleName.equals(ProtocolChildResourceDefinitionRegistrar.MODULE.getDefaultValue().asString());
        try {
            classLoader = Module.getContextModuleLoader().loadModule(moduleName).getClassLoader();
        }
        catch (ModuleLoadException e) {
            throw JGroupsLogger.ROOT_LOGGER.unableToLoadProtocolModule(moduleName, protocolName);
        }
        ArrayList<Object> candidateClassNames = new ArrayList<Object>(2);
        if (protocolName.startsWith("org.jgroups.protocols.")) {
            candidateClassNames.add(protocolName);
        } else {
            if (!isDefaultModule) {
                candidateClassNames.add(protocolName);
            }
            candidateClassNames.add("org.jgroups.protocols." + protocolName);
        }
        Iterator classNames = candidateClassNames.iterator();
        while (classNames.hasNext()) {
            try {
                return classLoader.loadClass((String)classNames.next()).asSubclass(Protocol.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw JGroupsLogger.ROOT_LOGGER.unableToLoadProtocolClass(protocolName);
    }

    static interface Configurator<C>
    extends ResourceServiceConfigurator {
        public ResourceRegistration getResourceRegistration();

        public RuntimeCapability<Void> getCapability();

        public ResourceModelResolver<ServiceDependency<ForkChannelFactoryConfiguration>> getForkChannelFactoryConfigurationResolver();

        public ResourceModelResolver<ServiceDependency<C>> getChannelConfigurationResolver();

        public ResourceModelResolver<PathAddress> getStackAddressResolver();

        default public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
            final String name = context.getCurrentAddressValue();
            ServiceDependency configuration = (ServiceDependency)this.getForkChannelFactoryConfigurationResolver().resolve(context, model);
            Consumer<ForkChannelFactoryConfiguration> stop = new Consumer<ForkChannelFactoryConfiguration>(){

                @Override
                public void accept(ForkChannelFactoryConfiguration configuration) {
                    ProtocolStack stack = configuration.getChannel().getProtocolStack();
                    FORK fork = (FORK)stack.findProtocol(FORK.class);
                    fork.remove(name);
                }
            };
            return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(CHANNEL_FACTORY, ForkChannelFactory::new, (Supplier)configuration).requires(List.of(configuration))).blocking()).onStop((Consumer)stop)).startWhen(Installer.StartWhen.AVAILABLE)).build();
        }

        default public UnaryOperator<OperationStepHandler> getAddOperationTransformation() {
            return UnaryOperator.identity();
        }
    }

    private static class MBeanRegistrationTask
    implements Consumer<JChannel> {
        private final Supplier<MBeanServer> server;
        private final MBeanRegistration registration;
        private final String name;

        MBeanRegistrationTask(Supplier<MBeanServer> server, MBeanRegistration registration, String name) {
            this.server = server;
            this.registration = registration;
            this.name = name;
        }

        @Override
        public void accept(JChannel channel) {
            MBeanServer server = this.server.get();
            if (server != null) {
                try {
                    this.registration.accept(channel, server, this.name);
                }
                catch (Exception e) {
                    JGroupsLogger.ROOT_LOGGER.debug(e.getLocalizedMessage(), e);
                }
            }
        }
    }

    private static interface MBeanRegistration {
        public void accept(JChannel var1, MBeanServer var2, String var3) throws Exception;
    }
}

