/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolConfigurationResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.SocketProtocolResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.SocketProtocolResourceRegistration;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jgroups.protocols.FD_SOCK;
import org.wildfly.clustering.jgroups.spi.ChannelFactoryConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ServiceDependency;

public class LegacyFailureDetectionProtocolResourceDefinitionRegistrar
extends SocketProtocolResourceDefinitionRegistrar<FD_SOCK> {
    public LegacyFailureDetectionProtocolResourceDefinitionRegistrar(final SocketProtocolResourceRegistration registration, final ResourceOperationRuntimeHandler parentRuntimeHandler) {
        super(new AbstractProtocolResourceDefinitionRegistrar.Configurator(){

            @Override
            public ResourceRegistration getResourceRegistration() {
                return registration;
            }

            @Override
            public ResourceOperationRuntimeHandler getParentRuntimeHandler() {
                return parentRuntimeHandler;
            }
        });
    }

    @Override
    public ServiceDependency<ProtocolConfiguration<FD_SOCK>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final ServiceDependency protocol = super.resolve(context, model);
        final ServiceDependency<SocketBinding> serverBinding = SocketProtocolResourceDefinitionRegistrar.SocketBindingAttribute.SERVER.resolve(context, model);
        final ServiceDependency<SocketBinding> clientBinding = SocketProtocolResourceDefinitionRegistrar.SocketBindingAttribute.CLIENT.resolve(context, model);
        return new ServiceDependency<ProtocolConfiguration<FD_SOCK>>(){

            public void accept(RequirementServiceBuilder<?> builder) {
                protocol.accept(builder);
                serverBinding.accept(builder);
                clientBinding.accept(builder);
            }

            public ProtocolConfiguration<FD_SOCK> get() {
                return new ProtocolConfigurationResourceDefinitionRegistrar.ProtocolConfigurationDecorator<FD_SOCK>((ProtocolConfiguration)protocol.get()){

                    @Override
                    public FD_SOCK createProtocol(ChannelFactoryConfiguration stackConfiguration) {
                        SocketBinding clientSocketBinding;
                        FD_SOCK protocol = (FD_SOCK)super.createProtocol(stackConfiguration);
                        SocketBinding serverSocketBinding = (SocketBinding)serverBinding.get();
                        protocol.setStartPort(serverSocketBinding != null ? serverSocketBinding.getAbsolutePort() : 0);
                        if (serverSocketBinding != null) {
                            protocol.setBindAddress(serverSocketBinding.getAddress());
                            List clientMappings = serverSocketBinding.getClientMappings();
                            if (!clientMappings.isEmpty()) {
                                ClientMapping mapping = (ClientMapping)clientMappings.get(0);
                                try {
                                    protocol.setExternalAddress(InetAddress.getByName(mapping.getDestinationAddress()));
                                    protocol.setExternalPort(mapping.getDestinationPort());
                                }
                                catch (UnknownHostException e) {
                                    throw new IllegalArgumentException(e);
                                }
                            }
                        }
                        if ((clientSocketBinding = (SocketBinding)clientBinding.get()) != null) {
                            protocol.setClientBindPort(clientSocketBinding.getSocketAddress().getPort());
                        }
                        return protocol;
                    }

                    @Override
                    public Map<String, SocketBinding> getSocketBindings() {
                        SocketBinding clientSocketBinding;
                        TreeMap<String, SocketBinding> result = new TreeMap<String, SocketBinding>();
                        SocketBinding serverSocketBinding = (SocketBinding)serverBinding.get();
                        if (serverSocketBinding != null) {
                            result.put("jgroups.fd_sock.srv_sock", serverSocketBinding);
                        }
                        if ((clientSocketBinding = (SocketBinding)clientBinding.get()) != null) {
                            result.put("jgroups.fd.ping_sock", clientSocketBinding);
                        }
                        return result;
                    }
                };
            }
        };
    }
}

