/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.SimpleResourceDescriptorConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jgroups.protocols.BasicTCP;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder;
import org.wildfly.subsystem.service.ServiceDependency;

public class SocketTransportResourceDefinition<T extends BasicTCP>
extends TransportResourceDefinition<T> {
    SocketTransportResourceDefinition(String name) {
        super(SocketTransportResourceDefinition.pathElement(name), (UnaryOperator<ResourceDescriptor>)new SimpleResourceDescriptorConfigurator(Attribute.class));
    }

    @Override
    public Map.Entry<Function<ProtocolConfiguration<T>, TransportConfiguration<T>>, Consumer<RequirementServiceBuilder<?>>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        String bindingName = Attribute.CLIENT_SOCKET_BINDING.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        final ServiceDependency binding = bindingName != null ? ServiceDependency.on((UnaryServiceDescriptor)SocketBinding.SERVICE_DESCRIPTOR, (String)bindingName) : ServiceDependency.of(null);
        Object entry = super.resolve(context, model);
        return Map.entry(((Function)entry.getKey()).andThen(new UnaryOperator<TransportConfiguration<T>>(){

            @Override
            public TransportConfiguration<T> apply(TransportConfiguration<T> configuration) {
                return new TransportResourceDefinition.TransportConfigurationDecorator<T>(configuration){

                    @Override
                    public T createProtocol(ProtocolStackConfiguration stackConfiguration) {
                        BasicTCP transport = (BasicTCP)super.createProtocol(stackConfiguration);
                        SocketBinding clientBinding = (SocketBinding)binding.get();
                        if (clientBinding != null) {
                            InetSocketAddress socketAddress = clientBinding.getSocketAddress();
                            this.setValue(transport, "client_bind_addr", socketAddress.getAddress());
                            this.setValue(transport, "client_bind_port", socketAddress.getPort());
                        }
                        return transport;
                    }

                    @Override
                    public Map<String, SocketBinding> getSocketBindings() {
                        TreeMap<String, SocketBinding> bindings = new TreeMap<String, SocketBinding>();
                        SocketBinding clientBinding = (SocketBinding)binding.get();
                        for (String serviceName : Set.of("jgroups.tcp.sock", "jgroups.nio.client")) {
                            bindings.put(serviceName, clientBinding);
                        }
                        return bindings;
                    }
                };
            }
        }), ((Consumer)entry.getValue()).andThen(binding));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        CLIENT_SOCKET_BINDING("client-socket-binding", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF})).setCapabilityReference((org.jboss.as.controller.CapabilityReferenceRecorder)CapabilityReferenceRecorder.builder(TransportResourceDefinition.CAPABILITY, (UnaryServiceDescriptor)SocketBinding.SERVICE_DESCRIPTOR).build());
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(false)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }
}

