/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi.service;

import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.infinispan.spi.service.CacheContainerServiceName;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceName;
import org.wildfly.clustering.infinispan.spi.service.ConfigurationFactory;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.clustering.service.Builder;

public class ConfigurationBuilder
implements Builder<Configuration>,
Service<Configuration> {
    private final InjectedValue<EmbeddedCacheManager> container = new InjectedValue();
    private final String containerName;
    private final String cacheName;
    private final ConfigurationFactory factory;

    public ConfigurationBuilder(String containerName, String cacheName, ConfigurationFactory factory) {
        this.containerName = containerName;
        this.cacheName = cacheName;
        this.factory = factory;
    }

    public ServiceName getServiceName() {
        return CacheServiceName.CONFIGURATION.getServiceName(this.containerName, this.cacheName);
    }

    public ServiceBuilder<Configuration> build(ServiceTarget target) {
        return new AsynchronousServiceBuilder(this.getServiceName(), (Service)this).build(target).addDependency(CacheContainerServiceName.CACHE_CONTAINER.getServiceName(this.containerName), EmbeddedCacheManager.class, this.container).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public Configuration getValue() {
        return ((EmbeddedCacheManager)this.container.getValue()).getCacheConfiguration(this.cacheName);
    }

    public void start(StartContext context) throws StartException {
        ((EmbeddedCacheManager)this.container.getValue()).defineConfiguration(this.cacheName, this.factory.createConfiguration());
    }

    public void stop(StopContext context) {
    }
}

