/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi.service;

import org.infinispan.configuration.cache.Configuration;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceName;
import org.wildfly.clustering.infinispan.spi.service.ConfigurationBuilder;
import org.wildfly.clustering.infinispan.spi.service.ConfigurationFactory;
import org.wildfly.clustering.service.Builder;

public class TemplateConfigurationBuilder
implements Builder<Configuration>,
ConfigurationFactory {
    private final InjectedValue<Configuration> template = new InjectedValue();
    private final Builder<Configuration> builder;
    private final String containerName;
    private final String templateCacheName;

    public TemplateConfigurationBuilder(String containerName, String cacheName, String templateCacheName) {
        this.builder = new ConfigurationBuilder(containerName, cacheName, this);
        this.containerName = containerName;
        this.templateCacheName = templateCacheName;
    }

    public ServiceName getServiceName() {
        return this.builder.getServiceName();
    }

    public ServiceBuilder<Configuration> build(ServiceTarget target) {
        return this.builder.build(target).addDependency(CacheServiceName.CONFIGURATION.getServiceName(this.containerName, this.templateCacheName), Configuration.class, this.template);
    }

    @Override
    public Configuration createConfiguration() {
        return new org.infinispan.configuration.cache.ConfigurationBuilder().read((Configuration)this.template.getValue()).build();
    }
}

