/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jboss.as.clustering.infinispan.subsystem.ComponentResourceRegistration;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.wildfly.clustering.function.Function;
import org.wildfly.subsystem.resource.ChildResourceProvider;
import org.wildfly.subsystem.resource.DynamicResource;

public class CacheRuntimeResourceProvider
implements ChildResourceProvider {
    private static final Map<String, Resource> COMPONENTS = EnumSet.of(ComponentResourceRegistration.LOCKING, ComponentResourceRegistration.PARTITION_HANDLING, ComponentResourceRegistration.PERSISTENCE, ComponentResourceRegistration.TRANSACTION).stream().map(ResourceRegistration::getPathElement).collect(Collectors.toMap(PathElement::getValue, Function.of((Object)PlaceholderResource.INSTANCE)));
    private static final ChildResourceProvider COMPONENT_PROVIDER = new ChildResourceProvider(){

        public Resource getChild(String name) {
            return COMPONENTS.get(name);
        }

        public Set<String> getChildren() {
            return COMPONENTS.keySet();
        }
    };
    private static final Resource COMPONENT_RESOURCE = new DynamicResource((Resource)PlaceholderResource.INSTANCE, Map.of(ComponentResourceRegistration.WILDCARD.getPathElement().getKey(), COMPONENT_PROVIDER));
    private final Set<String> children = ConcurrentHashMap.newKeySet();

    public Resource getChild(String name) {
        return this.children.contains(name) ? COMPONENT_RESOURCE : null;
    }

    public Set<String> getChildren() {
        return this.children;
    }
}

