/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.sql.DataSource;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.jboss.as.clustering.controller.CommonServiceDescriptor;
import org.jboss.as.clustering.controller.EnumAttributeDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceRegistration;
import org.jboss.as.clustering.infinispan.subsystem.TableResourceDefinitionRegistrar;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.cache.infinispan.persistence.jdbc.DataSourceConnectionFactoryConfigurationBuilder;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceAttributeDefinition;
import org.wildfly.subsystem.service.ServiceDependency;

public class JDBCStoreResourceDefinitionRegistrar
extends StoreResourceDefinitionRegistrar<JdbcStringBasedStoreConfiguration, JdbcStringBasedStoreConfigurationBuilder> {
    static final CapabilityReferenceAttributeDefinition<DataSource> DATA_SOURCE = ((CapabilityReferenceAttributeDefinition.Builder)new CapabilityReferenceAttributeDefinition.Builder("data-source", CapabilityReference.builder((RuntimeCapability)CAPABILITY, (UnaryServiceDescriptor)CommonServiceDescriptor.DATA_SOURCE).build()).setRequired(true)).build();
    static final EnumAttributeDefinition<DatabaseType> DIALECT = ((EnumAttributeDefinition.Builder)new EnumAttributeDefinition.Builder("dialect", DatabaseType.class).setRequired(false)).build();

    JDBCStoreResourceDefinitionRegistrar() {
        super(new StoreResourceDefinitionRegistrar.Configurator<JdbcStringBasedStoreConfiguration, JdbcStringBasedStoreConfigurationBuilder>(){

            @Override
            public ResourceRegistration getResourceRegistration() {
                return StoreResourceRegistration.JDBC;
            }

            public ServiceDependency<JdbcStringBasedStoreConfigurationBuilder> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
                PathAddress cacheAddress = context.getCurrentAddress().getParent();
                PathAddress containerAddress = cacheAddress.getParent();
                BinaryServiceConfiguration configuration = BinaryServiceConfiguration.of((String)containerAddress.getLastElement().getValue(), (String)cacheAddress.getLastElement().getValue());
                final ServiceDependency loader = configuration.getServiceDependency(CacheResourceDefinitionRegistrar.CLASS_LOADER);
                final ServiceDependency dataSource = DATA_SOURCE.resolve(context, model);
                final ServiceDependency table = configuration.getServiceDependency(TableResourceDefinitionRegistrar.SERVICE_DESCRIPTOR);
                final DatabaseType dialect = (DatabaseType)DIALECT.resolve(context, model);
                return new ServiceDependency<JdbcStringBasedStoreConfigurationBuilder>(){

                    public void accept(RequirementServiceBuilder<?> builder) {
                        loader.accept(builder);
                        dataSource.accept(builder);
                        table.accept(builder);
                    }

                    public JdbcStringBasedStoreConfigurationBuilder get() {
                        JdbcStringBasedStoreConfigurationBuilder builder = (JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).dialect(dialect);
                        ((DataSourceConnectionFactoryConfigurationBuilder)builder.connectionFactory(DataSourceConnectionFactoryConfigurationBuilder.class)).setDataSource((DataSource)dataSource.get());
                        builder.table().read((Object)((TableManipulationConfiguration)table.get()));
                        ServiceLoader.load(TwoWayKey2StringMapper.class, (ClassLoader)loader.get()).findFirst().map(Object::getClass).ifPresent(arg_0 -> ((JdbcStringBasedStoreConfigurationBuilder)builder).key2StringMapper(arg_0));
                        return builder;
                    }
                };
            }
        });
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)((ResourceDescriptor.Builder)super.apply(builder).addAttributes(List.of(DATA_SOURCE, DIALECT))).requireChildResources(Set.of(TableResourceDefinitionRegistrar.REGISTRATION));
    }

    @Override
    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ManagementResourceRegistration registration = super.register(parent, context);
        new TableResourceDefinitionRegistrar().register(registration, context);
        return registration;
    }
}

