/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.as.clustering.infinispan.deployment.ClusteringDependencyProcessor;
import org.jboss.as.clustering.infinispan.logging.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerResourceDefinitionRegistrar;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.SubsystemResourceRegistration;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.RuntimePackageDependency;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.clustering.server.service.DefaultChannelServiceInstallerProvider;
import org.wildfly.clustering.server.service.LocalServiceInstallerProvider;
import org.wildfly.clustering.server.service.ProvidedUnaryServiceInstallerProvider;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.SubsystemResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;

public class InfinispanSubsystemResourceDefinitionRegistrar
implements SubsystemResourceDefinitionRegistrar,
Consumer<DeploymentProcessorTarget>,
ResourceServiceConfigurator {
    static final SubsystemResourceRegistration REGISTRATION = SubsystemResourceRegistration.of((String)"infinispan");
    public static final ParentResourceDescriptionResolver RESOLVER = new SubsystemResourceDescriptionResolver(REGISTRATION.getName(), InfinispanSubsystemResourceDefinitionRegistrar.class);
    static final String CLUSTERING_EXTENSION_MODULE = "org.wildfly.extension.clustering.server";

    public ManagementResourceRegistration register(SubsystemRegistration parent, ManagementResourceRegistrationContext context) {
        RuntimeCapability defaultCommandDispatcherFactory = RuntimeCapability.Builder.of((NullaryServiceDescriptor)ClusteringServiceDescriptor.DEFAULT_COMMAND_DISPATCHER_FACTORY).setAllowMultipleRegistrations(true).build();
        RuntimeCapability defaultGroup = RuntimeCapability.Builder.of((NullaryServiceDescriptor)ClusteringServiceDescriptor.DEFAULT_GROUP).setAllowMultipleRegistrations(true).build();
        RuntimeCapability localCommandDispatcherFactory = RuntimeCapability.Builder.of((UnaryServiceDescriptor)ClusteringServiceDescriptor.COMMAND_DISPATCHER_FACTORY).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.LOCAL).build();
        RuntimeCapability localGroup = RuntimeCapability.Builder.of((UnaryServiceDescriptor)ClusteringServiceDescriptor.GROUP).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.LOCAL).build();
        ResourceDescriptor descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)RESOLVER).addCapabilities(List.of(defaultCommandDispatcherFactory, defaultGroup, localCommandDispatcherFactory, localGroup))).withDeploymentChainContributor((Consumer)this)).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this))).build();
        ManagementResourceRegistration registration = parent.registerSubsystemModel(ResourceDefinition.builder((ResourceRegistration)REGISTRATION, (ResourceDescriptionResolver)RESOLVER).build());
        registration.registerAdditionalRuntimePackages(new RuntimePackageDependency[]{RuntimePackageDependency.required((String)CLUSTERING_EXTENSION_MODULE)});
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        new CacheContainerResourceDefinitionRegistrar().register(registration, context);
        new RemoteCacheContainerResourceDefinitionRegistrar().register(registration, context);
        return registration;
    }

    @Override
    public void accept(DeploymentProcessorTarget target) {
        target.addDeploymentProcessor(REGISTRATION.getName(), Phase.DEPENDENCIES, 7168, (DeploymentUnitProcessor)new ClusteringDependencyProcessor());
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        InfinispanLogger.ROOT_LOGGER.activatingSubsystem();
        LinkedList installers = new LinkedList();
        new ProvidedUnaryServiceInstallerProvider(LocalServiceInstallerProvider.class, LocalServiceInstallerProvider.class.getClassLoader()).apply("local").forEach(installers::add);
        if (!context.getCapabilityServiceSupport().hasCapability(ChannelFactory.DEFAULT_SERVICE_DESCRIPTOR)) {
            new ProvidedUnaryServiceInstallerProvider(DefaultChannelServiceInstallerProvider.class, DefaultChannelServiceInstallerProvider.class.getClassLoader()).apply("local").forEach(installers::add);
        }
        return ResourceServiceInstaller.combine(installers);
    }
}

