/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.auth.callback.ChannelBindingCallback;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;

public final class ChannelBindingSaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    private final String bindingType;
    private final byte[] bindingData;

    public ChannelBindingSaslServerFactory(SaslServerFactory delegate, String bindingType, byte[] bindingData) {
        super(delegate);
        this.bindingType = bindingType;
        this.bindingData = bindingData;
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        return this.delegate.createSaslServer(mechanism, protocol, serverName, props, callbacks -> {
            ArrayList<Callback> list = new ArrayList<Callback>(Arrays.asList(callbacks));
            for (Callback callback : list) {
                if (!(callback instanceof ChannelBindingCallback)) continue;
                ((ChannelBindingCallback)callback).setBindingType(this.bindingType);
                ((ChannelBindingCallback)callback).setBindingData(this.bindingData);
            }
            if (!list.isEmpty()) {
                cbh.handle(list.toArray(new Callback[list.size()]));
            }
        });
    }
}

