/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util.sso;

import java.security.Principal;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.security.auth.callback.CachedIdentityAuthorizeCallback;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.cache.IdentityCache;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.HttpServerCookie;
import org.wildfly.security.http.HttpServerMechanismsResponder;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.HttpServerRequestWrapper;
import org.wildfly.security.http.HttpServerResponse;
import org.wildfly.security.http.util.SimpleHttpServerCookie;
import org.wildfly.security.http.util.sso.ElytronMessages;
import org.wildfly.security.http.util.sso.SingleSignOnSession;
import org.wildfly.security.http.util.sso.SingleSignOnSessionFactory;

public class SingleSignOnServerMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    private final HttpServerAuthenticationMechanismFactory delegate;
    private final org.wildfly.security.http.util.sso.SingleSignOnConfiguration configuration;
    private final SingleSignOnSessionFactory singleSignOnSessionFactory;

    public SingleSignOnServerMechanismFactory(HttpServerAuthenticationMechanismFactory delegate, SingleSignOnSessionFactory singleSignOnSessionFactory, org.wildfly.security.http.util.sso.SingleSignOnConfiguration configuration) {
        this.delegate = delegate;
        this.configuration = configuration;
        this.singleSignOnSessionFactory = singleSignOnSessionFactory;
    }

    @Deprecated
    public SingleSignOnServerMechanismFactory(HttpServerAuthenticationMechanismFactory delegate, SingleSignOnSessionFactory singleSignOnSessionFactory, SingleSignOnConfiguration configuration) {
        this(delegate, singleSignOnSessionFactory, configuration.convert());
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> properties) {
        return this.delegate.getMechanismNames(properties);
    }

    @Override
    public HttpServerAuthenticationMechanism createAuthenticationMechanism(final String mechanismName, final Map<String, ?> properties, final CallbackHandler callbackHandler) throws HttpAuthenticationException {
        return new HttpServerAuthenticationMechanism(){
            private volatile SingleSignOnSession singleSignOnSession;
            private volatile HttpServerAuthenticationMechanism targetMechanism;

            @Override
            public String getMechanismName() {
                return mechanismName;
            }

            @Override
            public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
                this.singleSignOnSession = this.getSingleSignOnSession(request);
                if (this.singleSignOnSession.logout()) {
                    this.singleSignOnSession.close();
                    return;
                }
                this.targetMechanism = this.getTargetMechanism(mechanismName, this.singleSignOnSession);
                if (this.targetMechanism == null) {
                    throw ElytronMessages.log.httpServerAuthenticationMechanismNotFound(mechanismName);
                }
                this.targetMechanism.evaluateRequest(this.createHttpServerRequest(request, this.singleSignOnSession));
            }

            @Override
            public void dispose() {
                if (this.targetMechanism != null) {
                    this.targetMechanism.dispose();
                }
                if (this.singleSignOnSession != null) {
                    this.singleSignOnSession.close();
                }
            }

            private SingleSignOnSession getSingleSignOnSession(HttpServerRequest request) {
                HttpServerCookie cookie = this.getCookie(request);
                String signOnSessionId = cookie != null ? cookie.getValue() : null;
                SingleSignOnSession singleSignOnSession = signOnSessionId != null ? SingleSignOnServerMechanismFactory.this.singleSignOnSessionFactory.find(signOnSessionId, request) : null;
                return singleSignOnSession == null ? SingleSignOnServerMechanismFactory.this.singleSignOnSessionFactory.create(request, mechanismName, false) : singleSignOnSession;
            }

            private HttpServerAuthenticationMechanism getTargetMechanism(String mechanismName2, SingleSignOnSession singleSignOnSession) throws HttpAuthenticationException {
                return SingleSignOnServerMechanismFactory.this.delegate.createAuthenticationMechanism(mechanismName2, properties, SingleSignOnServerMechanismFactory.this.createCallbackHandler(callbackHandler, mechanismName2, singleSignOnSession));
            }

            private HttpServerRequest createHttpServerRequest(final HttpServerRequest request, final SingleSignOnSession singleSignOnSession) {
                HttpServerRequestWrapper httpServerRequest = new HttpServerRequestWrapper(request){

                    @Override
                    public void noAuthenticationInProgress(HttpServerMechanismsResponder responder) {
                        request.noAuthenticationInProgress(response -> {
                            try {
                                this.clearCookie(request, response, singleSignOnSession);
                                if (responder != null) {
                                    responder.sendResponse(response);
                                }
                            }
                            finally {
                                singleSignOnSession.close();
                            }
                        });
                    }

                    @Override
                    public void authenticationInProgress(HttpServerMechanismsResponder responder) {
                        request.authenticationInProgress(response -> {
                            try {
                                this.clearCookie(request, response, singleSignOnSession);
                                if (responder != null) {
                                    responder.sendResponse(response);
                                }
                            }
                            finally {
                                singleSignOnSession.close();
                            }
                        });
                    }

                    @Override
                    public void authenticationComplete(HttpServerMechanismsResponder responder) {
                        request.authenticationComplete(response -> {
                            try {
                                HttpServerCookie cookie;
                                String id = singleSignOnSession.getId();
                                if (!(id == null || (cookie = this.getCookie(request)) != null && id.equals(cookie.getValue()))) {
                                    response.setResponseCookie(this.createCookie(id, -1));
                                }
                                if (responder != null) {
                                    responder.sendResponse(response);
                                }
                            }
                            finally {
                                singleSignOnSession.close();
                            }
                        });
                    }

                    @Override
                    public void authenticationComplete(HttpServerMechanismsResponder responder, Runnable logoutHandler) {
                        request.authenticationComplete(response -> {
                            try {
                                HttpServerCookie cookie;
                                String id = singleSignOnSession.getId();
                                if (!(id == null || (cookie = this.getCookie(request)) != null && id.equals(cookie.getValue()))) {
                                    response.setResponseCookie(this.createCookie(id, -1));
                                }
                                if (responder != null) {
                                    responder.sendResponse(response);
                                }
                            }
                            finally {
                                singleSignOnSession.close();
                            }
                        }, logoutHandler);
                    }

                    @Override
                    public void authenticationFailed(String message, HttpServerMechanismsResponder responder) {
                        request.authenticationFailed(message, response -> {
                            try {
                                this.clearCookie(request, response, singleSignOnSession);
                                if (responder != null) {
                                    responder.sendResponse(response);
                                }
                            }
                            finally {
                                singleSignOnSession.close();
                            }
                        });
                    }

                    @Override
                    public void badRequest(HttpAuthenticationException failure, HttpServerMechanismsResponder responder) {
                        try {
                            request.badRequest(failure, responder);
                        }
                        finally {
                            singleSignOnSession.close();
                        }
                    }
                };
                return httpServerRequest;
            }

            private void clearCookie(HttpServerRequest request, HttpServerResponse response, IdentityCache identityCache) {
                identityCache.remove();
                if (this.getCookie(request) != null) {
                    response.setResponseCookie(this.createCookie(null, 0));
                }
            }

            HttpServerCookie getCookie(HttpServerRequest request) {
                String expectedCookieName = SingleSignOnServerMechanismFactory.this.configuration.getCookieName();
                for (HttpServerCookie currentCookie : request.getCookies()) {
                    if (!expectedCookieName.equals(currentCookie.getName())) continue;
                    return currentCookie;
                }
                return null;
            }

            HttpServerCookie createCookie(String value, int maxAge) {
                return SimpleHttpServerCookie.newInstance(SingleSignOnServerMechanismFactory.this.configuration.getCookieName(), value, SingleSignOnServerMechanismFactory.this.configuration.getDomain(), maxAge, SingleSignOnServerMechanismFactory.this.configuration.getPath(), SingleSignOnServerMechanismFactory.this.configuration.isSecure(), 0, SingleSignOnServerMechanismFactory.this.configuration.isHttpOnly());
            }
        };
    }

    private CallbackHandler createCallbackHandler(CallbackHandler callbackHandler, String mechanismName, SingleSignOnSession singleSignOnSession) {
        return callbacks -> {
            CachedIdentity cachedIdentity = singleSignOnSession.get();
            if (cachedIdentity == null || mechanismName.equals(cachedIdentity.getMechanismName())) {
                for (int i = 0; i < callbacks.length; ++i) {
                    CachedIdentityAuthorizeCallback delegate;
                    Callback current = callbacks[i];
                    if (!(current instanceof CachedIdentityAuthorizeCallback) || (delegate = (CachedIdentityAuthorizeCallback)current).isLocalCache()) continue;
                    Principal principal = delegate.getAuthorizationPrincipal();
                    callbacks[i] = principal != null ? new CachedIdentityAuthorizeCallback(principal, singleSignOnSession){

                        @Override
                        public void setAuthorized(SecurityIdentity securityIdentity) {
                            delegate.setAuthorized(securityIdentity);
                            super.setAuthorized(securityIdentity);
                        }
                    } : new CachedIdentityAuthorizeCallback(singleSignOnSession, delegate.isLocalCache()){

                        @Override
                        public void setAuthorized(SecurityIdentity securityIdentity) {
                            delegate.setAuthorized(securityIdentity);
                            super.setAuthorized(securityIdentity);
                        }
                    };
                }
            }
            callbackHandler.handle(callbacks);
        };
    }

    @Deprecated
    public static final class SingleSignOnConfiguration {
        private final String cookieName;
        private final String domain;
        private final String path;
        private final boolean httpOnly;
        private final boolean secure;

        public SingleSignOnConfiguration(String cookieName, String domain, String path, boolean httpOnly, boolean secure) {
            this.cookieName = cookieName;
            this.domain = domain;
            this.path = path;
            this.httpOnly = httpOnly;
            this.secure = secure;
        }

        public String getCookieName() {
            return this.cookieName;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getPath() {
            return this.path;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public boolean isHttpOnly() {
            return this.httpOnly;
        }

        org.wildfly.security.http.util.sso.SingleSignOnConfiguration convert() {
            return new org.wildfly.security.http.util.sso.SingleSignOnConfiguration(this.cookieName, this.domain, this.path, this.httpOnly, this.secure);
        }
    }
}

