/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.crypto.SecretKey;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wildfly.common.Assert;
import org.wildfly.common.bytes.ByteStringBuilder;
import org.wildfly.common.codec.Base32Alphabet;
import org.wildfly.common.codec.Base64Alphabet;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.realm.ElytronMessages;
import org.wildfly.security.auth.realm.FileSystemSecurityRealmBuilder;
import org.wildfly.security.auth.realm.IdentitySharedExclusiveLock;
import org.wildfly.security.auth.realm.IntegrityException;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableRealmIdentityIterator;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.PublicKeyCredential;
import org.wildfly.security.credential.X509CertificateChainPublicCredential;
import org.wildfly.security.encryption.CipherUtil;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.OneTimePassword;
import org.wildfly.security.password.spec.BasicPasswordSpecEncoding;
import org.wildfly.security.password.spec.Encoding;
import org.wildfly.security.password.spec.OneTimePasswordSpec;
import org.wildfly.security.password.spec.PasswordSpec;
import org.wildfly.security.password.util.ModularCrypt;
import org.wildfly.security.permission.ElytronPermission;
import org.wildfly.security.provider.util.ProviderUtil;
import org.xml.sax.SAXException;

public final class FileSystemSecurityRealm
implements ModifiableSecurityRealm,
CacheableSecurityRealm {
    static final ElytronPermission CREATE_SECURITY_REALM = ElytronPermission.forName("createSecurityRealm");
    private final Supplier<Provider[]> providers;
    static final Map<String, Version> KNOWN_NAMESPACES;
    private final Path root;
    private final NameRewriter nameRewriter;
    private final int levels;
    private final boolean encoded;
    private final Charset hashCharset;
    private final Encoding hashEncoding;
    private final SecretKey secretKey;
    private final PrivateKey privateKey;
    private final PublicKey publicKey;
    private final ConcurrentHashMap<String, IdentitySharedExclusiveLock> realmIdentityLocks = new ConcurrentHashMap();

    public static FileSystemSecurityRealmBuilder builder() {
        return new FileSystemSecurityRealmBuilder();
    }

    public FileSystemSecurityRealm(Path root, NameRewriter nameRewriter, int levels, boolean encoded, Encoding hashEncoding, Charset hashCharset, Supplier<Provider[]> providers, SecretKey secretKey, PrivateKey privateKey, PublicKey publicKey) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_SECURITY_REALM);
        }
        this.root = root;
        this.nameRewriter = nameRewriter;
        this.levels = levels;
        this.encoded = secretKey == null && encoded;
        this.hashCharset = hashCharset != null ? hashCharset : StandardCharsets.UTF_8;
        this.hashEncoding = hashEncoding != null ? hashEncoding : Encoding.BASE64;
        this.providers = providers != null ? providers : ProviderUtil.INSTALLED_PROVIDERS;
        this.secretKey = secretKey;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public FileSystemSecurityRealm(Path root, NameRewriter nameRewriter, int levels, boolean encoded, Encoding hashEncoding, Charset hashCharset, SecretKey secretKey) {
        this(root, nameRewriter, levels, encoded, hashEncoding, hashCharset, ProviderUtil.INSTALLED_PROVIDERS, secretKey, null, null);
    }

    public FileSystemSecurityRealm(Path root, NameRewriter nameRewriter, int levels, boolean encoded, Encoding hashEncoding, Charset hashCharset) {
        this(root, nameRewriter, levels, encoded, hashEncoding, hashCharset, ProviderUtil.INSTALLED_PROVIDERS, null, null, null);
    }

    public FileSystemSecurityRealm(Path root, NameRewriter nameRewriter, int levels, boolean encoded) {
        this(root, nameRewriter, levels, encoded, Encoding.BASE64, StandardCharsets.UTF_8, ProviderUtil.INSTALLED_PROVIDERS, null, null, null);
    }

    public FileSystemSecurityRealm(Path root, NameRewriter nameRewriter, int levels) {
        this(root, nameRewriter, levels, true);
    }

    public FileSystemSecurityRealm(Path root, NameRewriter nameRewriter, int levels, Encoding hashEncoding, Charset hashCharset) {
        this(root, nameRewriter, levels, true, hashEncoding, hashCharset, ProviderUtil.INSTALLED_PROVIDERS, null, null, null);
    }

    public FileSystemSecurityRealm(Path root, int levels) {
        this(root, NameRewriter.IDENTITY_REWRITER, levels, true);
    }

    public FileSystemSecurityRealm(Path root, int levels, Encoding hashEncoding, Charset hashCharset) {
        this(root, NameRewriter.IDENTITY_REWRITER, levels, true, hashEncoding, hashCharset, ProviderUtil.INSTALLED_PROVIDERS, null, null, null);
    }

    public FileSystemSecurityRealm(Path root) {
        this(root, NameRewriter.IDENTITY_REWRITER, 2, true);
    }

    public FileSystemSecurityRealm(Path root, Encoding hashEncoding, Charset hashCharset) {
        this(root, NameRewriter.IDENTITY_REWRITER, 2, true, hashEncoding, hashCharset, ProviderUtil.INSTALLED_PROVIDERS, null, null, null);
    }

    public FileSystemSecurityRealm(Path root, int levels, Supplier<Provider[]> providers) {
        this(root, NameRewriter.IDENTITY_REWRITER, levels, true, Encoding.BASE64, StandardCharsets.UTF_8, providers, null, null, null);
    }

    public boolean hasIntegrityEnabled() {
        return this.privateKey != null && this.publicKey != null;
    }

    private Path pathFor(String name) {
        assert (name.codePointCount(0, name.length()) > 0);
        String normalizedName = name;
        if (this.encoded) {
            normalizedName = Normalizer.normalize(name, Normalizer.Form.NFKC).toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9]", "_");
        }
        if (this.secretKey != null || this.encoded) {
            String base32 = ByteIterator.ofBytes((byte[])new ByteStringBuilder().append(name).toArray()).base32Encode(Base32Alphabet.STANDARD, false).drainToString();
            normalizedName = this.secretKey != null ? base32 : normalizedName + "-" + base32;
        }
        Path path = this.root;
        int idx = 0;
        for (int level = 0; level < this.levels; ++level) {
            int newIdx = normalizedName.offsetByCodePoints(idx, 1);
            path = path.resolve(normalizedName.substring(idx, newIdx));
            idx = newIdx;
            if (idx == normalizedName.length()) break;
        }
        return path.resolve(normalizedName + ".xml");
    }

    public Charset getHashCharset() {
        return this.hashCharset;
    }

    private String nameFor(Path path) {
        String fileName = path.toString();
        fileName = fileName.substring(0, fileName.length() - 4);
        if (this.secretKey != null) {
            CodePointIterator it = CodePointIterator.ofString((String)fileName);
            fileName = it.base32Decode(Base32Alphabet.STANDARD, false).asUtf8String().drainToString();
        } else if (this.encoded) {
            CodePointIterator it = CodePointIterator.ofString((String)fileName);
            it.delimitedBy(new int[]{45}).skipAll();
            it.next();
            fileName = it.base32Decode(Base32Alphabet.STANDARD, false).asUtf8String().drainToString();
        }
        return fileName;
    }

    @Override
    public RealmIdentity getRealmIdentity(Principal principal) {
        return NamePrincipal.isConvertibleTo(principal) ? this.getRealmIdentity(principal.getName(), false) : RealmIdentity.NON_EXISTENT;
    }

    @Override
    public ModifiableRealmIdentity getRealmIdentityForUpdate(Principal principal) {
        return NamePrincipal.isConvertibleTo(principal) ? this.getRealmIdentity(principal.getName(), true) : ModifiableRealmIdentity.NON_EXISTENT;
    }

    @Override
    public void registerIdentityChangeListener(Consumer<Principal> listener) {
    }

    private ModifiableRealmIdentity getRealmIdentity(String name, boolean exclusive) {
        String finalName = this.nameRewriter.rewriteName(name);
        if (finalName == null) {
            throw ElytronMessages.log.invalidName();
        }
        IdentitySharedExclusiveLock realmIdentityLock = this.getRealmIdentityLockForName(finalName);
        IdentitySharedExclusiveLock.IdentityLock lock = exclusive ? realmIdentityLock.lockExclusive() : realmIdentityLock.lockShared();
        return new Identity(finalName, this.pathFor(finalName), lock, this.hashCharset, this.hashEncoding, this.providers, this.secretKey, this.privateKey, this.publicKey, this.hasIntegrityEnabled());
    }

    @Override
    public ModifiableRealmIdentityIterator getRealmIdentityIterator() throws RealmUnavailableException {
        return this.subIterator(this.root, this.levels);
    }

    private ModifiableRealmIdentityIterator subIterator(Path root, final int levels) {
        Iterator<Path> iterator;
        DirectoryStream<Path> stream;
        if (levels == 0) {
            Iterator<Path> iterator2;
            DirectoryStream<Path> stream2;
            try {
                stream2 = Files.newDirectoryStream(root, "*.xml");
                iterator2 = stream2.iterator();
            }
            catch (IOException e) {
                ElytronMessages.log.debug("Unable to open directory", e);
                return ModifiableRealmIdentityIterator.emptyIterator();
            }
            return new ModifiableRealmIdentityIterator(){

                @Override
                public boolean hasNext() {
                    if (!iterator2.hasNext()) {
                        try {
                            this.close();
                        }
                        catch (IOException e) {
                            ElytronMessages.log.debug("Unable to close the stream", e);
                        }
                    }
                    return iterator2.hasNext();
                }

                @Override
                public ModifiableRealmIdentity next() {
                    Path path = (Path)iterator2.next();
                    String name = FileSystemSecurityRealm.this.nameFor(path.getFileName());
                    return FileSystemSecurityRealm.this.getRealmIdentityForUpdate(new NamePrincipal(name));
                }

                @Override
                public void close() throws RealmUnavailableException {
                    try {
                        stream2.close();
                    }
                    catch (IOException e) {
                        ElytronMessages.log.debug("Unable to close the stream", e);
                    }
                }
            };
        }
        try {
            stream = Files.newDirectoryStream(root, entry -> {
                String fileName = entry.getFileName().toString();
                return fileName.length() == 1 && !fileName.equals(".") && Files.isDirectory(entry, new LinkOption[0]);
            });
            iterator = stream.iterator();
        }
        catch (IOException e) {
            ElytronMessages.log.debug("Unable to open directory", e);
            return ModifiableRealmIdentityIterator.emptyIterator();
        }
        return new ModifiableRealmIdentityIterator(){
            private ModifiableRealmIdentityIterator subIterator;

            @Override
            public boolean hasNext() {
                while (true) {
                    if (this.subIterator == null) {
                        if (!iterator.hasNext()) {
                            try {
                                this.close();
                            }
                            catch (IOException e) {
                                ElytronMessages.log.debug("Unable to close the stream", e);
                            }
                            return false;
                        }
                        Path path = (Path)iterator.next();
                        this.subIterator = FileSystemSecurityRealm.this.subIterator(path, levels - 1);
                        continue;
                    }
                    if (this.subIterator.hasNext()) {
                        return true;
                    }
                    this.subIterator = null;
                }
            }

            @Override
            public ModifiableRealmIdentity next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return (ModifiableRealmIdentity)this.subIterator.next();
            }

            @Override
            public void close() throws RealmUnavailableException {
                try {
                    if (this.subIterator != null) {
                        this.subIterator.close();
                    }
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        ElytronMessages.log.debug("Unable to close the stream", e);
                    }
                }
            }
        };
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    private IdentitySharedExclusiveLock getRealmIdentityLockForName(String name) {
        IdentitySharedExclusiveLock newRealmIdentityLock;
        IdentitySharedExclusiveLock realmIdentityLock = this.realmIdentityLocks.get(name);
        if (realmIdentityLock == null && (realmIdentityLock = this.realmIdentityLocks.putIfAbsent(name, newRealmIdentityLock = new IdentitySharedExclusiveLock())) == null) {
            realmIdentityLock = newRealmIdentityLock;
        }
        return realmIdentityLock;
    }

    public void updateRealmKeyPair() throws RealmUnavailableException {
        if (!this.hasIntegrityEnabled()) {
            throw ElytronMessages.log.integrityNotEnabled(this.root.toString());
        }
        ModifiableRealmIdentityIterator realmIterator = this.getRealmIdentityIterator();
        while (realmIterator.hasNext()) {
            Identity identity = (Identity)realmIterator.next();
            try {
                identity.writeDigitalSignature(identity.path, identity.name);
            }
            finally {
                identity.dispose();
            }
        }
        realmIterator.close();
    }

    public IntegrityResult verifyRealmIntegrity() throws RealmUnavailableException {
        if (!this.hasIntegrityEnabled()) {
            throw ElytronMessages.log.integrityNotEnabled(this.root.toString());
        }
        ArrayList<String> failedIdentities = new ArrayList<String>();
        ModifiableRealmIdentityIterator realmIterator = this.getRealmIdentityIterator();
        while (realmIterator.hasNext()) {
            Identity identity = (Identity)realmIterator.next();
            if (!identity.isIntegrityValid()) {
                failedIdentities.add(identity.name);
            }
            identity.dispose();
        }
        realmIterator.close();
        return new IntegrityResult(failedIdentities.isEmpty(), failedIdentities);
    }

    static {
        HashMap<String, Version> knownNamespaces = new HashMap<String, Version>();
        for (Version version : Version.values()) {
            knownNamespaces.put(version.namespace, version);
        }
        KNOWN_NAMESPACES = Collections.unmodifiableMap(knownNamespaces);
    }

    public static class IntegrityResult {
        private final boolean valid;
        private final ArrayList<String> identityNames;

        IntegrityResult(boolean valid, ArrayList<String> identityNames) {
            this.valid = valid;
            this.identityNames = identityNames;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getIdentityNames() {
            return this.identityNames.toString();
        }
    }

    static class AutoCloseableXMLStreamWriterHolder
    implements AutoCloseable {
        private final XMLStreamWriter xmlStreamWriter;

        AutoCloseableXMLStreamWriterHolder(XMLStreamWriter xmlStreamWriter) {
            this.xmlStreamWriter = xmlStreamWriter;
        }

        @Override
        public void close() throws XMLStreamException {
            this.xmlStreamWriter.close();
        }

        public XMLStreamWriter getXmlStreamWriter() {
            return this.xmlStreamWriter;
        }
    }

    static class AutoCloseableXMLStreamReaderHolder
    implements AutoCloseable {
        private final XMLStreamReader xmlStreamReader;

        AutoCloseableXMLStreamReaderHolder(XMLStreamReader xmlStreamReader) {
            this.xmlStreamReader = xmlStreamReader;
        }

        @Override
        public void close() throws XMLStreamException {
            this.xmlStreamReader.close();
        }

        public XMLStreamReader getXmlStreamReader() {
            return this.xmlStreamReader;
        }
    }

    protected static final class LoadedIdentity {
        private final String name;
        private final List<Credential> credentials;
        private final Attributes attributes;
        private final Encoding hashEncoding;

        LoadedIdentity(String name, List<Credential> credentials, Attributes attributes, Encoding hashEncoding) {
            this.name = name;
            this.credentials = credentials;
            this.attributes = attributes;
            this.hashEncoding = hashEncoding;
        }

        public String getName() {
            return this.name;
        }

        public Attributes getAttributes() {
            return this.attributes;
        }

        List<Credential> getCredentials() {
            return this.credentials;
        }

        public Encoding getHashEncoding() {
            return this.hashEncoding;
        }
    }

    static class Identity
    implements ModifiableRealmIdentity {
        private static final String ENCRYPTION_FORMAT = "enc_base64";
        private static final String BASE64_FORMAT = "base64";
        private static final String MCF_FORMAT = "crypt";
        private static final String X509_FORMAT = "X.509";
        private static final String HEX = "hex";
        private final String name;
        private final Path path;
        private final Supplier<Provider[]> providers;
        private IdentitySharedExclusiveLock.IdentityLock lock;
        private final Charset hashCharset;
        private final Encoding hashEncoding;
        private final SecretKey secretKey;
        private final PrivateKey privateKey;
        private final PublicKey publicKey;
        private final boolean integrityEnabled;

        Identity(String name, Path path, IdentitySharedExclusiveLock.IdentityLock lock, Charset hashCharset, Encoding hashEncoding, Supplier<Provider[]> providers, SecretKey secretKey, PrivateKey privateKey, PublicKey publicKey, boolean integrityEnabled) {
            this.name = name;
            this.path = path;
            this.lock = lock;
            this.hashCharset = hashCharset;
            this.hashEncoding = hashEncoding;
            this.providers = providers;
            this.secretKey = secretKey;
            this.privateKey = privateKey;
            this.publicKey = publicKey;
            this.integrityEnabled = integrityEnabled;
        }

        @Override
        public Principal getRealmIdentityPrincipal() {
            return new NamePrincipal(this.name);
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            List<Credential> credentials = this.loadCredentials();
            for (Credential credential : credentials) {
                if (!credential.matches(credentialType, algorithmName, parameterSpec)) continue;
                return SupportLevel.SUPPORTED;
            }
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return this.getCredential(credentialType, null);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            return this.getCredential(credentialType, algorithmName, null);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            List<Credential> credentials = this.loadCredentials();
            for (Credential credential : credentials) {
                if (!credential.matches(credentialType, algorithmName, parameterSpec)) continue;
                return (C)((Credential)credentialType.cast(credential.clone()));
            }
            return null;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidenceType", evidenceType);
            List<Credential> credentials = this.loadCredentials();
            for (Credential credential : credentials) {
                if (!credential.canVerify(evidenceType, algorithmName)) continue;
                ElytronMessages.log.tracef("FileSystemSecurityRealm - evidence verification SUPPORTED: type = [%s]  algorithm = [%s]  credentials = [%d]", (Object)evidenceType, (Object)algorithmName, (Object)credentials.size());
                return SupportLevel.SUPPORTED;
            }
            ElytronMessages.log.tracef("FileSystemSecurityRealm - evidence verification UNSUPPORTED: type = [%s]  algorithm = [%s]  credentials = [%d]", (Object)evidenceType, (Object)algorithmName, (Object)credentials.size());
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidence", (Object)evidence);
            if (ElytronMessages.log.isTraceEnabled()) {
                try {
                    LoadedIdentity loadedIdentity = this.loadIdentity(false, true);
                    ElytronMessages.log.tracef("Trying to authenticate identity %s using FileSystemSecurityRealm", (Object)(loadedIdentity != null ? loadedIdentity.getName() : "null"));
                }
                catch (RealmUnavailableException e) {
                    if (e.getCause() instanceof IntegrityException) {
                        return false;
                    }
                    throw e;
                }
            }
            List<Credential> credentials = null;
            try {
                credentials = this.loadCredentials();
            }
            catch (RealmUnavailableException e) {
                if (e.getCause() instanceof IntegrityException) {
                    return false;
                }
                throw e;
            }
            ElytronMessages.log.tracef("FileSystemSecurityRealm - verification evidence [%s] against [%d] credentials...", (Object)evidence, (Object)credentials.size());
            for (Credential credential : credentials) {
                if (!credential.canVerify(evidence)) continue;
                boolean verified = false;
                verified = credential instanceof PasswordCredential ? ((PasswordCredential)credential).verify(this.providers, evidence, this.hashCharset) : credential.verify(this.providers, evidence);
                ElytronMessages.log.tracef("FileSystemSecurityRealm - verification against credential [%s] = %b", (Object)credential, (Object)verified);
                return verified;
            }
            ElytronMessages.log.tracef("FileSystemSecurityRealm - no credential able to verify evidence [%s]", (Object)evidence);
            return false;
        }

        List<Credential> loadCredentials() throws RealmUnavailableException {
            LoadedIdentity loadedIdentity = this.loadIdentity(false, true);
            return loadedIdentity == null ? Collections.emptyList() : loadedIdentity.getCredentials();
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            if (System.getSecurityManager() == null) {
                return Files.exists(this.path, new LinkOption[0]);
            }
            return AccessController.doPrivileged(() -> Files.exists(this.path, new LinkOption[0]));
        }

        @Override
        public void delete() throws RealmUnavailableException {
            if (System.getSecurityManager() == null) {
                this.deletePrivileged();
                return;
            }
            try {
                AccessController.doPrivileged(this::deletePrivileged);
            }
            catch (PrivilegedActionException e) {
                if (e.getException() instanceof RealmUnavailableException) {
                    throw (RealmUnavailableException)e.getException();
                }
                throw new RuntimeException(e.getException());
            }
        }

        private Void deletePrivileged() throws RealmUnavailableException {
            try {
                Files.delete(this.path);
                return null;
            }
            catch (NoSuchFileException e) {
                throw ElytronMessages.log.fileSystemRealmNotFound(this.name);
            }
            catch (IOException e) {
                throw ElytronMessages.log.fileSystemRealmDeleteFailed(this.name, e);
            }
        }

        private String tempSuffix() {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            char[] array = new char[12];
            for (int i = 0; i < array.length; ++i) {
                int idx = random.nextInt(36);
                array[i] = idx < 26 ? (char)(65 + idx) : (char)(48 + idx - 26);
            }
            return new String(array);
        }

        private Path tempPath() {
            Path parent = this.path.getParent();
            File file = parent.toFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            return parent.resolve(this.path.getFileName().toString() + '.' + this.tempSuffix());
        }

        @Override
        public void create() throws RealmUnavailableException {
            if (System.getSecurityManager() == null) {
                this.createPrivileged();
                return;
            }
            try {
                AccessController.doPrivileged(this::createPrivileged);
            }
            catch (PrivilegedActionException e) {
                if (e.getException() instanceof RealmUnavailableException) {
                    throw (RealmUnavailableException)e.getException();
                }
                throw new RuntimeException(e.getException());
            }
        }

        private Void createPrivileged() throws RealmUnavailableException {
            Path tempPath;
            while (true) {
                tempPath = this.tempPath();
                XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newFactory();
                try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(tempPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW, StandardOpenOption.DSYNC));){
                    try (AutoCloseableXMLStreamWriterHolder holder = new AutoCloseableXMLStreamWriterHolder(xmlOutputFactory.createXMLStreamWriter(outputStream));){
                        String namespace = "";
                        namespace = this.integrityEnabled ? Version.VERSION_1_2.getNamespace() : (this.secretKey != null ? Version.VERSION_1_1.getNamespace() : Version.VERSION_1_0.getNamespace());
                        XMLStreamWriter streamWriter = holder.getXmlStreamWriter();
                        streamWriter.writeStartDocument();
                        streamWriter.writeCharacters("\n");
                        streamWriter.writeStartElement("identity");
                        streamWriter.writeDefaultNamespace(namespace);
                        if (this.integrityEnabled) {
                            streamWriter.writeCharacters("\n    ");
                            streamWriter.writeStartElement("principal");
                            streamWriter.writeAttribute("name", this.secretKey != null ? CipherUtil.encrypt(this.name, this.secretKey) : this.name);
                            streamWriter.writeEndElement();
                            streamWriter.writeCharacters("\n    ");
                        }
                        streamWriter.writeEndElement();
                        streamWriter.writeEndDocument();
                    }
                    catch (GeneralSecurityException | XMLStreamException e) {
                        throw ElytronMessages.log.fileSystemRealmFailedToWrite(tempPath, this.name, e);
                    }
                    if (!this.integrityEnabled) break;
                    try {
                        this.writeDigitalSignature(tempPath, this.name);
                    }
                    catch (RealmUnavailableException e) {
                        throw ElytronMessages.log.unableToGenerateSignature(this.path.toString());
                    }
                }
                catch (FileAlreadyExistsException ignored) {
                    continue;
                }
                catch (IOException e) {
                    throw ElytronMessages.log.fileSystemRealmFailedToOpen(tempPath, this.name, e);
                }
                break;
            }
            try {
                Files.createLink(this.path, tempPath);
            }
            catch (FileAlreadyExistsException e) {
                try {
                    Files.delete(tempPath);
                }
                catch (IOException e2) {
                    e.addSuppressed(e2);
                }
                throw ElytronMessages.log.fileSystemRealmAlreadyExists(this.name, e);
            }
            catch (IOException e) {
                throw ElytronMessages.log.fileSystemRealmFailedToWrite(tempPath, this.name, e);
            }
            try {
                Files.delete(tempPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void setCredentials(Collection<? extends Credential> credentials) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credential", credentials);
            LoadedIdentity loadedIdentity = this.loadIdentity(false, false);
            if (loadedIdentity == null) {
                throw ElytronMessages.log.fileSystemRealmNotFound(this.name);
            }
            LoadedIdentity newIdentity = new LoadedIdentity(this.name, new ArrayList<Credential>(credentials), loadedIdentity.getAttributes(), this.hashEncoding);
            this.replaceIdentity(newIdentity);
        }

        @Override
        public void setAttributes(Attributes attributes) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"attributes", (Object)attributes);
            LoadedIdentity loadedIdentity = this.loadIdentity(false, true);
            if (loadedIdentity == null) {
                throw ElytronMessages.log.fileSystemRealmNotFound(this.name);
            }
            LoadedIdentity newIdentity = new LoadedIdentity(this.name, loadedIdentity.getCredentials(), attributes, this.hashEncoding);
            this.replaceIdentity(newIdentity);
        }

        @Override
        public Attributes getAttributes() throws RealmUnavailableException {
            LoadedIdentity loadedIdentity = this.loadIdentity(true, false);
            if (loadedIdentity == null) {
                throw ElytronMessages.log.fileSystemRealmNotFound(this.name);
            }
            return loadedIdentity.getAttributes().asReadOnly();
        }

        private void replaceIdentity(LoadedIdentity newIdentity) throws RealmUnavailableException {
            if (System.getSecurityManager() == null) {
                this.replaceIdentityPrivileged(newIdentity);
                return;
            }
            try {
                AccessController.doPrivileged(() -> this.replaceIdentityPrivileged(newIdentity));
            }
            catch (PrivilegedActionException e) {
                if (e.getException() instanceof RealmUnavailableException) {
                    throw (RealmUnavailableException)e.getException();
                }
                throw new RuntimeException(e.getException());
            }
        }

        /*
         * Exception decompiling
         */
        private Void replaceIdentityPrivileged(LoadedIdentity newIdentity) throws RealmUnavailableException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [33[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private Version requiredVersion(LoadedIdentity identityToWrite) {
            if (this.integrityEnabled) {
                return Version.VERSION_1_2;
            }
            if (this.secretKey != null) {
                return Version.VERSION_1_1;
            }
            return Version.VERSION_1_0;
        }

        private void writeIdentity(XMLStreamWriter streamWriter, LoadedIdentity newIdentity) throws XMLStreamException, InvalidKeySpecException, NoSuchAlgorithmException, GeneralSecurityException {
            Iterator<Attributes.Entry> entryIter;
            streamWriter.writeStartDocument();
            streamWriter.writeCharacters("\n");
            streamWriter.writeStartElement("identity");
            streamWriter.writeDefaultNamespace(this.requiredVersion(newIdentity).getNamespace());
            if (this.integrityEnabled) {
                streamWriter.writeCharacters("\n    ");
                streamWriter.writeStartElement("principal");
                streamWriter.writeAttribute("name", this.secretKey != null ? CipherUtil.encrypt(this.name, this.secretKey) : this.name);
                streamWriter.writeEndElement();
            }
            if (newIdentity.getCredentials().size() > 0) {
                streamWriter.writeCharacters("\n    ");
                streamWriter.writeStartElement("credentials");
                for (Credential credential : newIdentity.getCredentials()) {
                    String passwordString;
                    String format;
                    streamWriter.writeCharacters("\n        ");
                    if (!(credential instanceof PasswordCredential)) continue;
                    Password password = ((PasswordCredential)credential).getPassword();
                    if (password instanceof OneTimePassword) {
                        OneTimePassword otp = (OneTimePassword)password;
                        streamWriter.writeStartElement("otp");
                        streamWriter.writeAttribute("algorithm", otp.getAlgorithm());
                        streamWriter.writeAttribute("hash", ByteIterator.ofBytes((byte[])otp.getHash()).base64Encode().drainToString());
                        streamWriter.writeAttribute("seed", ByteIterator.ofBytes((byte[])otp.getSeed().getBytes(StandardCharsets.US_ASCII)).base64Encode().drainToString());
                        streamWriter.writeAttribute("sequence", Integer.toString(otp.getSequenceNumber()));
                        streamWriter.writeEndElement();
                        continue;
                    }
                    streamWriter.writeStartElement("password");
                    String algorithm = password.getAlgorithm();
                    byte[] encoded = BasicPasswordSpecEncoding.encode(password, this.providers);
                    if (this.secretKey != null) {
                        format = ENCRYPTION_FORMAT;
                        passwordString = ByteIterator.ofBytes((byte[])CipherUtil.encrypt(encoded, this.secretKey)).base64Encode().drainToString();
                    } else if (encoded != null) {
                        if (newIdentity.getHashEncoding() == Encoding.HEX) {
                            format = HEX;
                            passwordString = ByteIterator.ofBytes((byte[])encoded).hexEncode().drainToString();
                        } else {
                            format = BASE64_FORMAT;
                            passwordString = ByteIterator.ofBytes((byte[])encoded).base64Encode().drainToString();
                        }
                    } else {
                        format = MCF_FORMAT;
                        passwordString = ModularCrypt.encodeAsString(password);
                    }
                    streamWriter.writeAttribute("algorithm", algorithm);
                    streamWriter.writeAttribute("format", format);
                    streamWriter.writeCharacters(passwordString);
                    streamWriter.writeEndElement();
                }
                streamWriter.writeCharacters("\n    ");
                streamWriter.writeEndElement();
            }
            if ((entryIter = newIdentity.getAttributes().entries().iterator()).hasNext()) {
                streamWriter.writeCharacters("\n    ");
                streamWriter.writeStartElement("attributes");
                do {
                    Attributes.Entry entry = entryIter.next();
                    for (String value : entry) {
                        streamWriter.writeCharacters("\n        ");
                        streamWriter.writeStartElement("attribute");
                        streamWriter.writeAttribute("name", this.secretKey != null ? CipherUtil.encrypt(entry.getKey(), this.secretKey) : entry.getKey());
                        streamWriter.writeAttribute("value", this.secretKey != null ? CipherUtil.encrypt(value, this.secretKey) : value);
                        streamWriter.writeEndElement();
                    }
                } while (entryIter.hasNext());
                streamWriter.writeCharacters("\n    ");
                streamWriter.writeEndElement();
                streamWriter.writeCharacters("\n");
            }
            streamWriter.writeCharacters("\n    ");
            streamWriter.writeEndElement();
            streamWriter.writeEndDocument();
        }

        @Override
        public void dispose() {
            IdentitySharedExclusiveLock.IdentityLock identityLock = this.lock;
            this.lock = null;
            if (identityLock != null) {
                identityLock.release();
            }
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            LoadedIdentity loadedIdentity = this.loadIdentity(true, false);
            return loadedIdentity == null ? AuthorizationIdentity.EMPTY : AuthorizationIdentity.basicIdentity(loadedIdentity.getAttributes());
        }

        private LoadedIdentity loadIdentity(boolean skipCredentials, boolean skipAttributes) throws RealmUnavailableException {
            if (System.getSecurityManager() == null) {
                return this.loadIdentityPrivileged(skipCredentials, skipAttributes);
            }
            try {
                return AccessController.doPrivileged(() -> this.loadIdentityPrivileged(skipCredentials, skipAttributes));
            }
            catch (PrivilegedActionException e) {
                if (e.getException() instanceof RealmUnavailableException) {
                    throw (RealmUnavailableException)e.getException();
                }
                throw new RuntimeException(e.getException());
            }
        }

        /*
         * Enabled aggressive exception aggregation
         */
        protected LoadedIdentity loadIdentityPrivileged(boolean skipCredentials, boolean skipAttributes) throws RealmUnavailableException {
            if (!this.isIntegrityValid()) {
                throw new RealmUnavailableException(ElytronMessages.log.invalidIdentitySignature(this.name));
            }
            try (InputStream inputStream = Files.newInputStream(this.path, StandardOpenOption.READ);){
                LoadedIdentity loadedIdentity;
                XMLInputFactory inputFactory = XMLInputFactory.newFactory();
                inputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
                inputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
                inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                inputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
                AutoCloseableXMLStreamReaderHolder holder = new AutoCloseableXMLStreamReaderHolder(inputFactory.createXMLStreamReader(inputStream, "UTF-8"));
                try {
                    XMLStreamReader streamReader = holder.getXmlStreamReader();
                    loadedIdentity = this.parseIdentity(streamReader, skipCredentials, skipAttributes);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            holder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (XMLStreamException e) {
                        throw ElytronMessages.log.fileSystemRealmFailedToRead(this.path, this.name, e);
                    }
                }
                holder.close();
                return loadedIdentity;
            }
            catch (FileNotFoundException | NoSuchFileException ignored) {
                return null;
            }
            catch (IOException e) {
                throw ElytronMessages.log.fileSystemRealmFailedToOpen(this.path, this.name, e);
            }
        }

        private LoadedIdentity parseIdentity(XMLStreamReader streamReader, boolean skipCredentials, boolean skipAttributes) throws RealmUnavailableException, XMLStreamException {
            Version version;
            int tag = streamReader.nextTag();
            if (tag != 1 || (version = this.identifyVersion(streamReader)) == null || !"identity".equals(streamReader.getLocalName())) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
            }
            return this.parseIdentityContents(streamReader, version, skipCredentials, skipAttributes);
        }

        private Version identifyVersion(XMLStreamReader streamReader) {
            return KNOWN_NAMESPACES.get(streamReader.getNamespaceURI());
        }

        private LoadedIdentity parseIdentityContents(XMLStreamReader streamReader, Version version, boolean skipCredentials, boolean skipAttributes) throws RealmUnavailableException, XMLStreamException {
            int attributeCount = streamReader.getAttributeCount();
            if (attributeCount > 0) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
            }
            List<Credential> credentials = Collections.emptyList();
            Attributes attributes = Attributes.EMPTY;
            boolean gotCredentials = false;
            boolean gotAttributes = false;
            while (true) {
                if (streamReader.isEndElement()) {
                    if (attributes == Attributes.EMPTY && !skipAttributes) {
                        attributes = new MapAttributes();
                    }
                    return new LoadedIdentity(this.name, credentials, attributes, this.hashEncoding);
                }
                if (!version.getNamespace().equals(streamReader.getNamespaceURI()) && !"http://www.w3.org/2000/09/xmldsig#".equals(streamReader.getNamespaceURI())) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
                }
                if ("principal".equals(streamReader.getLocalName())) {
                    if (version.isAtLeast(Version.VERSION_1_2)) {
                        this.consumeContent(streamReader);
                    } else {
                        throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
                    }
                }
                if (!gotCredentials && "credentials".equals(streamReader.getLocalName())) {
                    gotCredentials = true;
                    if (skipCredentials) {
                        this.consumeContent(streamReader);
                    } else {
                        credentials = this.parseCredentials(streamReader, version);
                    }
                } else if (!gotAttributes && "attributes".equals(streamReader.getLocalName())) {
                    gotAttributes = true;
                    if (skipAttributes) {
                        this.consumeContent(streamReader);
                    } else {
                        attributes = this.parseAttributes(streamReader, version);
                    }
                }
                streamReader.nextTag();
            }
        }

        private List<Credential> parseCredentials(XMLStreamReader streamReader, Version version) throws RealmUnavailableException, XMLStreamException {
            int attributeCount = streamReader.getAttributeCount();
            if (attributeCount > 0) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
            }
            if (streamReader.nextTag() == 2) {
                return Collections.emptyList();
            }
            ArrayList<Credential> credentials = new ArrayList<Credential>();
            do {
                if (!version.getNamespace().equals(streamReader.getNamespaceURI())) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
                }
                if ("password".equals(streamReader.getLocalName())) {
                    this.parsePassword(credentials, streamReader, version);
                    continue;
                }
                if ("public-key".equals(streamReader.getLocalName())) {
                    this.parsePublicKey(credentials, streamReader);
                    continue;
                }
                if ("certificate".equals(streamReader.getLocalName())) {
                    this.parseCertificate(credentials, streamReader);
                    continue;
                }
                if ("otp".equals(streamReader.getLocalName())) {
                    this.parseOtp(credentials, streamReader);
                    continue;
                }
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
            } while (streamReader.nextTag() != 2);
            return credentials;
        }

        private void parseCredential(XMLStreamReader streamReader, CredentialParseFunction function) throws RealmUnavailableException, XMLStreamException {
            int attributeCount = streamReader.getAttributeCount();
            String name = null;
            String algorithm = null;
            String format = null;
            for (int i = 0; i < attributeCount; ++i) {
                String namespace = streamReader.getAttributeNamespace(i);
                if (namespace != null && !namespace.equals("")) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), name);
                }
                String localName = streamReader.getAttributeLocalName(i);
                if ("name".equals(localName)) {
                    name = streamReader.getAttributeValue(i);
                    continue;
                }
                if ("algorithm".equals(localName)) {
                    algorithm = streamReader.getAttributeValue(i);
                    continue;
                }
                if ("format".equals(localName)) {
                    format = streamReader.getAttributeValue(i);
                    continue;
                }
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), name);
            }
            String text = streamReader.getElementText().trim();
            function.parseCredential(algorithm, format, text);
        }

        private void parseCertificate(List<Credential> credentials, XMLStreamReader streamReader) throws RealmUnavailableException, XMLStreamException {
            this.parseCredential(streamReader, (algorithm, format, text) -> {
                if (algorithm == null) {
                    algorithm = X509_FORMAT;
                }
                if (format == null) {
                    format = X509_FORMAT;
                }
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance(algorithm);
                    credentials.add(new X509CertificateChainPublicCredential((X509Certificate)certificateFactory.generateCertificate(CodePointIterator.ofString((String)text).base64Decode().asInputStream())));
                }
                catch (ClassCastException | CertificateException e) {
                    throw ElytronMessages.log.fileSystemRealmCertificateReadError(format, this.path, streamReader.getLocation().getLineNumber(), this.name);
                }
            });
        }

        private void parsePublicKey(List<Credential> credentials, XMLStreamReader streamReader) throws RealmUnavailableException, XMLStreamException {
            this.parseCredential(streamReader, (algorithm, format, text) -> {
                if (algorithm == null) {
                    throw ElytronMessages.log.fileSystemRealmMissingAttribute("algorithm", this.path, streamReader.getLocation().getLineNumber(), this.name);
                }
                if (format == null) {
                    format = X509_FORMAT;
                } else if (!X509_FORMAT.equals(format)) {
                    throw ElytronMessages.log.fileSystemRealmUnsupportedKeyFormat(format, this.path, streamReader.getLocation().getLineNumber(), this.name);
                }
                try {
                    KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
                    credentials.add(new PublicKeyCredential(keyFactory.generatePublic(new PKCS8EncodedKeySpec(CodePointIterator.ofString((String)text).base64Decode().drain()))));
                }
                catch (NoSuchAlgorithmException e) {
                    throw ElytronMessages.log.fileSystemRealmUnsupportedKeyAlgorithm(format, this.path, streamReader.getLocation().getLineNumber(), this.name, e);
                }
                catch (InvalidKeySpecException e) {
                    throw ElytronMessages.log.fileSystemRealmUnsupportedKeyFormat(format, this.path, streamReader.getLocation().getLineNumber(), this.name);
                }
            });
        }

        private void parsePassword(List<Credential> credentials, XMLStreamReader streamReader, Version version) throws XMLStreamException, RealmUnavailableException {
            this.parseCredential(streamReader, (algorithm, format, text) -> {
                block12: {
                    try {
                        if (ENCRYPTION_FORMAT.equals(format)) {
                            byte[] decryptedPasswordBytes;
                            if (!version.isAtLeast(Version.VERSION_1_1)) {
                                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
                            }
                            if (algorithm == null) {
                                throw ElytronMessages.log.fileSystemRealmMissingAttribute("algorithm", this.path, streamReader.getLocation().getLineNumber(), this.name);
                            }
                            PasswordFactory passwordFactory = PasswordFactory.getInstance(algorithm, this.providers);
                            byte[] encryptedPasswordBytes = CodePointIterator.ofChars((char[])text.toCharArray()).base64Decode().drain();
                            try {
                                decryptedPasswordBytes = CipherUtil.decrypt(encryptedPasswordBytes, this.secretKey);
                            }
                            catch (GeneralSecurityException e) {
                                throw ElytronMessages.log.fileSystemRealmDecryptionFailed(e);
                            }
                            PasswordSpec passwordSpec = BasicPasswordSpecEncoding.decode(decryptedPasswordBytes);
                            if (passwordSpec != null) {
                                credentials.add(new PasswordCredential(passwordFactory.generatePassword(passwordSpec)));
                                break block12;
                            }
                            throw ElytronMessages.log.fileSystemRealmInvalidPasswordAlgorithm(algorithm, this.path, streamReader.getLocation().getLineNumber(), this.name);
                        }
                        if (BASE64_FORMAT.equals(format) || HEX.equals(format)) {
                            if (algorithm == null) {
                                throw ElytronMessages.log.fileSystemRealmMissingAttribute("algorithm", this.path, streamReader.getLocation().getLineNumber(), this.name);
                            }
                            PasswordFactory passwordFactory = PasswordFactory.getInstance(algorithm, this.providers);
                            byte[] passwordBytes = BASE64_FORMAT.equals(format) ? CodePointIterator.ofChars((char[])text.toCharArray()).base64Decode().drain() : CodePointIterator.ofChars((char[])text.toCharArray()).hexDecode().drain();
                            PasswordSpec passwordSpec = BasicPasswordSpecEncoding.decode(passwordBytes);
                            if (passwordSpec != null) {
                                credentials.add(new PasswordCredential(passwordFactory.generatePassword(passwordSpec)));
                                break block12;
                            }
                            throw ElytronMessages.log.fileSystemRealmInvalidPasswordAlgorithm(algorithm, this.path, streamReader.getLocation().getLineNumber(), this.name);
                        }
                        if (MCF_FORMAT.equals(format)) {
                            credentials.add(new PasswordCredential(ModularCrypt.decode(text)));
                            break block12;
                        }
                        throw ElytronMessages.log.fileSystemRealmInvalidPasswordFormat(format, this.path, streamReader.getLocation().getLineNumber(), this.name);
                    }
                    catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                        throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
                    }
                }
            });
        }

        private void parseOtp(List<Credential> credentials, XMLStreamReader streamReader) throws XMLStreamException, RealmUnavailableException {
            String name = null;
            String algorithm = null;
            byte[] hash = null;
            String seed = null;
            int sequenceNumber = 0;
            int attributeCount = streamReader.getAttributeCount();
            for (int i = 0; i < attributeCount; ++i) {
                String namespace = streamReader.getAttributeNamespace(i);
                if (namespace != null && !namespace.equals("")) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), name);
                }
                String localName = streamReader.getAttributeLocalName(i);
                if ("name".equals(localName)) {
                    name = streamReader.getAttributeValue(i);
                    continue;
                }
                if ("algorithm".equals(localName)) {
                    algorithm = streamReader.getAttributeValue(i);
                    continue;
                }
                if ("hash".equals(localName)) {
                    hash = CodePointIterator.ofString((String)streamReader.getAttributeValue(i)).base64Decode(Base64Alphabet.STANDARD, false).drain();
                    continue;
                }
                if ("seed".equals(localName)) {
                    seed = new String(CodePointIterator.ofString((String)streamReader.getAttributeValue(i)).base64Decode(Base64Alphabet.STANDARD, false).drain(), StandardCharsets.US_ASCII);
                    continue;
                }
                if ("sequence".equals(localName)) {
                    sequenceNumber = Integer.parseInt(streamReader.getAttributeValue(i));
                    continue;
                }
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), name);
            }
            if (streamReader.nextTag() != 2) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), name);
            }
            try {
                if (algorithm == null) {
                    throw ElytronMessages.log.fileSystemRealmMissingAttribute("algorithm", this.path, streamReader.getLocation().getLineNumber(), name);
                }
                PasswordFactory passwordFactory = PasswordFactory.getInstance(algorithm, this.providers);
                Password password = passwordFactory.generatePassword(new OneTimePasswordSpec(hash, seed, sequenceNumber));
                credentials.add(new PasswordCredential(password));
            }
            catch (InvalidKeySpecException e) {
                throw ElytronMessages.log.fileSystemRealmInvalidOtpDefinition(this.path, streamReader.getLocation().getLineNumber(), name, e);
            }
            catch (NoSuchAlgorithmException e) {
                throw ElytronMessages.log.fileSystemRealmInvalidOtpAlgorithm(algorithm, this.path, streamReader.getLocation().getLineNumber(), name, e);
            }
        }

        private Attributes parseAttributes(XMLStreamReader streamReader, Version version) throws RealmUnavailableException, XMLStreamException {
            int attributeCount = streamReader.getAttributeCount();
            if (attributeCount > 0) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
            }
            int tag = streamReader.nextTag();
            if (tag == 2) {
                return Attributes.EMPTY;
            }
            MapAttributes attributes = new MapAttributes();
            do {
                if (!version.getNamespace().equals(streamReader.getNamespaceURI())) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
                }
                if (!"attribute".equals(streamReader.getLocalName())) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
                }
                this.parseAttribute(streamReader, attributes);
            } while (streamReader.nextTag() == 1);
            return attributes;
        }

        private void parseAttribute(XMLStreamReader streamReader, Attributes attributes) throws XMLStreamException, RealmUnavailableException {
            String name = null;
            String value = null;
            int attributeCount = streamReader.getAttributeCount();
            for (int i = 0; i < attributeCount; ++i) {
                String namespace = streamReader.getAttributeNamespace(i);
                if (namespace != null && !namespace.equals("")) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
                }
                if ("name".equals(streamReader.getAttributeLocalName(i))) {
                    name = streamReader.getAttributeValue(i);
                    continue;
                }
                if ("value".equals(streamReader.getAttributeLocalName(i))) {
                    value = streamReader.getAttributeValue(i);
                    continue;
                }
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
            }
            if (name == null) {
                throw ElytronMessages.log.fileSystemRealmMissingAttribute("name", this.path, streamReader.getLocation().getLineNumber(), this.name);
            }
            if (value == null) {
                throw ElytronMessages.log.fileSystemRealmMissingAttribute("value", this.path, streamReader.getLocation().getLineNumber(), this.name);
            }
            if (this.secretKey != null) {
                try {
                    attributes.addLast(CipherUtil.decrypt(name, this.secretKey), CipherUtil.decrypt(value, this.secretKey));
                }
                catch (GeneralSecurityException e) {
                    throw ElytronMessages.log.fileSystemRealmDecryptionFailed(e);
                }
            } else {
                attributes.addLast(name, value);
            }
            if (streamReader.nextTag() != 2) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.name);
            }
        }

        private void consumeContent(XMLStreamReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                switch (reader.next()) {
                    case 1: {
                        this.consumeContent(reader);
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            }
        }

        private boolean isIntegrityValid() {
            if (this.publicKey != null) {
                Document doc;
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                try {
                    doc = dbf.newDocumentBuilder().parse(this.path.toString());
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    return false;
                }
                return this.validatePrincipalName(doc) && this.validateDigitalSignature(doc);
            }
            return true;
        }

        private boolean validateDigitalSignature(Document doc) {
            try {
                NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
                if (nl.getLength() == 0) {
                    throw ElytronMessages.log.cannotFindSignature(this.path.toString());
                }
                XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
                DOMValidateContext valContext = new DOMValidateContext(this.publicKey, nl.item(0));
                XMLSignature signature = fac.unmarshalXMLSignature(valContext);
                boolean coreValidity = signature.validate(valContext);
                ElytronMessages.log.tracef("FileSystemSecurityRealm - verification against signature for credential [%s] = %b", (Object)this.name, (Object)coreValidity);
                return coreValidity;
            }
            catch (IOException | MarshalException | XMLSignatureException e) {
                ElytronMessages.log.tracef("FileSystemSecurityRealm - Error during verification. Signature for credential [%s] failed", (Object)this.name);
                return false;
            }
        }

        private boolean validatePrincipalName(Document doc) {
            NodeList nl = doc.getElementsByTagName("principal");
            if (nl.getLength() == 0) {
                ElytronMessages.log.tracef("FileSystemSecurityRealm - verification against principal for credential [%s] = %b", (Object)this.name, (Object)false);
                return false;
            }
            String principalName = nl.item(0).getAttributes().getNamedItem("name").getNodeValue();
            if (this.secretKey != null) {
                try {
                    principalName = CipherUtil.decrypt(principalName, this.secretKey);
                }
                catch (GeneralSecurityException e) {
                    ElytronMessages.log.tracef("FileSystemSecurityRealm - verification against principal for credential [%s] = %b", (Object)this.name, (Object)false);
                    return false;
                }
            }
            boolean validity = Objects.equals(principalName, this.name);
            ElytronMessages.log.tracef("FileSystemSecurityRealm - verification against principal for credential [%s] = %b", (Object)this.name, (Object)validity);
            return validity;
        }

        private void writeDigitalSignature(Path path, String name) throws RealmUnavailableException {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                DocumentBuilder builder = dbf.newDocumentBuilder();
                Document doc = builder.parse(Files.newInputStream(path, new OpenOption[0]));
                Element elem = doc.getDocumentElement();
                NodeList signatureNode = doc.getElementsByTagName("Signature");
                if (signatureNode.getLength() > 0) {
                    Node sig = signatureNode.item(0);
                    elem.removeChild(sig);
                }
                DOMSignContext dsc = new DOMSignContext(this.privateKey, (Node)elem);
                XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
                Reference ref = fac.newReference("", fac.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null), Collections.singletonList(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null)), null, null);
                String signatureMethod = "";
                switch (this.publicKey.getAlgorithm()) {
                    case "DSA": {
                        signatureMethod = "http://www.w3.org/2009/xmldsig11#dsa-sha256";
                        break;
                    }
                    case "RSA": {
                        signatureMethod = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
                        break;
                    }
                    case "HMAC": {
                        signatureMethod = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
                        break;
                    }
                    case "EC": {
                        signatureMethod = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256";
                    }
                }
                SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), fac.newSignatureMethod(signatureMethod, null), Collections.singletonList(ref));
                KeyInfoFactory kif = fac.getKeyInfoFactory();
                KeyValue kv = kif.newKeyValue(this.publicKey);
                KeyInfo ki = kif.newKeyInfo(Collections.singletonList(kv));
                XMLSignature signature = fac.newXMLSignature(si, ki);
                signature.sign(dsc);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                FileWriter writer = new FileWriter(String.valueOf(path));
                StreamResult result = new StreamResult(writer);
                transformer.transform(source, result);
                ElytronMessages.log.tracef("FileSystemSecurityRealm - signature against file updated [%s]", (Object)name);
                writer.close();
            }
            catch (IOException | InvalidAlgorithmParameterException | KeyException | NoSuchAlgorithmException | MarshalException | XMLSignatureException | ParserConfigurationException | TransformerException | SAXException e) {
                ElytronMessages.log.tracef("FileSystemSecurityRealm - Error during signature generation against identity [%s]", (Object)name);
                throw ElytronMessages.log.unableToGenerateSignature(String.valueOf(this.path));
            }
        }
    }

    @FunctionalInterface
    static interface CredentialParseFunction {
        public void parseCredential(String var1, String var2, String var3) throws RealmUnavailableException, XMLStreamException;
    }

    private static enum Version {
        VERSION_1_0("urn:elytron:1.0", null),
        VERSION_1_0_1("urn:elytron:1.0.1", VERSION_1_0),
        VERSION_1_1("urn:elytron:identity:1.1", VERSION_1_0_1),
        VERSION_1_2("urn:elytron:identity:1.2", VERSION_1_1);

        final String namespace;
        final Version parent;

        private Version(String namespace, Version parent) {
            this.namespace = namespace;
            this.parent = parent;
        }

        String getNamespace() {
            return this.namespace;
        }

        boolean isAtLeast(Version version) {
            return this.equals((Object)version) || this.parent != null && this.parent.isAtLeast(version);
        }
    }
}

