/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import org.wildfly.security.password.interfaces.MaskedPassword;
import org.wildfly.security.password.interfaces.RawPassword;

final class RawMaskedPassword
extends RawPassword
implements MaskedPassword {
    private static final long serialVersionUID = -4344349209404192377L;
    private final char[] initialKeyMaterial;
    private final int iterationCount;
    private final byte[] salt;
    private final byte[] maskedPasswordBytes;

    RawMaskedPassword(String algorithm, char[] initialKeyMaterial, int iterationCount, byte[] salt, byte[] maskedPasswordBytes) {
        super(algorithm);
        this.initialKeyMaterial = initialKeyMaterial;
        this.iterationCount = iterationCount;
        this.salt = salt;
        this.maskedPasswordBytes = maskedPasswordBytes;
    }

    @Override
    public char[] getInitialKeyMaterial() {
        return (char[])this.initialKeyMaterial.clone();
    }

    @Override
    public int getIterationCount() {
        return this.iterationCount;
    }

    @Override
    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    @Override
    public byte[] getMaskedPasswordBytes() {
        return (byte[])this.maskedPasswordBytes.clone();
    }

    @Override
    public RawMaskedPassword clone() {
        return this;
    }
}

