/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.tool;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.crypto.SecretKey;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.wildfly.security.auth.realm.FileSystemRealmUtil;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.realm.FileSystemSecurityRealmBuilder;
import org.wildfly.security.password.spec.Encoding;
import org.wildfly.security.tool.Command;
import org.wildfly.security.tool.ElytronToolMessages;
import org.wildfly.security.tool.Params;
import org.wildfly.security.tool.help.DescriptionSection;
import org.wildfly.security.tool.help.HelpCommand;
import org.wildfly.security.tool.help.OptionsSection;
import org.wildfly.security.tool.help.UsageSection;

class FileSystemEncryptRealmCommand
extends Command {
    static final String FILE_SYSTEM_ENCRYPT_COMMAND = "filesystem-realm-encrypt";
    private static final String POPULATE_SECRET_KEY_PARAM = "populate";
    private static final String DEFAULT_FILESYSTEM_REALM_NAME = "encrypted-filesystem-realm";
    private final List<Descriptor> descriptors = new ArrayList<Descriptor>();
    private final List<String> PARAMS_LIST = new ArrayList<String>(Arrays.asList("input-location", "output-location"));
    private final Options options;
    private final CommandLineParser parser = new DefaultParser();
    private CommandLine cmdLine = null;
    private boolean silentMode = false;
    private boolean summaryMode = false;
    private StringBuilder summaryString = null;
    private boolean warningOccurred = false;

    FileSystemEncryptRealmCommand() {
        this.options = new Options();
        Option option = new Option("i", "input-location", true, ElytronToolMessages.msg.cmdFileSystemEncryptInputLocationDesc());
        option.setArgName("directory");
        this.options.addOption(option);
        option = new Option("r", "realm-name", true, ElytronToolMessages.msg.cmdFileSystemEncryptNewRealmDesc());
        option.setArgName("directory");
        this.options.addOption(option);
        option = new Option("o", "output-location", true, ElytronToolMessages.msg.cmdFileSystemEncryptOutputLocationDesc());
        option.setArgName("directory");
        this.options.addOption(option);
        option = new Option("c", "credential-store", true, ElytronToolMessages.msg.cmdFileSystemEncryptCredentialStoreDesc());
        option.setArgName("file");
        this.options.addOption(option);
        option = new Option("a", "create", true, ElytronToolMessages.msg.cmdFileSystemEncryptCreateCredentialStoreDesc());
        option.setArgName("name");
        this.options.addOption(option);
        option = new Option("s", "secret-key", true, ElytronToolMessages.msg.cmdFileSystemEncryptSecretKeyDesc());
        option.setArgName("name");
        this.options.addOption(option);
        this.options.addOption(Option.builder((String)"k").longOpt("keystore").desc(ElytronToolMessages.msg.cmdFileSystemEncryptKeyStoreDesc()).hasArg().argName("file").build());
        this.options.addOption(Option.builder((String)"t").longOpt("type").desc(ElytronToolMessages.msg.cmdFileSystemEncryptKeyStoreTypeDesc()).hasArg().argName("name").build());
        this.options.addOptionGroup(new OptionGroup().addOption(Option.builder().longOpt("password").desc(ElytronToolMessages.msg.cmdFileSystemEncryptKeyStorePassword()).hasArg().argName("password").build()).addOption(Option.builder().longOpt("password-env").desc(ElytronToolMessages.msg.cmdFileSystemEncryptKeyStorePasswordEnv()).hasArg().argName("name").build()));
        this.options.addOption(Option.builder((String)"y").longOpt("key-pair").desc(ElytronToolMessages.msg.cmdFileSystemEncryptKeyPairAliasDesc()).hasArg().argName("name").build());
        option = new Option("e", "hash-encoding", true, ElytronToolMessages.msg.cmdFileSystemEncryptHashEncodingDesc());
        option.setArgName("name");
        this.options.addOption(option);
        option = new Option("u", "hash-charset", true, ElytronToolMessages.msg.cmdFileSystemRealmIntegrityHashCharsetDesc());
        option.setArgName("name");
        this.options.addOption(option);
        option = new Option("f", "encoded", true, ElytronToolMessages.msg.cmdFileSystemEncryptEncodedDesc());
        option.setArgName("name");
        this.options.addOption(option);
        option = new Option("l", "levels", true, ElytronToolMessages.msg.cmdFileSystemEncryptLevelsDesc());
        option.setArgName("name");
        this.options.addOption(option);
        option = new Option("p", POPULATE_SECRET_KEY_PARAM, true, ElytronToolMessages.msg.cmdFileSystemRealmEncryptPopulateDesc());
        option.setArgName("name");
        this.options.addOption(option);
        option = new Option("b", "bulk-convert", true, ElytronToolMessages.msg.cmdFileSystemRealmEncryptBulkConvertDesc());
        option.setArgName("file");
        this.options.addOption(option);
        option = new Option("w", "overwrite-script-file", true, ElytronToolMessages.msg.cmdFileSystemRealmOverwriteCliScriptFileDesc());
        option.setArgName("true/false");
        this.options.addOption(option);
        option = Option.builder().longOpt("help").desc(ElytronToolMessages.msg.cmdLineHelp()).build();
        this.options.addOption(option);
        option = Option.builder().longOpt("debug").desc(ElytronToolMessages.msg.cmdLineDebug()).build();
        this.options.addOption(option);
        option = Option.builder().longOpt("silent").desc(ElytronToolMessages.msg.cmdFileSystemRealmSilentDesc()).build();
        this.options.addOption(option);
        option = Option.builder().longOpt("summary").desc(ElytronToolMessages.msg.cmdFileSystemRealmSummaryDesc()).build();
        this.options.addOption(option);
    }

    @Override
    public void execute(String[] args) throws Exception {
        this.setStatus(7);
        this.cmdLine = this.parser.parse(this.options, args, false);
        this.setEnableDebug(this.cmdLine.hasOption("debug"));
        if (this.cmdLine.hasOption("help")) {
            this.help();
            this.setStatus(0);
            return;
        }
        if (this.cmdLine.hasOption("silent")) {
            this.silentMode = true;
        }
        if (this.cmdLine.hasOption("summary")) {
            this.summaryMode = true;
            this.summaryString = new StringBuilder();
            this.summaryString.append(Params.SUMMARY_DIVIDER);
            this.summaryString.append(Params.LINE_SEPARATOR);
            this.summaryString.append("Summary for execution of Elytron-Tool command FileSystemRealmEncrypt");
            this.summaryString.append(Params.LINE_SEPARATOR);
            this.summaryString.append(Params.SUMMARY_DIVIDER);
            this.summaryString.append(Params.LINE_SEPARATOR);
        }
        this.printDuplicatesWarning(this.cmdLine);
        String realmNameOption = this.cmdLine.getOptionValue("r");
        String inputRealmLocationOption = this.cmdLine.getOptionValue("i");
        String outputRealmLocationOption = this.cmdLine.getOptionValue("o");
        String credentialStoreOption = this.cmdLine.getOptionValue("c");
        String createCredentialStore = this.cmdLine.getOptionValue("a");
        String secretKeyAliasOption = this.cmdLine.getOptionValue("s");
        String keyStoreLocationOption = this.cmdLine.getOptionValue("k");
        String keyStoreTypeOption = this.cmdLine.getOptionValue("t");
        String passwordOption = this.cmdLine.getOptionValue("password");
        String passwordEnvOption = this.cmdLine.getOptionValue("password-env");
        String keyPairAliasOption = this.cmdLine.getOptionValue("y");
        String hashEncodingOption = this.cmdLine.getOptionValue("e");
        String hashCharsetOption = this.cmdLine.getOptionValue("u");
        String levelsOption = this.cmdLine.getOptionValue("l");
        String encodedOption = this.cmdLine.getOptionValue("f");
        String bulkConvert = this.cmdLine.getOptionValue("b");
        String populateOption = this.cmdLine.getOptionValue("p");
        String overwriteScriptFileOption = this.cmdLine.getOptionValue("w");
        if (bulkConvert == null) {
            if (realmNameOption == null) {
                realmNameOption = DEFAULT_FILESYSTEM_REALM_NAME;
            }
            Descriptor descriptor = new Descriptor();
            descriptor.setFileSystemRealmName(realmNameOption);
            if (outputRealmLocationOption == null) {
                this.errorHandler((Exception)ElytronToolMessages.msg.outputLocationNotSpecified());
            } else {
                File outputPath = new File(outputRealmLocationOption);
                if (!outputPath.exists()) {
                    outputPath.mkdirs();
                }
                descriptor.setOutputRealmLocation(Paths.get(outputRealmLocationOption, new String[0]).toString());
            }
            if (inputRealmLocationOption == null) {
                this.errorHandler((Exception)ElytronToolMessages.msg.inputLocationNotSpecified());
            } else {
                Path inputPath = Paths.get(inputRealmLocationOption, new String[0]);
                descriptor.setInputRealmLocation(inputPath.toString());
                if (Files.notExists(inputPath, new LinkOption[0])) {
                    this.errorHandler((Exception)ElytronToolMessages.msg.inputLocationDoesNotExist());
                }
            }
            if (hashEncodingOption == null) {
                descriptor.setHashEncoding(Encoding.BASE64);
            } else {
                try {
                    descriptor.setHashEncoding(Encoding.valueOf((String)hashEncodingOption.toUpperCase()));
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    this.errorHandler(e);
                }
            }
            if (hashCharsetOption == null) {
                descriptor.setHashCharset(StandardCharsets.UTF_8);
            } else {
                try {
                    descriptor.setHashCharset(Charset.forName(hashCharsetOption.toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    this.errorHandler(e);
                }
            }
            if (populateOption == null) {
                descriptor.setPopulate(true);
            } else {
                descriptor.setPopulate(Boolean.valueOf(populateOption));
            }
            if (overwriteScriptFileOption != null) {
                descriptor.setOverwriteScriptFile(Boolean.valueOf(overwriteScriptFileOption));
            }
            if (levelsOption == null) {
                descriptor.setLevels(Params.DEFAULT_LEVELS);
            } else {
                try {
                    descriptor.setLevels(Integer.parseInt(levelsOption));
                }
                catch (NumberFormatException e) {
                    this.errorHandler(e);
                }
            }
            if (encodedOption == null) {
                descriptor.setEncoded(true);
            } else {
                try {
                    descriptor.setEncoded(Boolean.parseBoolean(encodedOption));
                }
                catch (IllegalArgumentException e) {
                    this.errorHandler(e);
                }
            }
            if (createCredentialStore != null) {
                descriptor.setCreateCredentialStore(Boolean.valueOf(createCredentialStore));
            } else {
                descriptor.setCreateCredentialStore(true);
            }
            if (credentialStoreOption != null) {
                descriptor.setCredentialStore(credentialStoreOption);
            } else {
                this.errorHandler((Exception)ElytronToolMessages.msg.credentialStoreDoesNotExist());
            }
            if (secretKeyAliasOption != null) {
                descriptor.setSecretKeyAlias(secretKeyAliasOption);
            } else {
                descriptor.setSecretKeyAlias("key");
            }
            if (keyStoreLocationOption != null) {
                if (Files.notExists(Paths.get(keyStoreLocationOption, new String[0]), new LinkOption[0])) {
                    throw ElytronToolMessages.msg.keyStoreDoesNotExist();
                }
                descriptor.setKeyStoreLocation(keyStoreLocationOption);
            }
            descriptor.setKeyStoreType(keyStoreTypeOption);
            if (keyStoreLocationOption != null) {
                if (passwordOption == null && passwordEnvOption == null) {
                    passwordOption = this.prompt(false, ElytronToolMessages.msg.keyStorePasswordPrompt(), false, null);
                    if (passwordOption == null) {
                        throw ElytronToolMessages.msg.optionNotSpecified("password or password-env");
                    }
                } else if (passwordEnvOption != null) {
                    descriptor.setPasswordEnv(passwordEnvOption);
                    passwordOption = System.getenv(passwordEnvOption);
                }
                if (keyPairAliasOption != null) {
                    descriptor.setKeyPairAlias(keyPairAliasOption);
                } else {
                    descriptor.setKeyPairAlias("integrity-key");
                }
            }
            descriptor.setPassword(passwordOption);
            this.descriptors.add(descriptor);
            this.checkDescriptorFields(descriptor);
        } else {
            if (inputRealmLocationOption != null || outputRealmLocationOption != null || secretKeyAliasOption != null || realmNameOption != null || credentialStoreOption != null || createCredentialStore != null || keyStoreLocationOption != null || keyStoreTypeOption != null || keyPairAliasOption != null || passwordOption != null || passwordEnvOption != null || hashEncodingOption != null || hashCharsetOption != null || encodedOption != null || levelsOption != null || populateOption != null) {
                throw ElytronToolMessages.msg.mutuallyExclusiveOptionsEncryptSpecified();
            }
            if (this.summaryMode) {
                this.summaryString.append(String.format("Options were specified via descriptor file: %s, converting multiple old filesystem realm", bulkConvert));
                this.summaryString.append(Params.LINE_SEPARATOR);
            }
            this.parseDescriptorFile(bulkConvert);
        }
        this.createFileSystemRealm();
        this.createWildFlyScript();
        if (this.summaryMode) {
            this.summaryString.append(Params.SUMMARY_DIVIDER);
            this.summaryString.append(Params.LINE_SEPARATOR);
            this.summaryString.append("End of summary");
            this.summaryString.append(Params.LINE_SEPARATOR);
            this.summaryString.append(Params.SUMMARY_DIVIDER);
            System.out.println(this.summaryString);
        }
        if (this.warningOccurred) {
            this.setStatus(1);
        } else {
            this.setStatus(0);
        }
    }

    @Override
    public void help() {
        OptionsSection optionsSection = new OptionsSection(ElytronToolMessages.msg.cmdLineActionsHelpHeader(), this.options);
        UsageSection usageSection = new UsageSection(FILE_SYSTEM_ENCRYPT_COMMAND, null);
        DescriptionSection descriptionSection = new DescriptionSection(ElytronToolMessages.msg.cmdFileSystemEncryptHelpHeader());
        HelpCommand helpCommand = HelpCommand.HelpCommandBuilder.builder().description(descriptionSection).usage(usageSection).options(optionsSection).build();
        helpCommand.printHelp();
    }

    @Override
    protected void warningHandler(String warning) {
        this.warningOccurred = true;
        if (!this.silentMode) {
            System.out.print("WARNING: ");
            System.out.println(warning);
        }
        if (this.summaryMode) {
            this.summaryString.append("WARNING: ");
            this.summaryString.append(warning);
            this.summaryString.append(Params.LINE_SEPARATOR);
        }
    }

    @Override
    protected void errorHandler(Exception e) throws Exception {
        this.setStatus(7);
        if (this.summaryMode) {
            this.summaryString.append("Error was thrown during execution:");
            this.summaryString.append(Params.LINE_SEPARATOR);
            this.summaryString.append(e.getMessage());
            System.out.println(Params.LINE_SEPARATOR + this.summaryString.toString());
        }
        throw e;
    }

    private void printDescriptorBlocks(int count) {
        this.summaryString.append(Params.LINE_SEPARATOR);
        this.summaryString.append(Params.LINE_SEPARATOR);
        this.summaryString.append("Found following unencrypted filesystem-realm combinations, null indicates missing required component:");
        this.summaryString.append(Params.LINE_SEPARATOR);
        for (int i = 0; i < count; ++i) {
            StringBuilder summary = new StringBuilder();
            summary.append("\tPrinting summary for block ");
            summary.append(i + 1);
            summary.append(Params.LINE_SEPARATOR);
            Descriptor descriptor = this.descriptors.get(i);
            for (String param : this.PARAMS_LIST) {
                summary.append("\t\t");
                summary.append(param);
                summary.append(" - ");
                summary.append(this.getDescriptorParam(param, descriptor));
                summary.append(Params.LINE_SEPARATOR);
            }
            this.summaryString.append((CharSequence)summary);
        }
        this.summaryString.append(Params.LINE_SEPARATOR);
    }

    private String getDescriptorParam(String param, Descriptor descriptor) {
        switch (param) {
            case "input-location": {
                return descriptor.getInputRealmLocation();
            }
            case "output-location": {
                return descriptor.getOutputRealmLocation();
            }
            case "realm-name": {
                return descriptor.getFileSystemRealmName();
            }
            case "credential-store": {
                return descriptor.getCredentialStore();
            }
            case "secret-key": {
                return descriptor.getSecretKeyAlias();
            }
        }
        return null;
    }

    private void parseDescriptorFile(String file) throws Exception {
        Path path = Paths.get(file, new String[0]);
        if (!path.toFile().exists()) {
            this.errorHandler(ElytronToolMessages.msg.fileNotFound(file));
        }
        Descriptor descriptor = new Descriptor();
        AtomicInteger count = new AtomicInteger(1);
        try (Stream<String> stream = Files.lines(path);){
            stream.forEach(line -> {
                if (line.equals("")) {
                    if (descriptor.getPasswordEnv() != null) {
                        descriptor.setPassword(System.getenv(descriptor.getPasswordEnv()));
                    }
                    this.findMissingRequiredValuesAndSetValues(count.intValue(), descriptor);
                    this.copyAddResetDescriptor(descriptor);
                    count.getAndIncrement();
                } else {
                    String[] parts = line.split(":");
                    String option = parts[0];
                    String arg = parts[1];
                    switch (option) {
                        case "input-location": {
                            descriptor.setInputRealmLocation(arg);
                            break;
                        }
                        case "output-location": {
                            descriptor.setOutputRealmLocation(arg);
                            break;
                        }
                        case "realm-name": {
                            descriptor.setFileSystemRealmName(arg);
                            break;
                        }
                        case "credential-store": {
                            descriptor.setCredentialStore(arg);
                            break;
                        }
                        case "secret-key": {
                            descriptor.setSecretKeyAlias(arg);
                            break;
                        }
                        case "create": {
                            descriptor.setCreateCredentialStore(Boolean.parseBoolean(arg));
                            break;
                        }
                        case "keystore": {
                            descriptor.setKeyStoreLocation(arg);
                            break;
                        }
                        case "type": {
                            descriptor.setKeyStoreType(arg);
                            break;
                        }
                        case "password": {
                            descriptor.setPassword(arg);
                            break;
                        }
                        case "password-env": {
                            descriptor.setPasswordEnv(arg);
                            break;
                        }
                        case "key-pair": {
                            descriptor.setKeyPairAlias(arg);
                            break;
                        }
                        case "hash-encoding": {
                            descriptor.setHashEncoding(Encoding.valueOf((String)arg.toUpperCase()));
                            break;
                        }
                        case "hash-charset": {
                            descriptor.setHashCharset(Charset.forName(arg.toUpperCase()));
                            break;
                        }
                        case "encoded": {
                            descriptor.setEncoded(Boolean.parseBoolean(arg));
                            break;
                        }
                        case "levels": {
                            descriptor.setLevels(Integer.parseInt(arg));
                            break;
                        }
                        case "populate": {
                            descriptor.setPopulate(Boolean.parseBoolean(arg));
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            this.errorHandler(e);
        }
        int currentCount = count.intValue();
        this.findMissingRequiredValuesAndSetValues(currentCount, descriptor);
        this.copyAddResetDescriptor(descriptor);
        if (this.summaryMode) {
            this.printDescriptorBlocks(currentCount);
        }
        count.getAndIncrement();
    }

    private void copyAddResetDescriptor(Descriptor original) {
        Descriptor temp = new Descriptor(original);
        this.descriptors.add(temp);
        original.reset();
    }

    private void findMissingRequiredValuesAndSetValues(int count, Descriptor descriptor) {
        boolean missingRequiredValue = false;
        if (descriptor.getInputRealmLocation() == null) {
            this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlockInputLocation(count));
            missingRequiredValue = true;
        }
        if (descriptor.getOutputRealmLocation() == null) {
            this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlockOutputLocation(count));
            missingRequiredValue = true;
        }
        if (descriptor.getFileSystemRealmName() == null) {
            descriptor.setFileSystemRealmName("encrypted-filesystem-realm-" + UUID.randomUUID());
        }
        if (descriptor.getHashEncoding() == null) {
            descriptor.setHashEncoding(Encoding.BASE64);
        }
        if (descriptor.getHashCharset() == null) {
            descriptor.setHashCharset(StandardCharsets.UTF_8);
        }
        if (descriptor.getEncoded() == null) {
            descriptor.setEncoded(true);
        }
        if (descriptor.getLevels() == null) {
            descriptor.setLevels(Params.DEFAULT_LEVELS);
        }
        if (descriptor.getCredentialStore() == null) {
            this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlockCredentialStoreLocation(count));
            missingRequiredValue = true;
        }
        if (descriptor.getCreateCredentialStore() == null) {
            descriptor.setCreateCredentialStore(true);
        }
        if (descriptor.getPopulate() == null) {
            descriptor.setPopulate(true);
        }
        if (descriptor.getSecretKeyAlias() == null) {
            descriptor.setSecretKeyAlias("key");
        }
        if (descriptor.getKeyStoreLocation() != null && descriptor.getPassword() == null && descriptor.getPasswordEnv() == null) {
            this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlockPassword(count));
            missingRequiredValue = true;
        }
        if (descriptor.getKeyStoreLocation() != null && descriptor.getKeyPairAlias() == null) {
            descriptor.setKeyPairAlias("integrity-key");
        }
        if (missingRequiredValue) {
            descriptor.reset();
        }
    }

    private void createFileSystemRealm() throws Exception {
        int blockCount = 0;
        for (Descriptor descriptor : this.descriptors) {
            FileSystemSecurityRealm oldRealm;
            ++blockCount;
            System.out.println(ElytronToolMessages.msg.fileSystemRealmEncryptCreatingRealm(descriptor.getInputRealmLocation()));
            if (this.checkDescriptorFields(descriptor)) {
                descriptor.reset();
                continue;
            }
            SecretKey key = this.getSecretKey(descriptor.getCreateCredentialStore(), descriptor.getCredentialStore(), descriptor.getSecretKeyAlias(), descriptor.getPopulate(), blockCount);
            if (key == null) {
                descriptor.reset();
                continue;
            }
            FileSystemSecurityRealmBuilder oldFileSystemRealmBuilder = FileSystemSecurityRealm.builder().setRoot(Paths.get(descriptor.getInputRealmLocation(), new String[0])).setLevels(descriptor.getLevels().intValue()).setHashEncoding(descriptor.getHashEncoding()).setHashCharset(descriptor.getHashCharset()).setEncoded(descriptor.getEncoded().booleanValue()).setProviders(ELYTRON_KS_PASS_PROVIDERS);
            FileSystemSecurityRealmBuilder newFileSystemRealmBuilder = FileSystemSecurityRealm.builder().setRoot(Paths.get(descriptor.getOutputRealmLocation(), descriptor.getFileSystemRealmName())).setSecretKey(key).setLevels(descriptor.getLevels().intValue()).setProviders(ELYTRON_KS_PASS_PROVIDERS).setHashCharset(descriptor.getHashCharset());
            if (descriptor.getKeyStoreLocation() != null) {
                KeyPair keyPair = this.getKeyPair(Paths.get(descriptor.getKeyStoreLocation(), new String[0]), descriptor.getKeyStoreType(), descriptor.getKeyPairAlias(), descriptor.getPassword(), blockCount);
                if (keyPair != null) {
                    oldFileSystemRealmBuilder.setPublicKey(keyPair.getPublic()).setPrivateKey(keyPair.getPrivate());
                    newFileSystemRealmBuilder.setPublicKey(keyPair.getPublic()).setPrivateKey(keyPair.getPrivate());
                } else {
                    descriptor.reset();
                    continue;
                }
            }
            if (!(oldRealm = oldFileSystemRealmBuilder.build()).getRealmIdentityIterator().hasNext()) {
                this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlockEmptyRealm(blockCount));
                descriptor.reset();
                continue;
            }
            FileSystemRealmUtil.cloneIdentitiesToNewRealm((FileSystemSecurityRealm)oldRealm, (FileSystemSecurityRealm)newFileSystemRealmBuilder.build());
        }
    }

    private void createWildFlyScript() throws Exception {
        int counter = 0;
        for (Descriptor descriptor : this.descriptors) {
            if (this.checkDescriptorFields(descriptor)) continue;
            String outputRealmLocation = descriptor.getOutputRealmLocation();
            String fileSystemRealmName = descriptor.getFileSystemRealmName();
            String credentialStore = descriptor.getCredentialStore();
            String secretKeyAlias = descriptor.getSecretKeyAlias();
            int levels = descriptor.getLevels();
            Charset hashCharset = descriptor.getHashCharset();
            String keyStoreLocation = descriptor.getKeyStoreLocation();
            String keyStoreType = descriptor.getKeyStoreType();
            char[] password = descriptor.getPassword();
            String keyPairAlias = descriptor.getKeyPairAlias();
            Boolean overwriteScript = descriptor.getOverwriteScriptFile();
            if (hashCharset == null) {
                hashCharset = StandardCharsets.UTF_8;
            }
            if (secretKeyAlias == null) {
                secretKeyAlias = "key";
            }
            if (keyStoreLocation != null && keyPairAlias == null) {
                keyPairAlias = "integrity-key";
            }
            String createScriptCheck = "";
            Path scriptPath = Paths.get(String.format("%s/%s.cli", outputRealmLocation, fileSystemRealmName), new String[0]);
            if (overwriteScript == null) {
                if (scriptPath.toFile().exists() && (createScriptCheck = this.prompt(true, ElytronToolMessages.msg.shouldFileBeOverwritten(scriptPath.toString()), false, null)).trim().isEmpty()) {
                    createScriptCheck = "n";
                }
                overwriteScript = createScriptCheck.isEmpty() || createScriptCheck.toLowerCase().startsWith("y");
            }
            if (!overwriteScript.booleanValue()) {
                while ((scriptPath = Paths.get(String.format("%s/%s.cli", outputRealmLocation, fileSystemRealmName + "-" + UUID.randomUUID()), new String[0])).toFile().exists()) {
                }
            }
            String fullOutputPath = outputRealmLocation.startsWith(".") ? Paths.get(outputRealmLocation.substring(2), new String[0]).toAbsolutePath().toString() : Paths.get(outputRealmLocation, new String[0]).toAbsolutePath().toString();
            if (this.summaryMode) {
                this.summaryString.append(String.format("Configured script for WildFly at %s", scriptPath));
                this.summaryString.append(Params.LINE_SEPARATOR);
                this.summaryString.append("The script is using the following names:");
                this.summaryString.append(Params.LINE_SEPARATOR);
                this.summaryString.append(String.format("Name of filesystem-realm: %s", fileSystemRealmName));
                this.summaryString.append(Params.LINE_SEPARATOR);
            }
            ArrayList<String> scriptLines = new ArrayList<String>(Arrays.asList(String.format("/subsystem=elytron/secret-key-credential-store=%s:add(path=%s)", "mycredstore" + counter, credentialStore), String.format("/subsystem=elytron/filesystem-realm=%s:add(path=%s, levels=%s, credential-store=%s, secret-key=%s%s%s%s%s)", fileSystemRealmName, fullOutputPath + '/' + fileSystemRealmName, levels, "mycredstore" + counter, secretKeyAlias, hashCharset != StandardCharsets.UTF_8 ? ", hash-charset=" + hashCharset.name() : "", keyStoreLocation != null ? ", key-store=mykeystore" + counter : "", keyPairAlias != null ? ", key-store-alias=" + keyPairAlias : "", password != null ? ", credential-reference={clear-text=" + Arrays.toString(password) + "}" : "")));
            if (keyStoreLocation != null) {
                scriptLines.add(1, String.format("/subsystem=elytron/key-store=%s:add(path=%s, credential-reference={clear-text=%s}%s)", "mykeystore" + counter, keyStoreLocation, Arrays.toString(password), keyStoreType != null ? ", type=" + keyStoreType : ""));
            }
            if (overwriteScript.booleanValue()) {
                Files.write(scriptPath, scriptLines, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            } else {
                Files.write(scriptPath, scriptLines, StandardOpenOption.CREATE);
            }
            ++counter;
        }
    }

    private boolean checkDescriptorFields(Descriptor descriptor) {
        if (descriptor.getInputRealmLocation() == null || descriptor.getOutputRealmLocation() == null || descriptor.getFileSystemRealmName() == null || descriptor.getCredentialStore() == null || descriptor.getCreateCredentialStore() == null || descriptor.getSecretKeyAlias() == null || descriptor.getHashEncoding() == null || descriptor.getHashCharset() == null || descriptor.getEncoded() == null || descriptor.getLevels() == null || descriptor.getPopulate() == null || descriptor.getKeyStoreLocation() != null && descriptor.getPassword() == null && descriptor.getPasswordEnv() == null) {
            this.warningHandler(ElytronToolMessages.msg.fileSystemEncryptRequiredParametersNotSpecified());
            return true;
        }
        return false;
    }

    private static final class Descriptor {
        private String inputRealmLocation;
        private String outputRealmLocation;
        private String fileSystemRealmName;
        private String credentialStore;
        private String secretKeyAlias;
        private String keyStoreLocation;
        private String keyStoreType;
        private char[] password;
        private String passwordEnv;
        private String keyPairAlias;
        private Integer levels;
        private Encoding hashEncoding;
        private Charset hashCharset;
        private Boolean encoded;
        private Boolean createCredentialStore;
        private Boolean populate;
        private Boolean overwriteScriptFile;

        Descriptor() {
        }

        Descriptor(Descriptor descriptor) {
            this.inputRealmLocation = descriptor.inputRealmLocation;
            this.outputRealmLocation = descriptor.outputRealmLocation;
            this.fileSystemRealmName = descriptor.fileSystemRealmName;
            this.credentialStore = descriptor.credentialStore;
            this.keyStoreLocation = descriptor.keyStoreLocation;
            this.keyStoreType = descriptor.keyStoreType;
            this.password = descriptor.password;
            this.passwordEnv = descriptor.passwordEnv;
            this.keyPairAlias = descriptor.keyPairAlias;
            this.hashEncoding = descriptor.hashEncoding;
            this.levels = descriptor.levels;
            this.encoded = descriptor.encoded;
            this.hashCharset = descriptor.hashCharset;
            this.createCredentialStore = descriptor.createCredentialStore;
            this.secretKeyAlias = descriptor.secretKeyAlias;
            this.populate = descriptor.populate;
            this.overwriteScriptFile = descriptor.overwriteScriptFile;
        }

        public Encoding getHashEncoding() {
            return this.hashEncoding;
        }

        public void setHashEncoding(Encoding hashEncoding) {
            this.hashEncoding = hashEncoding;
        }

        public Charset getHashCharset() {
            return this.hashCharset;
        }

        public void setHashCharset(Charset hashCharset) {
            this.hashCharset = hashCharset;
        }

        public Integer getLevels() {
            return this.levels;
        }

        public void setLevels(Integer levels) {
            this.levels = levels;
        }

        public String getInputRealmLocation() {
            return this.inputRealmLocation;
        }

        public void setInputRealmLocation(String inputRealmLocation) {
            this.inputRealmLocation = inputRealmLocation;
        }

        public String getOutputRealmLocation() {
            return this.outputRealmLocation;
        }

        public void setOutputRealmLocation(String outputRealmLocation) {
            this.outputRealmLocation = outputRealmLocation;
        }

        public String getFileSystemRealmName() {
            return this.fileSystemRealmName;
        }

        public void setFileSystemRealmName(String fileSystemRealmName) {
            this.fileSystemRealmName = fileSystemRealmName;
        }

        public Boolean getEncoded() {
            return this.encoded;
        }

        public void setEncoded(boolean encoded) {
            this.encoded = encoded;
        }

        String getCredentialStore() {
            return this.credentialStore;
        }

        void setCredentialStore(String credentialStore) {
            this.credentialStore = credentialStore;
        }

        Boolean getCreateCredentialStore() {
            return this.createCredentialStore;
        }

        void setCreateCredentialStore(Boolean createCredentialStore) {
            this.createCredentialStore = createCredentialStore;
        }

        String getSecretKeyAlias() {
            return this.secretKeyAlias;
        }

        void setSecretKeyAlias(String secretKeyAlias) {
            this.secretKeyAlias = secretKeyAlias;
        }

        Boolean getPopulate() {
            return this.populate;
        }

        void setPopulate(Boolean populate) {
            this.populate = populate;
        }

        String getKeyStoreLocation() {
            return this.keyStoreLocation;
        }

        void setKeyStoreLocation(String keyStoreLocation) {
            this.keyStoreLocation = keyStoreLocation;
        }

        String getKeyStoreType() {
            return this.keyStoreType;
        }

        void setKeyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
        }

        char[] getPassword() {
            return this.password;
        }

        void setPassword(String password) {
            if (password != null) {
                this.password = password.toCharArray();
            }
        }

        String getPasswordEnv() {
            return this.passwordEnv;
        }

        void setPasswordEnv(String passwordEnv) {
            this.passwordEnv = passwordEnv;
        }

        String getKeyPairAlias() {
            return this.keyPairAlias;
        }

        void setKeyPairAlias(String keyPairAlias) {
            this.keyPairAlias = keyPairAlias;
        }

        public Boolean getOverwriteScriptFile() {
            return this.overwriteScriptFile;
        }

        public void setOverwriteScriptFile(Boolean overwriteScriptFile) {
            this.overwriteScriptFile = overwriteScriptFile;
        }

        void reset() {
            this.inputRealmLocation = null;
            this.outputRealmLocation = null;
            this.fileSystemRealmName = null;
            this.credentialStore = null;
            this.createCredentialStore = null;
            this.secretKeyAlias = null;
            this.keyStoreLocation = null;
            this.keyStoreType = null;
            this.password = null;
            this.passwordEnv = null;
            this.keyPairAlias = null;
            this.hashEncoding = null;
            this.hashCharset = null;
            this.encoded = null;
            this.levels = null;
            this.populate = null;
            this.overwriteScriptFile = null;
        }
    }
}

